/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.repository;

import com.wudsn.thecart.common.ASCIIString;

public final class DataType {
    private Class<?> valueClass;
    private String label;
    private String toolTip;
    private int maximumLength;
    private String allowedCharacters;

    public DataType(Class<?> valueClass) {
        if (valueClass == null) {
            throw new IllegalArgumentException("Parameter 'valueClass' must not be null.");
        }
        this.valueClass = valueClass;
        this.label = "";
        this.toolTip = "";
        this.maximumLength = -1;
        this.allowedCharacters = null;
    }

    public DataType(Class<String> valueClass, int maximumLength, String allowedCharacters) {
        this(valueClass);
        this.maximumLength = maximumLength;
        this.allowedCharacters = allowedCharacters;
    }

    public DataType(Class<ASCIIString> valueClass, int maximumLength, ASCIIString allowedCharacters) {
        this(valueClass);
        this.maximumLength = maximumLength;
        this.allowedCharacters = allowedCharacters.toString();
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabelWithoutMnemonics() {
        return this.label.replaceAll("&", "");
    }

    public String getToolTip() {
        return this.toolTip;
    }

    final void setTexts(String label, String toolTip) {
        if (label == null) {
            throw new IllegalArgumentException("Parameter 'label' must not be null.");
        }
        if (toolTip == null) {
            throw new IllegalArgumentException("Parameter 'toolTip' must not be null.");
        }
        this.label = label;
        this.toolTip = toolTip;
    }

    public String getAllowedCharacters() {
        return this.allowedCharacters;
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    public String toString() {
        return "label=" + this.label;
    }
}

