/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.ui;

import com.wudsn.thecart.Messages;
import com.wudsn.thecart.Texts;
import com.wudsn.thecart.common.Application;
import com.wudsn.thecart.common.TextUtility;
import com.wudsn.thecart.gui.SimpleDialog;
import com.wudsn.thecart.model.CartridgeDatabase;
import com.wudsn.thecart.model.CartridgeMenu;
import com.wudsn.thecart.model.CartridgeMenuType;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class AboutDialog
extends SimpleDialog {
    private CartridgeDatabase cartridgeDatabase;
    private JLabel contentLabel;

    public AboutDialog(JFrame parent, CartridgeDatabase cartridgeDatabase) {
        super(parent, Texts.MainTitle, true);
        if (cartridgeDatabase == null) {
            throw new IllegalArgumentException("Parameter 'cartridgeDatabase' must not be null.");
        }
        this.cartridgeDatabase = cartridgeDatabase;
    }

    @Override
    protected void initComponents(JDialog dialog) {
        Container pane = dialog.getContentPane();
        this.contentLabel = new JLabel();
        JPanel panel = new JPanel();
        panel.add(this.contentLabel);
        pane.add((Component)panel, "Center");
        this.contentLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 0) {
                    try {
                        Desktop.getDesktop().browse(new URI(Texts.AboutDialog_URL));
                    }
                    catch (IOException iOException) {
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
            }
        });
        this.dataToUI();
        dialog.setSize(230, 200);
        this.initButtonBar();
    }

    @Override
    protected void dataToUI() {
        String content = Texts.AboutDialog_Content;
        Application application = Application.getInstance();
        String localVersion = application.getLocalVersion();
        String webVersion = application.getWebVersion();
        content = content.replace("$localVersion$", localVersion);
        CartridgeMenu cartridgeMenu = CartridgeMenu.createInstance(CartridgeMenuType.SIMPLE);
        String cartridgeMenuVersion = cartridgeMenu.getVersion();
        cartridgeMenuVersion = !cartridgeMenu.isExternal() ? Messages.I130.format(cartridgeMenuVersion) : Messages.I131.format(cartridgeMenuVersion, cartridgeMenu.getExternalFilePath());
        content = content.replace("$cartridgeMenuVersion$", cartridgeMenuVersion);
        content = content.replace("$knownTitlesCount$", TextUtility.formatAsDecimal(this.cartridgeDatabase.getKnownTitelsCount()));
        content = content.replace("$knownContentTypesCount$", TextUtility.formatAsDecimal(this.cartridgeDatabase.getKnownContentTypesCount()));
        content = content.replace("$knownContentTypesCount$", TextUtility.formatAsDecimal(this.cartridgeDatabase.getKnownContentTypesCount()));
        String javaRuntimeVersion = String.valueOf(System.getProperty("java.runtime.name")) + " " + System.getProperty("java.runtime.version");
        String osVersion = String.valueOf(System.getProperty("os.name")) + " (" + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + ")";
        content = content.replace("$javaRuntimeVersion$", javaRuntimeVersion);
        content = content.replace("$osVersion$", osVersion);
        String update = localVersion.equals(webVersion) ? Messages.I133.format(new String[0]) : (!localVersion.equals("????-??-?? ??:??:??") && !webVersion.equals("????-??-?? ??:??:??") ? (localVersion.compareTo(webVersion) < 0 ? Messages.I134.format(webVersion) : Messages.I135.format(webVersion)) : Messages.I136.format(webVersion));
        content = content.replace("$update", update);
        this.contentLabel.setText(content);
    }
}

