/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.ui;

import com.wudsn.thecart.common.ClassPathUtility;
import com.wudsn.thecart.common.Log;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class BankColors {
    public static final Color RESERVED;
    public static final Color RESERVED_USER_SPACE;
    public static final Color USED1;
    public static final Color USED2;
    public static final Color FREE;
    public static final Color CONFLICT;
    public static final Color REQUIRED;
    public static final Color NOT_AVAILABLE;
    private static final Map<Color, Color> lineColorMap;

    static {
        Properties properties;
        block19: {
            lineColorMap = new HashMap<Color, Color>();
            properties = new Properties();
            InputStream inputStream = null;
            File jarFolder = ClassPathUtility.getJarFolder();
            if (jarFolder != null) {
                try {
                    inputStream = new FileInputStream(new File(jarFolder, "BankColors.properties"));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (inputStream == null) {
                inputStream = ClassPathUtility.class.getClassLoader().getResourceAsStream("data/BankColors.properties");
            }
            if (inputStream == null) {
                throw new RuntimeException("No bank color resources found.");
            }
            try {
                try {
                    properties.load(inputStream);
                }
                catch (IOException iOException) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        System.out.println(properties);
        RESERVED = BankColors.readColor(properties, "RESERVED");
        RESERVED_USER_SPACE = BankColors.readColor(properties, "RESERVED_USER_SPACE");
        USED1 = BankColors.readColor(properties, "USED1");
        USED2 = BankColors.readColor(properties, "USED2");
        FREE = BankColors.readColor(properties, "FREE");
        CONFLICT = BankColors.readColor(properties, "CONFLICT");
        REQUIRED = USED1;
        NOT_AVAILABLE = CONFLICT;
    }

    private BankColors() {
    }

    private static Color readColor(Properties properties, String key) {
        int rgb;
        if (properties == null) {
            throw new IllegalArgumentException("Parameter 'properties' must not be null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("Parameter 'key' must not be null.");
        }
        String value = (String)properties.get(key);
        if (value == null) {
            throw new RuntimeException("No bank color defined for key '" + key + "'.");
        }
        try {
            rgb = Integer.parseInt(value.substring(2), 16);
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("Invalid color '" + value + "' defined for key '" + key + "'.");
        }
        Log.logInfo("Color {0}=0x{1}", new Object[]{key, Integer.toHexString(rgb)});
        return new Color(rgb);
    }

    private static Color makeBrighter(Color color, float factor) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        r = (int)((float)r * factor);
        g = (int)((float)g * factor);
        b = (int)((float)b * factor);
        if (r > 255) {
            r = 255;
        }
        if (g > 255) {
            g = 255;
        }
        if (b > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    public static Color getLineColor(Color color) {
        if (color == null) {
            return color;
        }
        Color lineColor = lineColorMap.get(color);
        if (lineColor == null) {
            lineColor = BankColors.makeBrighter(color, 0.8f);
            lineColorMap.put(color, lineColor);
        }
        return lineColor;
    }
}

