/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.ui;

import com.wudsn.thecart.model.ContentType;
import com.wudsn.thecart.model.FlashTargetType;
import com.wudsn.thecart.repository.ValueSet;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

public final class ContentTypeComboxBoxModelFactory {
    public ComboBoxModel<ContentType> getModel(boolean filterByFileContentSize, int fileContentSize, FlashTargetType flashTargetType, ContentType currentContentType) {
        if (flashTargetType == null) {
            throw new IllegalArgumentException("Parameter 'flashTargetType' must not be null.");
        }
        int key = fileContentSize <= 0 ? 0 : (fileContentSize % 1024 == 0 ? fileContentSize / 1024 : Integer.MAX_VALUE);
        List<ContentType> contentTypes = ContentType.getValues();
        ArrayList<ContentType> relevantContentTypes = new ArrayList<ContentType>();
        if (filterByFileContentSize) {
            switch (key) {
                case 0: {
                    break;
                }
                case 0x7FFFFFFF: {
                    relevantContentTypes.add(ContentType.FILE_BINARY);
                    relevantContentTypes.add(ContentType.FILE_EXECUTABLE);
                    break;
                }
                default: {
                    for (ContentType contentType : contentTypes) {
                        int sizeInKB = contentType.getCartridgeType().getSizeInKB();
                        if (sizeInKB != key && sizeInKB != 0 || !flashTargetType.isContentTypeSupported(contentType)) continue;
                        relevantContentTypes.add(contentType);
                    }
                }
            }
        } else {
            for (ContentType contentType : contentTypes) {
                if (!flashTargetType.isContentTypeSupported(contentType)) continue;
                relevantContentTypes.add(contentType);
            }
        }
        if (!relevantContentTypes.contains(ContentType.UNKNOWN)) {
            relevantContentTypes.add(ContentType.UNKNOWN);
        }
        if (currentContentType != null && !relevantContentTypes.contains(currentContentType)) {
            relevantContentTypes.add(currentContentType);
        }
        ValueSet.sort(relevantContentTypes);
        DefaultComboBoxModel<ContentType> result = new DefaultComboBoxModel<ContentType>(relevantContentTypes.toArray(new ContentType[relevantContentTypes.size()]));
        return result;
    }
}

