/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.ui;

import com.wudsn.thecart.Texts;
import com.wudsn.thecart.common.ClassPathUtility;
import com.wudsn.thecart.common.ResourceUtility;
import com.wudsn.thecart.gui.SimpleDialog;
import com.wudsn.thecart.repository.NLS;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public final class HelpDialog
extends SimpleDialog {
    JEditorPane jep;

    public HelpDialog(JFrame parent) {
        super(parent, Texts.HelpDialog_Title, false);
    }

    @Override
    protected void initComponents(JDialog dialog) {
        Container pane = dialog.getContentPane();
        this.jep = new JEditorPane();
        this.jep.setEditable(false);
        pane.add((Component)new JScrollPane(this.jep), "Center");
        String path = "help/TheCartStudio.html";
        String fullPath = NLS.getResourcePath(path);
        if (fullPath == null) {
            throw new RuntimeException("Help resource '" + path + "' not found in path.");
        }
        URL url = ClassPathUtility.class.getClassLoader().getResource(fullPath);
        this.setPage(url);
        this.jep.setPreferredSize(new Dimension(740, 320));
        this.jep.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL url = e.getURL();
                    String protocol = url.getProtocol();
                    if (protocol.equals("file") || protocol.equals("jar")) {
                        HelpDialog.this.setPage(url);
                        HelpDialog.this.jep.scrollToReference(e.getDescription());
                        return;
                    }
                    if ((protocol.equals("http") || protocol.equals("https")) && Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().browse(url.toURI());
                        }
                        catch (IOException ex) {
                            throw new RuntimeException("Cannot load page '" + url + "'.", ex);
                        }
                        catch (URISyntaxException ex) {
                            throw new RuntimeException("Cannot load page '" + url + "'.", ex);
                        }
                    }
                }
            }
        });
        this.initButtonBar();
    }

    void setPage(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Parameter 'url' must not be null.");
        }
        try {
            url = new URL(url, "", ResourceUtility.createStreamHandler());
            this.jep.setPage(url);
        }
        catch (IOException ex) {
            this.jep.setText(ex.getMessage());
        }
    }
}

