/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.ui;

import com.wudsn.thecart.DataTypes;
import com.wudsn.thecart.Texts;
import com.wudsn.thecart.common.MessageQueue;
import com.wudsn.thecart.gui.IntegerField;
import com.wudsn.thecart.gui.MemorySizeField;
import com.wudsn.thecart.gui.ModalDialog;
import com.wudsn.thecart.gui.SpringUtilities;
import com.wudsn.thecart.gui.StandardDialog;
import com.wudsn.thecart.gui.ValueSetField;
import com.wudsn.thecart.model.CartridgeMenuType;
import com.wudsn.thecart.model.CartridgeType;
import com.wudsn.thecart.model.FlashTargetType;
import com.wudsn.thecart.model.Preferences;
import com.wudsn.thecart.model.Workbook;
import com.wudsn.thecart.model.WorkbookGenre;
import com.wudsn.thecart.model.WorkbookRoot;
import com.wudsn.thecart.model.WorkbookRootValidation;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JTextField;

public final class WorkbookOptionsDialog
extends ModalDialog {
    private static final int ROWS = 8;
    private final JTextField titleTextField;
    private final ValueSetField<FlashTargetType> flashTargetTypeField;
    private final ValueSetField<CartridgeType> cartridgeTypeField;
    private final IntegerField bankCountField;
    private final MemorySizeField bankSizeField;
    private final ValueSetField<CartridgeMenuType> cartridgeMenuTypeField;
    private final MemorySizeField userSpaceSizeField;
    private final JTextField genreNamesField;
    transient WorkbookRoot root;

    public WorkbookOptionsDialog(JFrame parent, Preferences preferences) {
        super(parent, Texts.WorkbookOptionsDialog_Title);
        this.titleTextField = SpringUtilities.createTextField(this.fieldsPane, DataTypes.WorkbookRoot_Title);
        this.flashTargetTypeField = SpringUtilities.createValueSetField(this.fieldsPane, DataTypes.WorkbookRoot_FlashTargetType, FlashTargetType.class);
        this.flashTargetTypeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkbookOptionsDialog.this.performFlashTargetTypeChanged();
            }
        });
        this.cartridgeTypeField = SpringUtilities.createValueSetField(this.fieldsPane, DataTypes.WorkbookRoot_CartridgeType, CartridgeType.class);
        this.bankCountField = SpringUtilities.createIntegerField(this.fieldsPane, DataTypes.WorkbookRoot_BankCount);
        this.bankSizeField = SpringUtilities.createMemorySizeField(this.fieldsPane, DataTypes.WorkbookRoot_BankSize);
        this.cartridgeMenuTypeField = SpringUtilities.createValueSetField(this.fieldsPane, DataTypes.WorkbookRoot_CartridgeMenuType, CartridgeMenuType.class);
        this.userSpaceSizeField = SpringUtilities.createMemorySizeField(this.fieldsPane, DataTypes.WorkbookRoot_UserSpaceSize);
        this.genreNamesField = SpringUtilities.createMemorySizeField(this.fieldsPane, DataTypes.WorkbookRoot_GenreNames);
    }

    public boolean showModal(Workbook workbook, MessageQueue messageQueue) {
        if (workbook == null) {
            throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        this.root = workbook.getRoot().createCopy();
        this.dataToUi();
        this.okPressed = false;
        int stringWidth = this.getParent().getGraphics().getFontMetrics().stringWidth("a") * WorkbookRoot.Attributes.TITLE.getDataType().getMaximumLength();
        Dimension size = this.titleTextField.getPreferredSize();
        this.titleTextField.setPreferredSize(new Dimension(stringWidth, size.height));
        SpringUtilities.makeCompactGrid(this.fieldsPane, 8, 2, 6, 6, 6, 6);
        this.showModal(this.titleTextField);
        if (this.okPressed) {
            workbook.getRoot().setTitle(this.root.getTitle());
            boolean contentStructureEquals = workbook.getRoot().contentEquals(this.root);
            if (!contentStructureEquals) {
                workbook.getRoot().setFlashTargetType(this.root.getFlashTargetType(), this.root.getCartridgeType(), this.root.getBankCount(), this.root.getBankSize());
                workbook.getRoot().setCartridgeMenuType(this.root.getCartridgeMenuType());
                workbook.getRoot().setUserSpaceSize(this.root.getUserSpaceSize());
                workbook.unassignAllBanks(messageQueue);
                Workbook.initializeBanksList(workbook.getRoot(), messageQueue);
                workbook.assignNewBanks(messageQueue);
            }
            workbook.getRoot().getGenresList().clear();
            workbook.getRoot().getGenresList().addAll(this.root.getGenresList());
        }
        return this.okPressed;
    }

    @Override
    protected void dataFromUi() {
        this.root.setTitle(this.titleTextField.getText());
        this.root.setFlashTargetType(this.flashTargetTypeField.getValue(), this.cartridgeTypeField.getValue(), this.bankCountField.getValue(), this.bankSizeField.getValue());
        this.root.setCartridgeMenuType(this.cartridgeMenuTypeField.getValue());
        this.root.setUserSpaceSize(this.userSpaceSizeField.getValue());
        String[] genreNames = this.genreNamesField.getText().split(",");
        List<WorkbookGenre> genres = this.root.getGenresList();
        genres.clear();
        String[] stringArray = genreNames;
        int n = genreNames.length;
        int n2 = 0;
        while (n2 < n) {
            String genreName = stringArray[n2];
            WorkbookGenre genre = new WorkbookGenre();
            genreName = genreName.trim();
            genre.setName(genreName);
            genres.add(genre);
            ++n2;
        }
    }

    @Override
    protected void dataToUi() {
        this.titleTextField.setText(this.root.getTitle());
        this.flashTargetTypeField.setValue(this.root.getFlashTargetType());
        boolean editable = this.root.getFlashTargetType().equals(FlashTargetType.USER_DEFINED);
        this.cartridgeTypeField.setEditable(editable);
        this.cartridgeTypeField.setEnabled(editable);
        this.cartridgeTypeField.setValue(this.root.getCartridgeType());
        this.bankCountField.setEditable(editable);
        this.bankSizeField.setEditable(editable);
        this.bankCountField.setValue(this.root.getBankCount());
        this.bankSizeField.setValue(this.root.getBankSize());
        editable = this.root.getFlashTargetType().getSupportedCartridgeMenuTypes().size() > 1;
        this.cartridgeMenuTypeField.setEditable(editable);
        this.cartridgeMenuTypeField.setEnabled(editable);
        CartridgeMenuType cartridgeMenuType = this.root.getCartridgeMenuType();
        if (!this.root.getFlashTargetType().isCartridgeMenuTypeSupported(cartridgeMenuType)) {
            cartridgeMenuType = CartridgeMenuType.NONE;
        }
        this.cartridgeMenuTypeField.setValue(cartridgeMenuType);
        this.userSpaceSizeField.setValue(this.root.getUserSpaceSize());
        StringBuilder builder = new StringBuilder();
        for (WorkbookGenre genre : this.root.getUnmodifiableGenresList()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(genre.getName());
        }
        this.genreNamesField.setText(builder.toString());
    }

    void performFlashTargetTypeChanged() {
        this.dataFromUi();
        FlashTargetType flashTargetType = this.root.getFlashTargetType();
        if (!flashTargetType.isCartridgeMenuTypeSupported(this.root.getCartridgeMenuType())) {
            this.root.setCartridgeMenuType(flashTargetType.getSupportedCartridgeMenuTypes().get(0));
        }
        this.dataToUi();
    }

    @Override
    protected boolean validateOK() {
        WorkbookRootValidation validation = WorkbookRootValidation.createInstance();
        MessageQueue messageQueue = new MessageQueue();
        validation.validateSave(this.root, messageQueue, false);
        if (!messageQueue.containsError()) {
            Workbook.initializeBanksList(this.root, messageQueue);
        }
        if (messageQueue.containsError()) {
            StandardDialog.showErrorMessage(this, messageQueue.getFirstError().getMessageText(), this.getTitle());
            return false;
        }
        return true;
    }
}

