/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

public abstract class ImportableMenu {
    protected static final char[] ATASCII = new char[256];
    protected final byte[] content;
    private String creatingToolName;

    static {
        int i = 0;
        while (i < 256) {
            int c = i & 0x7F;
            if (c < 96) {
                c += 32;
            }
            ImportableMenu.ATASCII[i] = (char)c;
            ++i;
        }
    }

    protected ImportableMenu(byte[] content, String creatingToolName) {
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        if (creatingToolName == null) {
            throw new IllegalArgumentException("Parameter 'creatingToolName' must not be null.");
        }
        this.content = content;
        this.creatingToolName = creatingToolName;
    }

    public final String getCreatingToolName() {
        return this.creatingToolName;
    }

    public abstract boolean hasMenuEntries();

    public abstract int collectMenuEntries(Object var1, Collector var2);

    protected final int getByte(int offset) {
        return this.content[offset] & 0xFF;
    }

    protected final int getWord(int offset) {
        return (this.content[offset] & 0xFF) + 256 * (this.content[offset + 1] & 0xFF);
    }

    public static interface Collector {
        public void collectMenu(Object var1, String var2);

        public void collectMenuEntry(Object var1, int var2, int var3, String var4);
    }

    public static final class Result {
        public static final int NO_MENU_FOUND = 1;
        public static final int NOT_SUPPORTED_MENU_VERSION_FOUND = 2;
        public static final int NO_MENU_ENTRIES_FOUND = 3;
        public static final int MENU_ENTRIES_FOUND_BUT_NOT_STARTABLE = 4;
        public static final int MENU_ENTRIES_FOUND_AND_STARTABLE = 5;

        private Result() {
        }
    }

    public final class Version {
        public static final int ATARIMAX_OLD = 1;
        public static final int ATARIMAX_NEW = 2;
        public static final int MEGACART = 3;

        Version() {
        }
    }
}

