/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.thecartstudio.model.Workbook;
import com.wudsn.tools.thecartstudio.model.WorkbookMenuEntry;
import com.wudsn.tools.thecartstudio.model.WorkbookRoot;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;

public final class WorkbookExport {
    private Workbook workbook;
    private byte[] data;
    private List<WorkbookMenuEntry> menuEntries;

    public WorkbookExport(Workbook workbook, byte[] data) {
        if (workbook == null) {
            throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
        }
        if (data == null) {
            throw new IllegalArgumentException("Parameter 'data' must not be null.");
        }
        this.workbook = workbook;
        this.data = data;
        this.menuEntries = Collections.emptyList();
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public byte[] getData() {
        return this.data;
    }

    public void print(PrintWriter writer) {
        if (writer == null) {
            throw new IllegalArgumentException("Parameter 'writer' must not be null.");
        }
        WorkbookRoot root = this.workbook.getRoot();
        writer.println(root.getTitle());
        writer.println();
        int menuEntryNumber = 1;
        for (WorkbookMenuEntry menuEntry : this.menuEntries) {
            writer.print(TextUtility.formatAsDecimal(menuEntryNumber));
            writer.print(": \"");
            writer.print(menuEntry.getTitle());
            writer.print("\" from \"");
            writer.print(menuEntry.getWorkbookEntry().getTitle());
            writer.print("\" in \"");
            writer.print(menuEntry.getWorkbookEntry().getFileName());
            writer.println("\"");
            ++menuEntryNumber;
        }
    }

    void setMenuEntries(List<WorkbookMenuEntry> menuEntries) {
        if (menuEntries == null) {
            throw new IllegalArgumentException("Parameter 'menuEntries' must not be null.");
        }
        this.menuEntries = Collections.unmodifiableList(menuEntries);
    }
}

