/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.ui;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public final class BankColorUtility {
    private static final Map<Color, Color> lineColorMap = new HashMap<Color, Color>();

    private BankColorUtility() {
    }

    private static Color makeBrighter(Color color, float factor) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        r = (int)((float)r * factor);
        g = (int)((float)g * factor);
        b = (int)((float)b * factor);
        if (r > 255) {
            r = 255;
        }
        if (g > 255) {
            g = 255;
        }
        if (b > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    public static Color getLineColor(Color color) {
        if (color == null) {
            return color;
        }
        Color lineColor = lineColorMap.get(color);
        if (lineColor == null) {
            lineColor = BankColorUtility.makeBrighter(color, 0.8f);
            lineColorMap.put(color, lineColor);
        }
        return lineColor;
    }
}

