/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.gui;

import com.wudsn.tools.base.gui.ColorField;
import com.wudsn.tools.base.gui.ElementFactory;
import com.wudsn.tools.base.gui.IntegerField;
import com.wudsn.tools.base.gui.MemorySizeField;
import com.wudsn.tools.base.gui.ValueSetField;
import com.wudsn.tools.base.repository.DataType;
import com.wudsn.tools.base.repository.ValueSet;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;

public final class SpringUtilities {
    public static JTextField createTextField(JPanel fieldsPane, DataType dataType) {
        if (fieldsPane == null) {
            throw new IllegalArgumentException("Parameter 'fieldsPane' must not be null.");
        }
        if (dataType == null) {
            throw new IllegalArgumentException("Parameter 'dataType' must not be null.");
        }
        JTextField field = new JTextField();
        JLabel label = ElementFactory.createLabel(dataType, field);
        fieldsPane.add(label);
        fieldsPane.add(field);
        return field;
    }

    public static IntegerField createIntegerField(JPanel fieldsPane, DataType dataType) {
        if (fieldsPane == null) {
            throw new IllegalArgumentException("Parameter 'fieldsPane' must not be null.");
        }
        if (dataType == null) {
            throw new IllegalArgumentException("dataType 'labelText' must not be null.");
        }
        IntegerField field = new IntegerField();
        JLabel label = ElementFactory.createLabel(dataType, field);
        field.setLabel(label);
        fieldsPane.add(label);
        fieldsPane.add(field);
        return field;
    }

    public static MemorySizeField createMemorySizeField(JPanel fieldsPane, DataType dataType) {
        if (fieldsPane == null) {
            throw new IllegalArgumentException("Parameter 'fieldsPane' must not be null.");
        }
        if (dataType == null) {
            throw new IllegalArgumentException("dataType 'labelText' must not be null.");
        }
        MemorySizeField field = new MemorySizeField();
        JLabel label = ElementFactory.createLabel(dataType, field);
        fieldsPane.add(label);
        fieldsPane.add(field);
        return field;
    }

    public static <E extends ValueSet> ValueSetField<E> createValueSetField(JPanel fieldsPane, DataType dataType, Class<E> valueSetClass) {
        if (fieldsPane == null) {
            throw new IllegalArgumentException("Parameter 'fieldsPane' must not be null.");
        }
        if (dataType == null) {
            throw new IllegalArgumentException("Parameter 'dataType' must not be null.");
        }
        if (valueSetClass == null) {
            throw new IllegalArgumentException("Parameter ' valueSetClass' must not be null.");
        }
        ValueSetField<E> field = new ValueSetField<E>(valueSetClass);
        JLabel label = ElementFactory.createLabel(dataType, field);
        fieldsPane.add(label);
        fieldsPane.add(field);
        return field;
    }

    public static ColorField createColorField(JPanel fieldsPane, DataType dataType) {
        if (fieldsPane == null) {
            throw new IllegalArgumentException("Parameter 'fieldsPane' must not be null.");
        }
        if (dataType == null) {
            throw new IllegalArgumentException("Parameter 'dataType' must not be null.");
        }
        ColorField field = new ColorField();
        JLabel label = ElementFactory.createLabel(dataType, field);
        field.setLabel(label);
        fieldsPane.add(label);
        fieldsPane.add(field);
        return field;
    }

    public static JCheckBox createCheckBox(JPanel fieldsPane, DataType dataType) {
        if (fieldsPane == null) {
            throw new IllegalArgumentException("Parameter 'fieldsPane' must not be null.");
        }
        if (dataType == null) {
            throw new IllegalArgumentException("Parameter 'dataTypet' must not be null.");
        }
        JCheckBox field = new JCheckBox();
        JLabel label = ElementFactory.createLabel(dataType, field);
        fieldsPane.add(label);
        fieldsPane.add(field);
        return field;
    }

    private static SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    public static void makeCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout;
        if (parent == null) {
            throw new IllegalArgumentException("Parameter 'parent' must not be null.");
        }
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException ex) {
            throw new RuntimeException("The first argument to makeCompactGrid must use SpringLayout.", ex);
        }
        Spring x = Spring.constant(initialX);
        int c = 0;
        while (c < cols) {
            Spring width = Spring.constant(0);
            int r = 0;
            while (r < rows) {
                width = Spring.max(width, SpringUtilities.getConstraintsForCell(r, c, parent, cols).getWidth());
                ++r;
            }
            r = 0;
            while (r < rows) {
                SpringLayout.Constraints constraints = SpringUtilities.getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
                ++r;
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
            ++c;
        }
        Spring y = Spring.constant(initialY);
        int r = 0;
        while (r < rows) {
            Spring height = Spring.constant(0);
            int c2 = 0;
            while (c2 < cols) {
                height = Spring.max(height, SpringUtilities.getConstraintsForCell(r, c2, parent, cols).getHeight());
                ++c2;
            }
            c2 = 0;
            while (c2 < cols) {
                SpringLayout.Constraints constraints = SpringUtilities.getConstraintsForCell(r, c2, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
                ++c2;
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
            ++r;
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }
}

