/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

import com.wudsn.tools.base.atari.AtrFile;
import com.wudsn.tools.base.common.ByteArrayUtility;
import com.wudsn.tools.base.common.HexUtility;
import com.wudsn.tools.base.common.Log;
import com.wudsn.tools.thecartstudio.model.WorkbookEntry;
import com.wudsn.tools.thecartstudio.model.atrfile.AtrFileMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AtrLoader {
    private static List<PatchLocation> patchLocations = new ArrayList<PatchLocation>();

    static {
        patchLocations.add(new PatchLocation("dskinv", new byte[]{32, 83, -28}, 1, false, -1, 3));
        patchLocations.add(new PatchLocation("dskinv", new byte[]{76, 83, -28}, 1, false, -1, 3));
        patchLocations.add(new PatchLocation("siov", new byte[]{32, 89, -28}, 1, false, -1, 6));
        patchLocations.add(new PatchLocation("siov", new byte[]{76, 89, -28}, 1, false, -1, 6));
        patchLocations.add(new PatchLocation("selected_item_number", new byte[0], 0, true, 0, 0));
    }

    public static void setDefaultParameters(WorkbookEntry entry, AtrFileMenu atrFileMenu, byte[] content) {
        if (entry == null) {
            throw new IllegalArgumentException("Parameter 'entry' must not be null.");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        if (!AtrFile.isHeader(content)) {
            throw new IllegalArgumentException("Parameter 'content' must be an ATR file");
        }
        ArrayList<PatchRange> patchRanges = new ArrayList<PatchRange>();
        if (atrFileMenu != null) {
            patchRanges = atrFileMenu.getPatchRanges();
        } else {
            patchRanges.add(new PatchRange(0, content.length));
        }
        List<WorkbookEntry.Parameter> parameters = AtrLoader.determineDefaultParameters(content, patchRanges);
        parameters.add(new WorkbookEntry.Parameter("base", 256));
        if (atrFileMenu != null) {
            parameters.addAll(atrFileMenu.getPatchParameters());
        }
        Collections.sort(parameters);
        entry.setParameters(WorkbookEntry.Parameter.getParametersString(parameters));
    }

    private static List<WorkbookEntry.Parameter> determineDefaultParameters(byte[] content, List<PatchRange> patchRanges) {
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        if (!AtrFile.isHeader(content)) {
            throw new IllegalArgumentException("Parameter 'content' must be an ATR file");
        }
        int startOffset = 16;
        ArrayList<WorkbookEntry.Parameter> result = new ArrayList<WorkbookEntry.Parameter>();
        for (PatchLocation patchLocation : patchLocations) {
            if (!patchLocation.hasPattern()) continue;
            int offset = startOffset;
            while (offset >= 0 && offset < content.length && PatchRange.isContained(offset, patchRanges)) {
                if ((offset = ByteArrayUtility.getIndexOf(content, offset, content.length - startOffset, patchLocation.pattern)) < 0 || !PatchRange.isContained(offset, patchRanges)) continue;
                result.add(new WorkbookEntry.Parameter(offset + patchLocation.patchOffset, patchLocation.name));
                offset += patchLocation.pattern.length;
            }
        }
        return result;
    }

    public static int getBaseAddress(WorkbookEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Parameter 'entry' must not be null.");
        }
        int base = -1;
        for (WorkbookEntry.Parameter parameter : entry.getParametersList()) {
            if (!parameter.key.equals("base") || !parameter.isValueInteger()) continue;
            base = parameter.getValueAsInteger();
        }
        if (base == -1) {
            base = 256;
        }
        return base;
    }

    public static byte[] modifyContent(WorkbookEntry entry, byte[] content) {
        if (entry == null) {
            throw new IllegalArgumentException("Parameter 'parametersList' must not be null.");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        if (!AtrFile.isHeader(content)) {
            throw new IllegalArgumentException("Parameter 'content' must be an ATR file");
        }
        int base = AtrLoader.getBaseAddress(entry);
        block5: for (WorkbookEntry.Parameter parameter : entry.getParametersList()) {
            if (parameter.isKeyInteger() && parameter.isValueInteger()) {
                AtrLoader.modifyContent(content, parameter.getKeyAsInteger(), parameter.getValueAsInteger() & 0xFF);
            }
            for (PatchLocation patchLocation : patchLocations) {
                int offset;
                String value = parameter.value;
                int mode = 0;
                if (value.startsWith("<")) {
                    mode = 1;
                } else if (value.startsWith(">")) {
                    mode = 2;
                }
                if (mode != 0) {
                    value = value.substring(1);
                }
                if (!parameter.isKeyInteger() || !value.equals(patchLocation.name) || (offset = parameter.getKeyAsInteger()) >= content.length) continue;
                int address = patchLocation.absolute ? patchLocation.absoluteAddress : base + patchLocation.baseOffset;
                switch (mode) {
                    case 0: {
                        AtrLoader.modifyContent(content, offset, address & 0xFF);
                        AtrLoader.modifyContent(content, offset + 1, address >>> 8 & 0xFF);
                        continue block5;
                    }
                    case 1: {
                        AtrLoader.modifyContent(content, offset, address & 0xFF);
                        continue block5;
                    }
                    case 2: {
                        AtrLoader.modifyContent(content, offset, address >>> 8 & 0xFF);
                        continue block5;
                    }
                    default: {
                        throw new RuntimeException("Undefined mode " + mode + ".");
                    }
                }
            }
        }
        int resultSize = (content.length + 128 - 1) / 128 * 128;
        byte[] result = new byte[resultSize];
        System.arraycopy(content, 0, result, 0, 16);
        System.arraycopy(content, 16, result, 128, content.length - 16);
        return result;
    }

    private static void modifyContent(byte[] content, int offset, int value) {
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        Log.logInfo("Replacing {0} with {1} at offset {2}", new Object[]{HexUtility.getByteValueHexString(content[offset] & 0xFF), HexUtility.getByteValueHexString(value), HexUtility.getLongValueHexString(offset)});
        content[offset] = (byte)(value & 0xFF);
    }

    public static final class Constants {
        public static final String BASE = "base";
        public static final String DSKINV = "dskinv";
        public static final String SIOV = "siov";
        public static final String SELECTED_ITEM_NUMBER = "selected_item_number";
        public static final int DEFAULT_BASE = 256;
    }

    private static final class PatchLocation {
        public final String name;
        public final byte[] pattern;
        public final int patchOffset;
        public final boolean absolute;
        public final int absoluteAddress;
        public final int baseOffset;

        public PatchLocation(String name, byte[] pattern, int patchOffset, boolean absolute, int absoluteAddress, int baseOffset) {
            if (name == null) {
                throw new IllegalArgumentException("Parameter 'name' must not be null.");
            }
            if (pattern == null) {
                throw new IllegalArgumentException("Parameter 'pattern' must not be null.");
            }
            this.name = name;
            this.pattern = pattern;
            this.patchOffset = patchOffset;
            this.absolute = absolute;
            this.absoluteAddress = absoluteAddress;
            this.baseOffset = baseOffset;
        }

        public boolean hasPattern() {
            return this.pattern.length > 0;
        }
    }

    public static final class PatchRange {
        public final int startOffset;
        public final int endOffset;

        public PatchRange(int startOffset, int endOffset) {
            if (startOffset < 0) {
                throw new IllegalArgumentException("Parameter startOffset must not be negative. Specified value is " + startOffset + ".");
            }
            if (endOffset < 0) {
                throw new IllegalArgumentException("Parameter endOffset must not be negative. Specified value is " + endOffset + ".");
            }
            if (startOffset > endOffset) {
                throw new IllegalArgumentException("Parameter startOffset must be larger then endOffset. Specified value for startOffset is " + startOffset + ". Specified endOffset is " + endOffset + ".");
            }
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public boolean isContained(int offset) {
            if (offset < 0) {
                throw new IllegalArgumentException("Parameter offset must not be negative. Specified value is " + offset + ".");
            }
            return this.startOffset <= offset && offset <= this.endOffset;
        }

        public static boolean isContained(int offset, List<PatchRange> patchRanges) {
            for (PatchRange patchRange : patchRanges) {
                if (!patchRange.isContained(offset)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "[0x" + HexUtility.getLongValueHexString(this.startOffset) + ",0x" + HexUtility.getLongValueHexString(this.endOffset) + "]";
        }
    }
}

