/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

import com.wudsn.tools.base.Messages;
import com.wudsn.tools.base.atari.AtrFile;
import com.wudsn.tools.base.atari.CartridgeType;
import com.wudsn.tools.base.common.ASCIIString;
import com.wudsn.tools.base.common.CoreException;
import com.wudsn.tools.base.common.FileUtility;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public final class AtrProgrammingFile {
    private File sourceFile;
    private long sourceFileSize;
    private InputStream inputStream;
    private byte[] sourceFileContent;
    private byte[] atrHeader;
    private int atrHeaderSize;
    private byte[] bootSectorHeader;
    private int bootSectorHeaderSize;
    private int bootSectors;
    private byte[] bootCode;
    private CartridgeType cartridgeType;
    private BuildInfo buildInfo;

    public AtrProgrammingFile(File sourceFile) {
        if (sourceFile == null) {
            throw new IllegalArgumentException("Parameter 'sourceFile' must not be null.");
        }
        this.sourceFile = sourceFile;
        this.sourceFileSize = sourceFile.length();
        this.atrHeader = new byte[16];
        this.bootSectorHeader = new byte[2];
    }

    public String getSourceFilePath() {
        return this.sourceFile.getAbsolutePath();
    }

    public int getSourceFileContentOffset() {
        return this.atrHeaderSize + this.bootCode.length;
    }

    public int getSourceFileContentSize() {
        return (int)(this.sourceFileSize - (long)this.getSourceFileContentOffset());
    }

    public byte[] getSourceFileContent() {
        return this.sourceFileContent;
    }

    public byte[] getBootCode() {
        return this.bootCode;
    }

    public CartridgeType getCartridgeType() {
        return this.cartridgeType;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public boolean loadHeadersAndBootCode() throws CoreException {
        this.inputStream = FileUtility.openInputStream(this.sourceFile);
        try {
            this.atrHeaderSize = this.inputStream.read(this.atrHeader);
            this.bootSectorHeaderSize = this.inputStream.read(this.bootSectorHeader);
        }
        catch (IOException ex) {
            throw new CoreException(Messages.E206, this.sourceFile.getAbsolutePath(), ex.getLocalizedMessage());
        }
        if (this.atrHeaderSize == this.atrHeader.length && AtrFile.isHeader(this.atrHeader) && this.bootSectorHeaderSize == this.bootSectorHeader.length) {
            this.bootSectors = 0xFF & this.bootSectorHeader[1];
            this.bootCode = new byte[this.bootSectors * 128];
            try {
                this.inputStream.read(this.bootCode, this.bootSectorHeaderSize, this.bootCode.length - this.bootSectorHeaderSize);
            }
            catch (IOException ex) {
                throw new CoreException(Messages.E206, this.sourceFile.getAbsolutePath(), ex.getLocalizedMessage());
            }
            return true;
        }
        return false;
    }

    public boolean containsStringAt(byte[] bytes, String string, int index) {
        if (bytes == null) {
            throw new IllegalArgumentException("Parameter 'bytes' must not be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Parameter 'string' must not be null.");
        }
        if (index < 0) {
            throw new IllegalArgumentException("Parameter 'index' must not be negative.");
        }
        int endIndex = index + string.length();
        if (endIndex > bytes.length - 1) {
            return false;
        }
        byte[] stringBytes = ASCIIString.getBytes(string);
        int j = 0;
        int i = index;
        while (i < endIndex) {
            if (bytes[i] != stringBytes[j++]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setCartridgeTypeAndBuildInfo(CartridgeType cartridgeType, BuildInfo buildInfo) {
        this.cartridgeType = cartridgeType;
        this.buildInfo = buildInfo;
    }

    public byte[] createCartridgeContent() throws CoreException {
        byte[] cartridgeContent = new byte[this.cartridgeType.getSizeInKB() * 1024];
        this.sourceFileContent = FileUtility.readBytes(this.getSourceFilePath(), this.inputStream, cartridgeContent.length, false);
        return cartridgeContent;
    }

    public void close() {
        if (this.inputStream != null) {
            try {
                FileUtility.closeInputStream(this.sourceFile, this.inputStream);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public static final class BuildInfo {
        public final String signature;
        public final int signatureOffset;
        public final int mode;
        public final int modeOffset;

        public BuildInfo(String signature, int signatureOffset, int mode, int modeOffset) {
            this.signature = signature;
            this.signatureOffset = signatureOffset;
            this.mode = mode;
            this.modeOffset = modeOffset;
        }

        public String toString() {
            return "signature=" + this.signature + ", signatureOffset=0x" + Integer.toHexString(this.signatureOffset) + ",mode=" + this.mode + ", modeOffset=0x" + Integer.toHexString(this.modeOffset);
        }
    }
}

