/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

import com.wudsn.tools.base.common.HexUtility;
import com.wudsn.tools.base.repository.Attribute;
import com.wudsn.tools.thecartstudio.DataTypes;
import com.wudsn.tools.thecartstudio.model.ContentType;

public final class CartridgeDatabaseEntry {
    private int sizeInKB;
    private int crc32;
    private String md5;
    private String title;
    private ContentType contentType;
    private String source;

    CartridgeDatabaseEntry(int sizeInKB, int crc32, String md5, String title, ContentType contentType, String source) {
        if (sizeInKB < 0) {
            throw new IllegalArgumentException("Parameter 'sizeInK' must not be negative. Specified value is " + sizeInKB + ".");
        }
        if (md5 == null) {
            throw new IllegalArgumentException("Parameter 'md5' must not be null.");
        }
        if (title == null) {
            throw new IllegalArgumentException("Parameter 'title' must not be null.");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Parameter 'contentType' must not be null.");
        }
        if (source == null) {
            throw new IllegalArgumentException("Parameter 'source' must not be null.");
        }
        this.sizeInKB = sizeInKB;
        this.crc32 = crc32;
        this.md5 = md5;
        this.title = title;
        this.contentType = contentType;
        this.source = source;
    }

    public int getSizeInKB() {
        return this.sizeInKB;
    }

    public int getCRC32() {
        return this.crc32;
    }

    public String getCRC32String() {
        return HexUtility.getLongValueHexString((long)this.crc32 & 0xFFFFFFFFL, 8);
    }

    public Long getCRC32Key() {
        return new Long(this.sizeInKB << 32 | this.crc32);
    }

    public String getMD5() {
        return this.md5;
    }

    public String getTitle() {
        return this.title;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public String getSource() {
        return this.source;
    }

    public String toString() {
        return "sizeInKB=" + this.sizeInKB + " crc32=" + this.getCRC32String() + " md5=" + this.md5 + " title=" + this.title + " contentType=" + this.contentType.getId() + " source=" + this.source;
    }

    public static final class Attributes {
        public static final String ELEMENT_NAME = "entry";
        public static final Attribute TITLE = new Attribute("title", DataTypes.CartridgeDatabaseEntry_Title);

        private Attributes() {
        }
    }
}

