/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

import com.wudsn.tools.base.common.CoreException;
import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.StringUtility;
import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.base.repository.RepositoryValidation;
import com.wudsn.tools.thecartstudio.Messages;
import com.wudsn.tools.thecartstudio.model.ContentType;
import com.wudsn.tools.thecartstudio.model.FlashTargetType;
import com.wudsn.tools.thecartstudio.model.ReservedContentProviderFactory;
import com.wudsn.tools.thecartstudio.model.WorkbookEntry;
import com.wudsn.tools.thecartstudio.model.WorkbookEntryType;
import com.wudsn.tools.thecartstudio.model.WorkbookGenre;
import com.wudsn.tools.thecartstudio.model.WorkbookRoot;

public final class WorkbookEntryValidation {
    public static final WorkbookEntryValidation createInstance() {
        return new WorkbookEntryValidation();
    }

    public void validateSave(WorkbookRoot root, WorkbookEntry entry, MessageQueue messageQueue) {
        if (root == null) {
            throw new IllegalArgumentException("Parameter 'root' must not be null.");
        }
        if (entry == null) {
            throw new IllegalArgumentException("Parameter 'entry' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        RepositoryValidation rv = RepositoryValidation.createInstance(messageQueue);
        rv.isStringValid(entry, WorkbookEntry.Attributes.TITLE, entry.getTitle());
        rv.isStringValid(entry, WorkbookEntry.Attributes.FILE_NAME, entry.getFileName());
        String genreName = entry.getGenreName();
        if (StringUtility.isSpecified(genreName)) {
            boolean defined = false;
            for (WorkbookGenre genre : root.getUnmodifiableGenresList()) {
                if (!genre.getName().equalsIgnoreCase(genreName)) continue;
                entry.setGenreName(genre.getName());
                defined = true;
            }
            rv.isStringDefined(entry, WorkbookEntry.Attributes.GENRE_NAME, genreName, defined);
        }
    }

    public void validateExport(WorkbookRoot root, WorkbookEntry entry, MessageQueue messageQueue) {
        if (root == null) {
            throw new IllegalArgumentException("Parameter 'root' must not be null.");
        }
        if (entry == null) {
            throw new IllegalArgumentException("Parameter 'entry' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        if (entry.getContentType() == ContentType.UNKNOWN) {
            messageQueue.sendMessage(entry, WorkbookEntry.Attributes.CONTENT_TYPE, Messages.E405, new String[0]);
            return;
        }
        FlashTargetType flashTargetType = root.getFlashTargetType();
        if (!flashTargetType.isContentTypeSupported(entry.getContentType())) {
            messageQueue.sendMessage(entry, WorkbookEntry.Attributes.CONTENT_TYPE, Messages.E406, entry.getContentType().getText(), flashTargetType.getText());
            return;
        }
        if (entry.getType().equals(WorkbookEntryType.FILE_ENTRY)) {
            if (!entry.areBanksAssigned()) {
                messageQueue.sendMessage(entry, WorkbookEntry.Attributes.BANKS_ASSIGNED_INDICATOR, Messages.E400, new String[0]);
                return;
            }
            if (entry.getStartBankNumber() % entry.getAlignmentBanksCount() != 0) {
                if (entry.isStartBankFixed()) {
                    messageQueue.sendMessage(entry, WorkbookEntry.Attributes.START_BANK, Messages.E414, TextUtility.formatAsDecimal(entry.getStartBankNumber()), TextUtility.formatAsDecimal(entry.getAlignmentBanksCount()));
                } else {
                    messageQueue.sendMessage(entry, WorkbookEntry.Attributes.START_BANK, Messages.E415, TextUtility.formatAsDecimal(entry.getStartBankNumber()), TextUtility.formatAsDecimal(entry.getAlignmentBanksCount()));
                }
                return;
            }
        } else {
            RepositoryValidation rv = RepositoryValidation.createInstance(messageQueue);
            if (root.getUserSpaceBanksCount() == 0) {
                messageQueue.sendMessage(entry, WorkbookEntry.Attributes.TYPE, Messages.E421, new String[0]);
                return;
            }
            ReservedContentProviderFactory.UserSpaceContentProvider userSpaceContentProvider = new ReservedContentProviderFactory.UserSpaceContentProvider();
            userSpaceContentProvider.init(root);
            int startBankNumber = userSpaceContentProvider.getStartBankNumber();
            if (!rv.isLongValid(entry, WorkbookEntry.Attributes.START_BANK, startBankNumber, startBankNumber + root.getUserSpaceBanksCount() - 1, entry.getStartBankNumber())) {
                return;
            }
        }
        try {
            entry.setParametersList(WorkbookEntry.Parameter.getParametersList(entry.getParameters()));
        }
        catch (CoreException ex) {
            entry.setParametersList(null);
            messageQueue.sendMessage(ex.createMessageQueueEntry(entry, WorkbookEntry.Attributes.PARAMETERS));
        }
    }
}

