/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

import com.wudsn.tools.base.common.DateUtility;
import com.wudsn.tools.base.common.FileUtility;
import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.XMLUtility;
import com.wudsn.tools.base.gui.AttributeTablePreferences;
import com.wudsn.tools.base.gui.MainWindowPreferences;
import com.wudsn.tools.base.repository.Attribute;
import com.wudsn.tools.thecartstudio.DataTypes;
import com.wudsn.tools.thecartstudio.model.Language;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class Preferences
implements MainWindowPreferences,
AttributeTablePreferences {
    private static final String FOLDER_NAME = ".tcs";
    private static final String FILE_NAME = "preferences.xml";
    public static final int MAX_HISTORY_SIZE = 5;
    private File file = this.file.getAbsoluteFile();
    private Language language = Language.DEFAULT;
    private boolean updateCheckIndicator = true;
    private String emulatorExecutablePath = "";
    private Color freeBankColor;
    private Color reservedBankColor;
    private Color reservedUserSpaceBankColor;
    private Color usedOddBankColor;
    private Color usedEvenBankColor;
    private Color conflictBankColor;
    private int mainWindowExtendedState;
    private Point mainWindowLocation;
    private Dimension mainWindowSize;
    private String lastWorkbookFolderPath;
    private String lastEntryFolderPath;
    private String lastExportFolderPath;
    List<String> recentWorkbookFilePathsList;
    Map<String, String> layoutProperties;

    public Preferences() {
        this.setDefaultBankColors();
        this.mainWindowLocation = null;
        this.mainWindowSize = new Dimension(640, 480);
        this.lastWorkbookFolderPath = "";
        this.lastEntryFolderPath = "";
        this.lastExportFolderPath = "";
        this.recentWorkbookFilePathsList = new ArrayList<String>();
        this.layoutProperties = new TreeMap<String, String>();
    }

    public void setLanguage(Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Parameter 'language' must not be null.");
        }
        this.language = language;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setUpdateCheckIndicator(boolean updateCheckIndicator) {
        this.updateCheckIndicator = updateCheckIndicator;
    }

    public boolean getUpdateCheckIndicator() {
        return this.updateCheckIndicator;
    }

    public Locale getLocale() {
        Language language = this.language;
        if (language.equals(Language.DEFAULT)) {
            String userLanguage = System.getProperty("user.language");
            language = userLanguage.toLowerCase().startsWith("de") ? Language.DE : Language.EN;
        }
        Locale result = language.equals(Language.DE) ? Locale.GERMAN : Locale.ENGLISH;
        return result;
    }

    public void setEmulatorExecutablePath(String emulatorExecutablePath) {
        if (emulatorExecutablePath == null) {
            throw new IllegalArgumentException("Parameter 'emulatorExecutablePath' must not be null.");
        }
        this.emulatorExecutablePath = emulatorExecutablePath;
    }

    public String getEmulatorExecutablePath() {
        return this.emulatorExecutablePath;
    }

    public void setDefaultBankColors() {
        this.freeBankColor = new Color(10481152);
        this.reservedBankColor = new Color(0x33CCCC);
        this.reservedUserSpaceBankColor = new Color(15088027);
        this.usedEvenBankColor = new Color(0xFF4040);
        this.usedOddBankColor = new Color(0xFF7373);
        this.conflictBankColor = new Color(0xFFFF00);
    }

    public void setFreeBankColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Parameter 'color' must not be null.");
        }
        this.freeBankColor = color;
    }

    public Color getFreeBankColor() {
        return this.freeBankColor;
    }

    public void setReservedBankColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Parameter 'color' must not be null.");
        }
        this.reservedBankColor = color;
    }

    public Color getReservedBankColor() {
        return this.reservedBankColor;
    }

    public void setReservedUserSpaceBankColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Parameter 'color' must not be null.");
        }
        this.reservedUserSpaceBankColor = color;
    }

    public Color getReservedUserSpaceBankColor() {
        return this.reservedUserSpaceBankColor;
    }

    public void setUsedOddBankColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Parameter 'color' must not be null.");
        }
        this.usedOddBankColor = color;
    }

    public Color getUsedOddBankColor() {
        return this.usedOddBankColor;
    }

    public void setUsedEvenBankColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Parameter 'color' must not be null.");
        }
        this.usedEvenBankColor = color;
    }

    public Color getUsedEvenBankColor() {
        return this.usedEvenBankColor;
    }

    public void setConflictBankColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Parameter 'color' must not be null.");
        }
        this.conflictBankColor = color;
    }

    public Color getConflictBankColor() {
        return this.conflictBankColor;
    }

    public Color getNotAvailableBankColor() {
        return this.getConflictBankColor();
    }

    @Override
    public void setMainWindowExtendedState(int mainWindowExtendedState) {
        this.mainWindowExtendedState = mainWindowExtendedState;
    }

    @Override
    public int getMainWindowExtendedState() {
        return this.mainWindowExtendedState;
    }

    @Override
    public void setMainWindowLocation(Point mainWindowLocation) {
        if (mainWindowLocation == null) {
            throw new IllegalArgumentException("Parameter 'mainWindowLocation' must not be null.");
        }
        this.mainWindowLocation = mainWindowLocation;
    }

    @Override
    public Point getMainWindowLocation() {
        return this.mainWindowLocation;
    }

    @Override
    public void setMainWindowSize(Dimension mainWindowSize) {
        if (mainWindowSize == null) {
            throw new IllegalArgumentException("Parameter 'mainWindowSize' must not be null.");
        }
        this.mainWindowSize = mainWindowSize;
    }

    @Override
    public Dimension getMainWindowSize() {
        return this.mainWindowSize;
    }

    public void setLastWorkbookFolderPath(String folderPath) {
        if (folderPath == null) {
            throw new IllegalArgumentException("Parameter 'folderPath' must not be null.");
        }
        this.lastWorkbookFolderPath = folderPath;
    }

    public String getLastWorkbookFolderPath() {
        return this.lastWorkbookFolderPath;
    }

    public void setLastEntryFolderPath(String folderPath) {
        if (folderPath == null) {
            throw new IllegalArgumentException("Parameter 'folderPath' must not be null.");
        }
        this.lastEntryFolderPath = folderPath;
    }

    public String getLastEntryFolderPath() {
        return this.lastEntryFolderPath;
    }

    public void setLastExportFolderPath(String folderPath) {
        if (folderPath == null) {
            throw new IllegalArgumentException("Parameter 'folderPath' must not be null.");
        }
        this.lastExportFolderPath = folderPath;
    }

    public String getLastExportFolderPath() {
        return this.lastExportFolderPath;
    }

    public List<String> getRecentWorkbookFilePathsList() {
        return Collections.unmodifiableList(this.recentWorkbookFilePathsList);
    }

    @Override
    public Map<String, String> getLayoutProperties() {
        return this.layoutProperties;
    }

    public void updateRecentWorkBookFileList(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        if (file.getName().isEmpty()) {
            return;
        }
        String filePath = FileUtility.getAbsolutePath(file.getPath());
        int index = this.recentWorkbookFilePathsList.indexOf(filePath);
        if (index != -1) {
            this.recentWorkbookFilePathsList.remove(index);
        }
        this.recentWorkbookFilePathsList.add(0, filePath);
        int i = this.recentWorkbookFilePathsList.size() - 1;
        while (i >= 5) {
            this.recentWorkbookFilePathsList.remove(i);
            --i;
        }
    }

    public void open(MessageQueue messageQueue) {
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        if (!this.file.exists()) {
            return;
        }
        if (!this.file.canRead()) {
            return;
        }
        XMLUtility.open(this.file, new XMLHandler(this), messageQueue);
    }

    public void save(MessageQueue messageQueue) {
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        XMLUtility.save(this.file, new XMLHandler(this), messageQueue);
    }

    public void copyTo(Preferences other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' must not be null.");
        }
        XMLUtility.copyTo(new XMLHandler(this), new XMLHandler(other));
    }

    public String toString() {
        return "language=" + this.language + " updateCheckIndicator=" + this.updateCheckIndicator + " emulatorExecutablePath=" + this.emulatorExecutablePath + " lastWorkbookFolderPath=" + this.lastWorkbookFolderPath + " lastEntryFolderPath=" + this.lastEntryFolderPath + " lastExportFolderPath=" + this.lastExportFolderPath + " recentWorkbookFilePathsList=" + this.recentWorkbookFilePathsList;
    }

    private static final class Attributes {
        public static final Attribute LANGUAGE = new Attribute("language", DataTypes.Preferences_Language);
        public static final Attribute UPDATE_CHECK_INDICATOR = new Attribute("updateCheckIndicator", DataTypes.Preferences_UpdateCheckIndicator);
        public static final Attribute EMULATOR_EXECUTABLE_PATH = new Attribute("emulatorExecuablePath", DataTypes.Preferences_EmulatorExecutablePath);
        public static final Attribute FREE_BANK_COLOR = new Attribute("freeBankColor", DataTypes.Preferences_FreeBankColor);
        public static final Attribute RESERVED_BANK_COLOR = new Attribute("reservedBankColor");
        public static final Attribute RESERVED_USER_SPACE_BANK_COLOR = new Attribute("reservedUserSpaceBankColor");
        public static final Attribute USED_ODD_BANK_COLOR = new Attribute("usedOddBankColor");
        public static final Attribute USED_EVEN_BANK_COLOR = new Attribute("usedEvenBankColor");
        public static final Attribute CONFLICT_BANK_COLOR = new Attribute("conflictBankColor");
        public static final Attribute LAST_WORKBOOK_FOLDER_PATH = new Attribute("lastWorkbookFolderPath");
        public static final Attribute LAST_ENTRY_FOLDER_PATH = new Attribute("lastEntryFolderPath");
        public static final Attribute LAST_EXPORT_FOLDER_PATH = new Attribute("lastExportFolderPath");
        public static final Attribute MAIN_WINDOW_EXTENDED_STATE = new Attribute("mainWindowExtendedState");
        public static final Attribute MAIN_WINDOW_LOCATION = new Attribute("mainWindowLocation");
        public static final Attribute MAIN_WINDOW_SIZE = new Attribute("mainWindowSize");
        public static final Attribute FILE_PATH = new Attribute("filePath");
        public static final Attribute PROPERTY_KEY = new Attribute("key");
        public static final Attribute PROPERTY_VALUE = new Attribute("value");

        private Attributes() {
        }
    }

    private static final class XMLElements {
        public static final String PREFERENCES = "preferences";
        public static final String RECENT_WORKBOOK = "recentWorkoook";
        public static final String LAYOUT_PROPERTIES = "layoutProperties";

        private XMLElements() {
        }
    }

    private static final class XMLHandler
    extends com.wudsn.tools.base.common.XMLHandler {
        private Preferences preferences;

        public XMLHandler(Preferences preferences) {
            if (preferences == null) {
                throw new IllegalArgumentException("Parameter 'preferences' must not be null.");
            }
            this.preferences = preferences;
        }

        @Override
        public void startOpen(MessageQueue messageQueue) {
            if (messageQueue == null) {
                throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
            }
            this.preferences.recentWorkbookFilePathsList.clear();
        }

        @Override
        public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes attributes) throws SAXException {
            if (qName == null) {
                throw new IllegalArgumentException("Parameter 'qName' must not be null.");
            }
            if (attributes == null) {
                throw new IllegalArgumentException("Parameter 'attributes' must not be null.");
            }
            if (qName.equals("preferences")) {
                Dimension mainWindowSize;
                Color color;
                Language language = Attributes.LANGUAGE.deserializeValueSet(attributes, Language.class);
                if (language != null) {
                    this.preferences.setLanguage(language);
                }
                this.preferences.setUpdateCheckIndicator(Attributes.UPDATE_CHECK_INDICATOR.deserializeBoolean(attributes, this.preferences.getUpdateCheckIndicator()));
                String value = Attributes.EMULATOR_EXECUTABLE_PATH.deserializeString(attributes);
                if (value != null) {
                    this.preferences.setEmulatorExecutablePath(value);
                }
                if ((color = Attributes.FREE_BANK_COLOR.deserializeColor(attributes)) != null) {
                    this.preferences.setFreeBankColor(color);
                }
                if ((color = Attributes.RESERVED_BANK_COLOR.deserializeColor(attributes)) != null) {
                    this.preferences.setReservedBankColor(color);
                }
                if ((color = Attributes.RESERVED_USER_SPACE_BANK_COLOR.deserializeColor(attributes)) != null) {
                    this.preferences.setReservedUserSpaceBankColor(color);
                }
                if ((color = Attributes.USED_ODD_BANK_COLOR.deserializeColor(attributes)) != null) {
                    this.preferences.setUsedOddBankColor(color);
                }
                if ((color = Attributes.USED_EVEN_BANK_COLOR.deserializeColor(attributes)) != null) {
                    this.preferences.setUsedEvenBankColor(color);
                }
                if ((color = Attributes.CONFLICT_BANK_COLOR.deserializeColor(attributes)) != null) {
                    this.preferences.setConflictBankColor(color);
                }
                int mainWindowExtendedState = Attributes.MAIN_WINDOW_EXTENDED_STATE.deserializeInteger(attributes);
                this.preferences.setMainWindowExtendedState(mainWindowExtendedState);
                Point mainWindowLocation = Attributes.MAIN_WINDOW_LOCATION.deserializePoint(attributes);
                if (mainWindowLocation != null) {
                    this.preferences.setMainWindowLocation(mainWindowLocation);
                }
                if ((mainWindowSize = Attributes.MAIN_WINDOW_SIZE.deserializeDimension(attributes)) != null) {
                    this.preferences.setMainWindowSize(mainWindowSize);
                }
                if ((value = Attributes.LAST_WORKBOOK_FOLDER_PATH.deserializeString(attributes)) != null) {
                    this.preferences.setLastWorkbookFolderPath(value);
                }
                if ((value = Attributes.LAST_ENTRY_FOLDER_PATH.deserializeString(attributes)) != null) {
                    this.preferences.setLastEntryFolderPath(value);
                }
                if ((value = Attributes.LAST_EXPORT_FOLDER_PATH.deserializeString(attributes)) != null) {
                    this.preferences.setLastExportFolderPath(value);
                }
            } else if (qName.equals("recentWorkoook")) {
                List<String> recentWorkBookFilePathsList = this.preferences.recentWorkbookFilePathsList;
                String value = Attributes.FILE_PATH.deserializeString(attributes);
                if (value != null && recentWorkBookFilePathsList.size() < 5) {
                    recentWorkBookFilePathsList.add(value);
                }
            } else if (qName.equals("layoutProperties")) {
                Map<String, String> layoutProperties = this.preferences.layoutProperties;
                String key = Attributes.PROPERTY_KEY.deserializeString(attributes);
                String value = Attributes.PROPERTY_VALUE.deserializeString(attributes);
                if (key != null) {
                    layoutProperties.put(key, value);
                }
            }
        }

        @Override
        public void startSave(Document document, MessageQueue messageQueue) {
            if (document == null) {
                throw new IllegalArgumentException("Parameter 'document' must not be null.");
            }
            if (messageQueue == null) {
                throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
            }
            String dateTime = DateUtility.getCurrentDateTimeString();
            Comment comment = document.createComment("The!Cart Studio AttributeTablePreferences - " + dateTime);
            document.appendChild(comment);
            Element rootElement = document.createElement("preferences");
            document.appendChild(rootElement);
            Attributes.LANGUAGE.serializeValueSet(rootElement, this.preferences.getLanguage());
            Attributes.UPDATE_CHECK_INDICATOR.serializeBoolean(rootElement, this.preferences.getUpdateCheckIndicator());
            Attributes.EMULATOR_EXECUTABLE_PATH.serializeString(rootElement, this.preferences.getEmulatorExecutablePath());
            Attributes.FREE_BANK_COLOR.serializeColor(rootElement, this.preferences.getFreeBankColor());
            Attributes.RESERVED_BANK_COLOR.serializeColor(rootElement, this.preferences.getReservedBankColor());
            Attributes.RESERVED_USER_SPACE_BANK_COLOR.serializeColor(rootElement, this.preferences.getReservedUserSpaceBankColor());
            Attributes.USED_ODD_BANK_COLOR.serializeColor(rootElement, this.preferences.getUsedOddBankColor());
            Attributes.USED_EVEN_BANK_COLOR.serializeColor(rootElement, this.preferences.getUsedEvenBankColor());
            Attributes.CONFLICT_BANK_COLOR.serializeColor(rootElement, this.preferences.getConflictBankColor());
            Attributes.MAIN_WINDOW_EXTENDED_STATE.serializeInteger(rootElement, this.preferences.getMainWindowExtendedState());
            Attributes.MAIN_WINDOW_LOCATION.serializePoint(rootElement, this.preferences.getMainWindowLocation());
            Attributes.MAIN_WINDOW_SIZE.serializeDimension(rootElement, this.preferences.getMainWindowSize());
            Attributes.LAST_WORKBOOK_FOLDER_PATH.serializeString(rootElement, this.preferences.getLastWorkbookFolderPath());
            Attributes.LAST_ENTRY_FOLDER_PATH.serializeString(rootElement, this.preferences.getLastEntryFolderPath());
            Attributes.LAST_EXPORT_FOLDER_PATH.serializeString(rootElement, this.preferences.getLastExportFolderPath());
            for (String filePath : this.preferences.getRecentWorkbookFilePathsList()) {
                Element recentWorkbookElement = document.createElement("recentWorkoook");
                rootElement.appendChild(recentWorkbookElement);
                Attributes.FILE_PATH.serializeString(recentWorkbookElement, filePath);
            }
            for (String key : this.preferences.getLayoutProperties().keySet()) {
                Element layoutPropertiesElement = document.createElement("layoutProperties");
                rootElement.appendChild(layoutPropertiesElement);
                Attributes.PROPERTY_KEY.serializeString(layoutPropertiesElement, key);
                Attributes.PROPERTY_VALUE.serializeString(layoutPropertiesElement, this.preferences.getLayoutProperties().get(key));
            }
        }
    }
}

