#ifndef LOADERS_H
#define	LOADERS_H

namespace xex2cas {

    /* Binary loader - Modern STDBLOAD 2a */
    unsigned char stdbload_2a[481] = {
        0x00, 0x03, 0xe8, 0x07, 0xfe, 0x08, 0xa9, 0x3c, 0x8d, 0x02, 0xd3, 0xa2, 0xff, 0x9a, 0xa2, 0x80, 0xbd, 0xff, 0x03, 0x9d,
        0x67, 0x09, 0xca, 0xd0, 0xf7, 0x20, 0x69, 0x09, 0xa9, 0x01, 0x8d, 0x03, 0x09, 0x8d, 0x04, 0x09, 0x20, 0x08, 0x09, 0x20,
        0x13, 0x09, 0xad, 0x53, 0x03, 0x10, 0x06, 0x20, 0x37, 0x09, 0x4c, 0x04, 0x08, 0xa9, 0xfe, 0x8d, 0xe2, 0x02, 0xa9, 0x08,
        0x8d, 0xe3, 0x02, 0xa9, 0xff, 0x8d, 0x54, 0x03, 0xa9, 0x08, 0x8d, 0x55, 0x03, 0xa9, 0x02, 0x8d, 0x58, 0x03, 0xa9, 0x00,
        0x8d, 0x59, 0x03, 0x20, 0xdb, 0x08, 0xa9, 0xff, 0xcd, 0xff, 0x08, 0xd0, 0x0d, 0xcd, 0x00, 0x09, 0xd0, 0x08, 0xa9, 0x00,
        0x8d, 0x04, 0x09, 0x4c, 0x27, 0x08, 0xa9, 0x01, 0x8d, 0x54, 0x03, 0xa9, 0x09, 0x8d, 0x55, 0x03, 0xa9, 0x02, 0x8d, 0x58,
        0x03, 0xa9, 0x00, 0x8d, 0x59, 0x03, 0x20, 0xdb, 0x08, 0xad, 0x04, 0x09, 0xf0, 0x03, 0x4c, 0x3f, 0x09, 0xad, 0x03, 0x09,
        0xf0, 0x11, 0xa9, 0x00, 0x8d, 0x03, 0x09, 0xad, 0xff, 0x08, 0x8d, 0xe0, 0x02, 0xad, 0x00, 0x09, 0x8d, 0xe1, 0x02, 0x38,
        0xad, 0x01, 0x09, 0xed, 0xff, 0x08, 0x8d, 0x58, 0x03, 0xb0, 0x03, 0xce, 0x02, 0x09, 0x38, 0xad, 0x02, 0x09, 0xed, 0x00,
        0x09, 0x8d, 0x59, 0x03, 0x18, 0xad, 0x58, 0x03, 0x69, 0x01, 0x8d, 0x58, 0x03, 0x90, 0x03, 0xee, 0x59, 0x03, 0xad, 0xff,
        0x08, 0x8d, 0x54, 0x03, 0xad, 0x00, 0x09, 0x8d, 0x55, 0x03, 0x20, 0xdb, 0x08, 0xad, 0xe2, 0x02, 0xc9, 0xfe, 0xd0, 0x07,
        0xad, 0xe3, 0x02, 0xc9, 0x08, 0xf0, 0x0d, 0xa9, 0x3c, 0x8d, 0x02, 0xd3, 0x20, 0xfb, 0x08, 0xa9, 0x34, 0x8d, 0x02, 0xd3,
        0x4c, 0x1d, 0x08, 0xa2, 0x10, 0xa9, 0x07, 0x8d, 0x52, 0x03, 0x20, 0x56, 0xe4, 0xad, 0x53, 0x03, 0x30, 0x01, 0x60, 0xc9,
        0x88, 0xd0, 0x09, 0xa2, 0xff, 0x9a, 0x20, 0x08, 0x09, 0x6c, 0xe0, 0x02, 0x4c, 0x37, 0x09, 0x6c, 0xe2, 0x02, 0x60, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x3a, 0x9b, 0xa2, 0x10, 0xa9, 0x0c, 0x8d, 0x52, 0x03, 0x20, 0x56, 0xe4, 0x60, 0xa2,
        0x10, 0xa9, 0x03, 0x8d, 0x52, 0x03, 0xa9, 0x04, 0x8d, 0x5a, 0x03, 0xa9, 0x0c, 0x8d, 0xfc, 0x02, 0xa9, 0x80, 0x8d, 0x5b,
        0x03, 0xa9, 0x05, 0x8d, 0x54, 0x03, 0xa9, 0x09, 0x8d, 0x55, 0x03, 0x20, 0x56, 0xe4, 0x60, 0xa9, 0x24, 0x20, 0x47, 0x09,
        0x4c, 0x77, 0xe4, 0xa9, 0x0e, 0x20, 0x47, 0x09, 0x4c, 0x74, 0xe4, 0x8d, 0xc8, 0x02, 0x8d, 0xc6, 0x02, 0x8d, 0x1a, 0xd0,
        0x8d, 0x18, 0xd0, 0xa9, 0x3c, 0x8d, 0x02, 0xd3, 0x20, 0x5c, 0x09, 0x60, 0xa9, 0xff, 0x8d, 0xfc, 0x02, 0xad, 0xfc, 0x02,
        0xc9, 0xff, 0xf0, 0xf9, 0x60, 0xa9, 0x00, 0x8d, 0x44, 0x02, 0xa9, 0x01, 0x85, 0x09, 0x20, 0x9b, 0x09, 0xa9, 0x9b, 0x85,
        0x0c, 0xa9, 0x09, 0x85, 0x0d, 0xa2, 0x00, 0xa9, 0x09, 0x8d, 0x42, 0x03, 0xa9, 0xa4, 0x8d, 0x44, 0x03, 0xa9, 0x09, 0x8d,
        0x45, 0x03, 0xa9, 0x25, 0x8d, 0x48, 0x03, 0xa9, 0x00, 0x8d, 0x49, 0x03, 0x20, 0x56, 0xe4, 0xa9, 0x04, 0x85, 0x0a, 0xa9,
        0x08, 0x85, 0x0b, 0x60, 0x7d, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0xa1,




    };


    /* Binary loader - Original Exclamation mark (!) loader */
    unsigned char exma_original[564] = {
        0x20, 0x05, 0x00, 0x07, 0x20, 0x07, 0x20, 0xf4, 0x08, 0x4c, 0xed, 0xf2, 0x56, 0xff, 0x55, 0x57, 0x52, 0x03, 0x40, 0x2f,
        0xef, 0x17, 0x2f, 0x07, 0x37, 0x2f, 0x0a, 0x56, 0xfe, 0x72, 0x03, 0x40, 0x52, 0x03, 0x40, 0x0f, 0xf9, 0xe7, 0x97, 0x97,
        0xb3, 0xaf, 0xf8, 0x56, 0xfe, 0x72, 0x0f, 0xfd, 0x56, 0xf8, 0x72, 0xad, 0xff, 0x56, 0xf5, 0x72, 0xaa, 0xff, 0x72, 0xab,
        0xff, 0x5d, 0x01, 0x5f, 0xf7, 0xdf, 0x7a, 0x0c, 0xdf, 0x1d, 0x09, 0x36, 0xe4, 0x2f, 0x06, 0x97, 0x97, 0xb3, 0xa4, 0xf8,
        0x56, 0xa4, 0x72, 0xf5, 0xff, 0x56, 0xf8, 0x72, 0xf4, 0xff, 0x15, 0x56, 0xfd, 0x72, 0xad, 0xff, 0x56, 0xff, 0x72, 0x0f,
        0xfd, 0x56, 0x82, 0xdf, 0x5b, 0x09, 0xdf, 0x1a, 0xf7, 0x5d, 0xef, 0x56, 0xfc, 0x62, 0xbd, 0xfc, 0x56, 0x04, 0x62, 0xbb,
        0xfc, 0x56, 0xf7, 0x62, 0xba, 0xfc, 0x56, 0xfb, 0x62, 0xb5, 0xfc, 0x56, 0x7f, 0x62, 0xb4, 0xfc, 0x56, 0xf3, 0x72, 0x03,
        0xfd, 0xdf, 0xa9, 0x1b, 0x56, 0xff, 0x72, 0xc9, 0xf6, 0x5d, 0xef, 0x56, 0xcb, 0x62, 0xbb, 0xfc, 0x56, 0xf6, 0x62, 0xba,
        0xfc, 0x56, 0xfd, 0x62, 0xb7, 0xfc, 0x56, 0xff, 0x62, 0xb6, 0xfc, 0x56, 0xf8, 0x62, 0xbd, 0xfc, 0xdf, 0xa9, 0x1b, 0xcf,
        0xda, 0x5d, 0xef, 0x56, 0xcf, 0x62, 0xbb, 0xfc, 0x56, 0xf6, 0x62, 0xba, 0xfc, 0x56, 0xfb, 0x62, 0xb7, 0xfc, 0x56, 0xff,
        0x62, 0xb6, 0xfc, 0xdf, 0xa9, 0x1b, 0xef, 0xe6, 0x3f, 0x77, 0x2f, 0xf9, 0xdf, 0x1a, 0xf7, 0xb3, 0x82, 0xf7, 0x67, 0xb7,
        0xdf, 0x1a, 0xf7, 0x97, 0x57, 0x0f, 0xf9, 0xdf, 0x7e, 0x0c, 0xb3, 0x82, 0xf7, 0x52, 0xc9, 0xf6, 0x2f, 0xf0, 0x52, 0xcf,
        0xf6, 0x72, 0x1f, 0xfd, 0x52, 0xce, 0xf6, 0x72, 0x1e, 0xfd, 0x31, 0xc9, 0xf6, 0x5d, 0xef, 0x52, 0xcf, 0xf6, 0x62, 0xbb,
        0xfc, 0xb7, 0x52, 0xce, 0xf6, 0x62, 0xba, 0xfc, 0x57, 0x97, 0x37, 0x2f, 0xe0, 0x57, 0x37, 0x2f, 0xe4, 0x52, 0xcd, 0xf6,
        0x72, 0xcf, 0xf6, 0x52, 0xcc, 0xf6, 0x72, 0xce, 0xf6, 0x56, 0xcd, 0x62, 0xbb, 0xfc, 0x56, 0xf6, 0x62, 0xba, 0xfc, 0x56,
        0xfd, 0xb3, 0x3c, 0xf8, 0x52, 0xcd, 0xf6, 0xc7, 0x12, 0xcf, 0xf6, 0x62, 0xb7, 0xfc, 0x52, 0xcc, 0xf6, 0x12, 0xce, 0xf6,
        0x62, 0xb6, 0xfc, 0x52, 0xce, 0xf6, 0x01, 0xb7, 0xfc, 0x2f, 0xfc, 0x01, 0xb6, 0xfc, 0x5d, 0xef, 0x56, 0x0c, 0x72, 0x1d,
        0xfd, 0x56, 0xf7, 0x72, 0x1c, 0xfd, 0xdf, 0xa9, 0x1b, 0xef, 0xfc, 0xb3, 0x25, 0xf8, 0x52, 0x1d, 0xfd, 0x72, 0xf5, 0xff,
        0x52, 0x1c, 0xfd, 0x72, 0xf4, 0xff, 0xdf, 0x6d, 0xf7, 0xdf, 0x85, 0xf7, 0xdf, 0x30, 0xf7, 0xb3, 0x4a, 0xf8, 0x93, 0x1d,
        0xfd, 0x52, 0x1f, 0xfd, 0x72, 0xf5, 0xff, 0x52, 0x1e, 0xfd, 0x72, 0xf4, 0xff, 0xdf, 0x6d, 0xf7, 0xdf, 0x30, 0xf7, 0x93,
        0x1f, 0xfd, 0x56, 0xef, 0x72, 0xfd, 0xff, 0x56, 0x14, 0x72, 0xfc, 0xff, 0x60, 0xa9, 0x0c, 0x8d, 0xd0, 0x00, 0xa9, 0x07,
        0x8d, 0xd1, 0x00, 0xa0, 0x00, 0xb1, 0xd0, 0x49, 0xff, 0x91, 0xd0, 0xee, 0xd0, 0x00, 0xd0, 0x03, 0xee, 0xd1, 0x00, 0xad,
        0xd1, 0x00, 0xc9, 0x08, 0xd0, 0xe9, 0xad, 0xd0, 0x00, 0xc9, 0x9c, 0xd0, 0xe2, 0xa9, 0x00, 0x8d, 0xd0, 0x00, 0x8d, 0xd1,
        0x00, 0xea, 0x60, 0xa9, 0x3c, 0x8d, 0x02, 0xd3, 0x60, 0xa9, 0x20, 0x8d, 0x09, 0x07, 0xa9, 0x9d, 0x8d, 0x0a, 0x07, 0xa9,
        0x08, 0x8d, 0x0b, 0x07, 0x60, 0xa2, 0x10, 0xa9, 0x0c, 0x20, 0x56, 0xe4, 0xa2, 0x20, 0xa9, 0x0c, 0x20, 0x56, 0xe4, 0x60,
        0x20, 0xcf, 0x08, 0x20, 0xd5, 0x08, 0x60, 0x43, 0x3a, 0x9b, 0xfd, 0xe3, 0xe1, 0xf2, 0xf4, 0xf2, 0xe9, 0xe4, 0xe7, 0xe5,
        0xa0, 0xe9, 0xee, 0xf3, 0xf4, 0xe1, 0xec, 0xec, 0xe5, 0xe4, 0x1d, 0x9c, 0xf4, 0xf9, 0xf0, 0xe5, 0xa0, 0xbc, 0xc5, 0xd3,
        0xc3, 0xbe, 0xa0, 0xf4, 0xef, 0xa0, 0xe3, 0xef, 0xee, 0xf4, 0xe9, 0xf5, 0xe5, 0xa0, 0xe2, 0xef, 0xef, 0xf4, 0xfd, 0x9b,
        0x00, 0x00, 0x00, 0x00,
    };

    /*Binary loader - Exclamation mark (!) loader updated for XL/XE computers*/
    unsigned char exma_xlxe[564] = {
        0x20, 0x05, 0x00, 0x07, 0x20, 0x07, 0x20, 0xf4, 0x08, 0x4c, 0xa7, 0xc5, 0x56, 0xff, 0x55, 0x57, 0x52, 0x03, 0x40, 0x2f,
        0xef, 0x17, 0x2f, 0x07, 0x37, 0x2f, 0x0a, 0x56, 0xfe, 0x72, 0x03, 0x40, 0x52, 0x03, 0x40, 0x0f, 0xf9, 0xe7, 0x97, 0x97,
        0xb3, 0xaf, 0xf8, 0x56, 0xfe, 0x72, 0x0f, 0xfd, 0x56, 0xf8, 0x72, 0xad, 0xff, 0x56, 0xf5, 0x72, 0xaa, 0xff, 0x72, 0xab,
        0xff, 0x5d, 0x01, 0x5f, 0xf7, 0xdf, 0x7a, 0x0c, 0xdf, 0x1d, 0x09, 0x36, 0xe4, 0x2f, 0x06, 0x97, 0x97, 0xb3, 0xa4, 0xf8,
        0x56, 0xa4, 0x72, 0xf5, 0xff, 0x56, 0xf8, 0x72, 0xf4, 0xff, 0x15, 0x56, 0xfd, 0x72, 0xad, 0xff, 0x56, 0xff, 0x72, 0x0f,
        0xfd, 0x56, 0x82, 0xdf, 0x5b, 0x09, 0xdf, 0x1a, 0xf7, 0x5d, 0xef, 0x56, 0xfc, 0x62, 0xbd, 0xfc, 0x56, 0x04, 0x62, 0xbb,
        0xfc, 0x56, 0xf7, 0x62, 0xba, 0xfc, 0x56, 0xfb, 0x62, 0xb5, 0xfc, 0x56, 0x7f, 0x62, 0xb4, 0xfc, 0x56, 0xf3, 0x72, 0x03,
        0xfd, 0xdf, 0xa9, 0x1b, 0x56, 0xff, 0x72, 0xc9, 0xf6, 0x5d, 0xef, 0x56, 0xcb, 0x62, 0xbb, 0xfc, 0x56, 0xf6, 0x62, 0xba,
        0xfc, 0x56, 0xfd, 0x62, 0xb7, 0xfc, 0x56, 0xff, 0x62, 0xb6, 0xfc, 0x56, 0xf8, 0x62, 0xbd, 0xfc, 0xdf, 0xa9, 0x1b, 0xcf,
        0xda, 0x5d, 0xef, 0x56, 0xcf, 0x62, 0xbb, 0xfc, 0x56, 0xf6, 0x62, 0xba, 0xfc, 0x56, 0xfb, 0x62, 0xb7, 0xfc, 0x56, 0xff,
        0x62, 0xb6, 0xfc, 0xdf, 0xa9, 0x1b, 0xef, 0xe6, 0x3f, 0x77, 0x2f, 0xf9, 0xdf, 0x1a, 0xf7, 0xb3, 0x82, 0xf7, 0x67, 0xb7,
        0xdf, 0x1a, 0xf7, 0x97, 0x57, 0x0f, 0xf9, 0xdf, 0x7e, 0x0c, 0xb3, 0x82, 0xf7, 0x52, 0xc9, 0xf6, 0x2f, 0xf0, 0x52, 0xcf,
        0xf6, 0x72, 0x1f, 0xfd, 0x52, 0xce, 0xf6, 0x72, 0x1e, 0xfd, 0x31, 0xc9, 0xf6, 0x5d, 0xef, 0x52, 0xcf, 0xf6, 0x62, 0xbb,
        0xfc, 0xb7, 0x52, 0xce, 0xf6, 0x62, 0xba, 0xfc, 0x57, 0x97, 0x37, 0x2f, 0xe0, 0x57, 0x37, 0x2f, 0xe4, 0x52, 0xcd, 0xf6,
        0x72, 0xcf, 0xf6, 0x52, 0xcc, 0xf6, 0x72, 0xce, 0xf6, 0x56, 0xcd, 0x62, 0xbb, 0xfc, 0x56, 0xf6, 0x62, 0xba, 0xfc, 0x56,
        0xfd, 0xb3, 0x3c, 0xf8, 0x52, 0xcd, 0xf6, 0xc7, 0x12, 0xcf, 0xf6, 0x62, 0xb7, 0xfc, 0x52, 0xcc, 0xf6, 0x12, 0xce, 0xf6,
        0x62, 0xb6, 0xfc, 0x52, 0xce, 0xf6, 0x01, 0xb7, 0xfc, 0x2f, 0xfc, 0x01, 0xb6, 0xfc, 0x5d, 0xef, 0x56, 0x0c, 0x72, 0x1d,
        0xfd, 0x56, 0xf7, 0x72, 0x1c, 0xfd, 0xdf, 0xa9, 0x1b, 0xef, 0xfc, 0xb3, 0x25, 0xf8, 0x52, 0x1d, 0xfd, 0x72, 0xf5, 0xff,
        0x52, 0x1c, 0xfd, 0x72, 0xf4, 0xff, 0xdf, 0x6d, 0xf7, 0xdf, 0x85, 0xf7, 0xdf, 0x30, 0xf7, 0xb3, 0x4a, 0xf8, 0x93, 0x1d,
        0xfd, 0x52, 0x1f, 0xfd, 0x72, 0xf5, 0xff, 0x52, 0x1e, 0xfd, 0x72, 0xf4, 0xff, 0xdf, 0x6d, 0xf7, 0xdf, 0x30, 0xf7, 0x93,
        0x1f, 0xfd, 0x56, 0xef, 0x72, 0xfd, 0xff, 0x56, 0x14, 0x72, 0xfc, 0xff, 0x60, 0xa9, 0x0c, 0x8d, 0xd0, 0x00, 0xa9, 0x07,
        0x8d, 0xd1, 0x00, 0xa0, 0x00, 0xb1, 0xd0, 0x49, 0xff, 0x91, 0xd0, 0xee, 0xd0, 0x00, 0xd0, 0x03, 0xee, 0xd1, 0x00, 0xad,
        0xd1, 0x00, 0xc9, 0x08, 0xd0, 0xe9, 0xad, 0xd0, 0x00, 0xc9, 0x9c, 0xd0, 0xe2, 0xa9, 0x00, 0x8d, 0xd0, 0x00, 0x8d, 0xd1,
        0x00, 0xea, 0x60, 0xa9, 0x3c, 0x8d, 0x02, 0xd3, 0x60, 0xa9, 0x20, 0x8d, 0x09, 0x07, 0xa9, 0x9d, 0x8d, 0x0a, 0x07, 0xa9,
        0x08, 0x8d, 0x0b, 0x07, 0x60, 0xa2, 0x10, 0xa9, 0x0c, 0x20, 0x56, 0xe4, 0xa2, 0x20, 0xa9, 0x0c, 0x20, 0x56, 0xe4, 0x60,
        0x20, 0xcf, 0x08, 0x20, 0xd5, 0x08, 0x60, 0x43, 0x3a, 0x9b, 0xfd, 0xe3, 0xe1, 0xf2, 0xf4, 0xf2, 0xe9, 0xe4, 0xe7, 0xe5,
        0xa0, 0xe9, 0xee, 0xf3, 0xf4, 0xe1, 0xec, 0xec, 0xe5, 0xe4, 0x1d, 0x9c, 0xf4, 0xf9, 0xf0, 0xe5, 0xa0, 0xbc, 0xc5, 0xd3,
        0xc3, 0xbe, 0xa0, 0xf4, 0xef, 0xa0, 0xe3, 0xef, 0xee, 0xf4, 0xe9, 0xf5, 0xe5, 0xa0, 0xe2, 0xef, 0xef, 0xf4, 0xfd, 0x9b,
        0x00, 0x00, 0x00, 0x00,
    };

    /*Binary loader from L.K. Avalon*/
    unsigned char lkavalon_bl[256] = {
        0x00, 0x01, 0x00, 0x07, 0x50, 0xe4, 0xa2, 0x00, 0xbd, 0x00, 0x04, 0x9d, 0x80, 0x07, 0xe8, 0x10, 0xf7, 0x86, 0x3d, 0xad,
        0x0f, 0xd2, 0x29, 0x10, 0xea, 0xea, 0xa9, 0x06, 0x8d, 0x1c, 0x02, 0xad, 0x0f, 0xd2, 0x29, 0x10, 0xea, 0xea, 0xad, 0x1c,
        0x02, 0xea, 0xea, 0x20, 0x9d, 0x07, 0x30, 0x65, 0x85, 0x2c, 0x20, 0x9d, 0x07, 0x85, 0x2d, 0x25, 0x2c, 0xc9, 0xff, 0xf0,
        0xee, 0x20, 0x9d, 0x07, 0x85, 0x2e, 0x20, 0x9d, 0x07, 0x85, 0x2f, 0xa9, 0xae, 0x8d, 0xe2, 0x02, 0xa9, 0x07, 0x8d, 0xe3,
        0x02, 0xa5, 0x2e, 0xc5, 0x2c, 0xa5, 0x2f, 0xe5, 0x2d, 0x90, 0x10, 0x20, 0x9d, 0x07, 0x30, 0x4e, 0x88, 0x91, 0x2c, 0xe6,
        0x2c, 0xd0, 0xea, 0xe6, 0x2d, 0xd0, 0xe6, 0xad, 0xe2, 0x02, 0xc9, 0xae, 0xd0, 0x07, 0xad, 0xe3, 0x02, 0xc9, 0x07, 0xf0,
        0xb2, 0xa9, 0x3c, 0x8d, 0x02, 0xd3, 0x20, 0x92, 0x07, 0xa9, 0x34, 0x8d, 0x02, 0xd3, 0xa9, 0x30, 0x8d, 0x1c, 0x02, 0xad,
        0x1c, 0x02, 0xd0, 0xfb, 0xf0, 0x99, 0x6c, 0xe2, 0x02, 0xa9, 0x3c, 0x8d, 0x02, 0xd3, 0x6c, 0xe0, 0x02, 0xa4, 0x3d, 0xcc,
        0x8a, 0x02, 0x90, 0x03, 0x4c, 0x7a, 0xe4, 0xb9, 0x00, 0x04, 0xe6, 0x3d, 0xa0, 0x01, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x70, 0x42, 0x40, 0xbc, 0x02, 0x02,
    };

    /*Atari BASIC initializer*/
    unsigned char basic_init_bas2cas[257] = {
        0x00, 0x02, 0x00, 0x05, 0x0C, 0x05, 0xA9, 0x3C, 0x8D, 0x02, 0xD3, 0x60, 0xA9, 0xA0, 0x85, 0x6A,
        0xA9, 0x0C, 0x8D, 0x42, 0x03, 0xA2, 0x00, 0x20, 0x56, 0xE4, 0xA9, 0x03, 0x8D, 0x42, 0x03, 0xA9,
        0x80, 0x8D, 0x44, 0x03, 0xA9, 0x05, 0x8D, 0x45, 0x03, 0xA9, 0x00, 0x8D, 0x4B, 0x03, 0xA9, 0x0C,
        0x8D, 0x4A, 0x03, 0xA2, 0x00, 0x20, 0x56, 0xE4, 0xA9, 0x94, 0x8D, 0xC5, 0x02, 0xAD, 0x30, 0x02,
        0x85, 0x80, 0xAD, 0x31, 0x02, 0x85, 0x81, 0xA0, 0x04, 0xB1, 0x80, 0x85, 0x82, 0xC8, 0xB1, 0x80,
        0x85, 0x83, 0xE6, 0x83, 0xE6, 0x83, 0xA0, 0xA9, 0xA2, 0x00, 0xBD, 0x82, 0x05, 0x91, 0x82, 0xE8,
        0x88, 0xD0, 0xF7, 0xEA, 0xEA, 0xA9, 0x0D, 0x8D, 0x4A, 0x03, 0xA9, 0x00, 0x85, 0x54, 0xA9, 0xFE,
        0x8D, 0xB3, 0x02, 0xA9, 0x7F, 0x8D, 0xB4, 0x02, 0xA9, 0xFD, 0x8D, 0x01, 0xD3, 0x4C, 0x00, 0xA0,
        0x45, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x04, 0x00, 0x00, 0x38, 0x08, 0x32, 0x24,
        0x21, 0x08, 0x32, 0x33, 0x35, 0x1D, 0x38, 0x1A, 0x10, 0x0E, 0x32, 0x27, 0x1A, 0x12, 0x11, 0x0C,
        0x14, 0x16, 0x17, 0x00, 0x25, 0x2B, 0x2F, 0x30, 0x1A, 0x12, 0x11, 0x0C, 0x12, 0x14, 0x18, 0x00,
        0x25, 0x2B, 0x00, 0x00, 0x2F, 0x30, 0x1A, 0x02, 0x9B, 0x44, 0x2C, 0xFF, 0x89, 0x9B, 0x96, 0x00,
        0x44, 0x89, 0x28, 0x34, 0x89, 0x28, 0x97, 0x89, 0xDA, 0xFD, 0x82, 0x02, 0x1D, 0x04, 0x38, 0x1A,
        0x09, 0x10, 0x14, 0x08, 0x04, 0x38, 0x00, 0x2D, 0x29, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00
    };

    unsigned char basic_init_launchbas[222] = {
        0x00, 0x02, 0x00, 0x06, 0xce, 0x06, 0xa9, 0x3c, 0x8d, 0x02, 0xd3, 0xa2, 0xff, 0x9a, 0xa9, 0xfd, 0x8d, 0x01, 0xd3, 0xa2,
        0x00, 0x86, 0x09, 0x8e, 0x44, 0x02, 0x86, 0x08, 0x8e, 0xf8, 0x03, 0xa9, 0xa0, 0xc5, 0x6a, 0xb0, 0x02, 0x85, 0x6a, 0xa2,
        0x00, 0xa9, 0x0c, 0x8d, 0x42, 0x03, 0x20, 0x56, 0xe4, 0xa9, 0x03, 0x8d, 0x42, 0x03, 0xa9, 0x0c, 0x8d, 0x4a, 0x03, 0x8e,
        0x4b, 0x03, 0xa9, 0xcf, 0x8d, 0x44, 0x03, 0xa9, 0x06, 0x8d, 0x45, 0x03, 0x20, 0x56, 0xe4, 0xa2, 0x21, 0xbd, 0x1a, 0x03,
        0xc9, 0x43, 0xf0, 0x08, 0xca, 0xca, 0xca, 0x10, 0xf4, 0x4c, 0x77, 0xe4, 0xbd, 0x1b, 0x03, 0x85, 0x32, 0x8d, 0xb8, 0x06,
        0xbd, 0x1c, 0x03, 0x85, 0x33, 0x8d, 0xbd, 0x06, 0xa0, 0x0b, 0xb1, 0x32, 0x99, 0xdc, 0x06, 0x88, 0xc0, 0x01, 0xd0, 0xf6,
        0xb1, 0x32, 0x8d, 0xc9, 0x06, 0x88, 0xb1, 0x32, 0x8d, 0xcc, 0x06, 0xa9, 0x06, 0x9d, 0x1c, 0x03, 0xa9, 0xdc, 0x9d, 0x1b,
        0x03, 0x8e, 0xb6, 0x06, 0xa0, 0x52, 0xb9, 0x7f, 0x06, 0x91, 0x58, 0xc8, 0xc0, 0x5d, 0xd0, 0xf6, 0xa2, 0x0d, 0x8e, 0x4a,
        0x03, 0xca, 0x8e, 0xfc, 0x02, 0x20, 0xab, 0x06, 0x6c, 0xfa, 0xbf, 0x6c, 0xfe, 0xbf, 0xa9, 0x80, 0x9d, 0x4b, 0x03, 0x85,
        0x2b, 0xa0, 0x00, 0xa9, 0x00, 0x99, 0x1b, 0x03, 0xa9, 0x00, 0x99, 0x1c, 0x03, 0xa0, 0x92, 0xa9, 0x0c, 0x8d, 0x4a, 0x03,
        0xa9, 0x00, 0x48, 0xa9, 0x00, 0x48, 0x60, 0x45, 0x9b, 0x1f, 0x02, 0x7d, 0x22, 0x02, 0x1a, 0x32, 0x35, 0x2e, 0x02, 0x23,
        0xad, 0x06,
    };



    /*Fancy binary loader*/
    unsigned char fancy_loader[638] = {
        0x20, 0x05, 0x00, 0x07, 0x20, 0x07, 0x20, 0x34, 0x09, 0x4C, 0xED, 0xF2,
        0x56, 0xFF, 0x55, 0x57, 0x52, 0x03, 0x40, 0x2F, 0xEF, 0x17, 0x2F, 0x07,
        0x37, 0x2F, 0x0A, 0x56, 0xFE, 0x72, 0x03, 0x40, 0x52, 0x03, 0x40, 0x0F,
        0xF9, 0xE7, 0x97, 0x97, 0xB3, 0xAF, 0xF8, 0x56, 0xFE, 0x72, 0x0F, 0xFD,
        0x56, 0xF8, 0x72, 0xAD, 0xFF, 0x56, 0xF5, 0x72, 0xAA, 0xFF, 0x72, 0xAB,
        0xFF, 0x5D, 0x01, 0x5F, 0xF7, 0xDF, 0x7A, 0x0C, 0xDF, 0x1D, 0x09, 0x36,
        0xE4, 0x2F, 0x06, 0x97, 0x97, 0xB3, 0xA4, 0xF8, 0x56, 0xA4, 0x72, 0xF5,
        0xFF, 0x56, 0xF8, 0x72, 0xF4, 0xFF, 0x15, 0x56, 0xFD, 0x72, 0xAD, 0xFF,
        0x56, 0xFF, 0x72, 0x0F, 0xFD, 0x56, 0x82, 0xDF, 0x5B, 0x09, 0xDF, 0x1A,
        0xF7, 0x5D, 0xEF, 0x56, 0xFC, 0x62, 0xBF, 0xFC, 0x56, 0xFE, 0x62, 0xBE,
        0xFC, 0x56, 0xF8, 0x62, 0xBD, 0xFC, 0x56, 0xCB, 0x62, 0xBB, 0xFC, 0x56,
        0xF6, 0x62, 0xBA, 0xFC, 0x56, 0xFD, 0x62, 0xB7, 0xFC, 0x56, 0xFF, 0x62,
        0xB6, 0xFC, 0x56, 0xFB, 0x62, 0xB5, 0xFC, 0x56, 0x7F, 0x7A, 0xC2, 0x7A,
        0xC1, 0x72, 0x75, 0xFD, 0x56, 0xFF, 0x7A, 0xC0, 0x72, 0x76, 0xFD, 0x15,
        0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0xDF, 0xA9, 0x1B, 0xCF,
        0xDA, 0x5D, 0xEF, 0x56, 0xCF, 0x62, 0xBB, 0xFC, 0x56, 0xF6, 0x62, 0xBA,
        0xFC, 0x56, 0xFB, 0x62, 0xB7, 0xFC, 0x56, 0xFF, 0x62, 0xB6, 0xFC, 0xDF,
        0xA9, 0x1B, 0xEF, 0xE6, 0x3F, 0x77, 0x2F, 0xF9, 0xDF, 0x1A, 0xF7, 0xB3,
        0x82, 0xF7, 0x67, 0xB7, 0xDF, 0x1A, 0xF7, 0x97, 0x57, 0x0F, 0xF9, 0xDF,
        0x7E, 0x0C, 0xB3, 0x82, 0xF7, 0x52, 0xC9, 0xF6, 0x2F, 0xF0, 0x52, 0xCF,
        0xF6, 0x72, 0x1F, 0xFD, 0x52, 0xCE, 0xF6, 0x72, 0x1E, 0xFD, 0x31, 0xC9,
        0xF6, 0x5D, 0xEF, 0x52, 0xCF, 0xF6, 0x62, 0xBB, 0xFC, 0xB7, 0x52, 0xCE,
        0xF6, 0x62, 0xBA, 0xFC, 0x57, 0x97, 0x37, 0x2F, 0xE0, 0x57, 0x37, 0x2F,
        0xE4, 0x52, 0xCD, 0xF6, 0x72, 0xCF, 0xF6, 0x52, 0xCC, 0xF6, 0x72, 0xCE,
        0xF6, 0x56, 0xCD, 0x62, 0xBB, 0xFC, 0x56, 0xF6, 0x62, 0xBA, 0xFC, 0x56,
        0xFD, 0xB3, 0x3C, 0xF8, 0x52, 0xCD, 0xF6, 0xC7, 0x12, 0xCF, 0xF6, 0x62,
        0xB7, 0xFC, 0x52, 0xCC, 0xF6, 0x12, 0xCE, 0xF6, 0x62, 0xB6, 0xFC, 0x52,
        0xCE, 0xF6, 0x01, 0xB7, 0xFC, 0x2F, 0xFC, 0x01, 0xB6, 0xFC, 0x5D, 0xEF,
        0x56, 0x0C, 0x72, 0x1D, 0xFD, 0x56, 0xF7, 0x72, 0x1C, 0xFD, 0xDF, 0xA9,
        0x1B, 0xEF, 0xFC, 0xB3, 0x25, 0xF8, 0x56, 0xFF, 0x72, 0xBB, 0xFD, 0x56,
        0xFE, 0x7A, 0xF6, 0x15, 0x15, 0x15, 0xDF, 0x6D, 0xF7, 0xDF, 0x85, 0xF7,
        0xDF, 0x30, 0xF7, 0xB3, 0x4A, 0xF8, 0x93, 0x1D, 0xFD, 0x56, 0xFF, 0x72,
        0xBB, 0xFD, 0x56, 0xFE, 0x7A, 0xF6, 0x15, 0x15, 0x15, 0xDF, 0x6D, 0xF7,
        0xDF, 0x30, 0xF7, 0x93, 0x1F, 0xFD, 0x56, 0x63, 0x72, 0xFD, 0xFF, 0x56,
        0x0C, 0x72, 0xFC, 0xFF, 0x60, 0xA9, 0x0C, 0x8D, 0xD0, 0x00, 0xA9, 0x07,
        0x8D, 0xD1, 0x00, 0xA0, 0x00, 0xB1, 0xD0, 0x49, 0xFF, 0x91, 0xD0, 0xEE,
        0xD0, 0x00, 0xD0, 0x03, 0xEE, 0xD1, 0x00, 0xAD, 0xD1, 0x00, 0xC9, 0x08,
        0xD0, 0xE9, 0xAD, 0xD0, 0x00, 0xC9, 0x9C, 0xD0, 0xE2, 0xA9, 0x00, 0x8D,
        0xD0, 0x00, 0x8D, 0xD1, 0x00, 0xEA, 0x60, 0xA9, 0x3C, 0x8D, 0x02, 0xD3,
        0x60, 0xA9, 0x20, 0x8D, 0x09, 0x07, 0xA9, 0x9D, 0x8D, 0x0A, 0x07, 0xA9,
        0x08, 0x8D, 0x0B, 0x07, 0x60, 0xA2, 0x10, 0xA9, 0x0C, 0x20, 0x56, 0xE4,
        0xA2, 0x20, 0xA9, 0x0C, 0x20, 0x56, 0xE4, 0x60, 0x20, 0xCF, 0x08, 0x20,
        0xD5, 0x08, 0x60, 0x43, 0x3A, 0x9B, 0xFD, 0xE3, 0xE1, 0xF2, 0xF4, 0xF2,
        0xE9, 0xE4, 0xE7, 0xE5, 0xA0, 0xE9, 0xEE, 0xF3, 0xF4, 0xE1, 0xEC, 0xEC,
        0xE5, 0xE4, 0x1D, 0x9C, 0xF4, 0xF9, 0xF0, 0xE5, 0xA0, 0xBC, 0xC5, 0xD3,
        0xC3, 0xBE, 0xA0, 0xF4, 0xEF, 0xA0, 0xE3, 0xEF, 0xEE, 0xF4, 0xE9, 0xF5,
        0xE5, 0xA0, 0xE2, 0xEF, 0xEF, 0xF4, 0xFD, 0x9B, 0x00, 0x00, 0x00, 0x00,
        0xA9, 0x41, 0x8D, 0x30, 0x02, 0xA9, 0x09, 0x8D, 0x31, 0x02, 0x4C, 0xF4,
        0x08, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
        0x46, 0x55, 0x09, 0x70, 0x07, 0x70, 0x41, 0x41, 0x09, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x9B
    };

    unsigned char siecod_loader[2615] = {
        0x46, 0x55, 0x4a, 0x49, 0x00, 0x00, 0x00, 0x00, 0x62, 0x61, 0x75, 0x64, 0x00, 0x00, 0x58, 0x02, 0x64, 0x61, 0x74, 0x61,
        0x84, 0x00, 0xff, 0x43, 0x55, 0x55, 0xfa, 0x00, 0x01, 0x80, 0x03, 0x02, 0x30, 0xa2, 0x2f, 0x38, 0xbd, 0xa3, 0x03, 0xa8,
        0xed, 0xff, 0x03, 0x8c, 0xff, 0x03, 0x48, 0xca, 0x10, 0xf1, 0x8e, 0x80, 0x03, 0xba, 0xa9, 0x01, 0x48, 0x8a, 0x48, 0xa9,
        0x00, 0x60, 0xed, 0x5f, 0x1b, 0x19, 0x79, 0x77, 0xea, 0x24, 0x22, 0x95, 0x7d, 0xad, 0x1c, 0xc4, 0x22, 0x19, 0x79, 0x9a,
        0xdd, 0x0a, 0x07, 0x76, 0x1e, 0x96, 0xcc, 0xbc, 0xc5, 0x23, 0x18, 0x5b, 0x7e, 0x7b, 0xde, 0xde, 0xdb, 0x11, 0x01, 0x0a,
        0xea, 0x91, 0xad, 0x0b, 0x0c, 0x72, 0x06, 0xfa, 0xfa, 0xfa, 0x0b, 0x00, 0x33, 0x2f, 0x26, 0x34, 0x37, 0x21, 0x32, 0x25,
        0x60, 0x00, 0x52, 0x40, 0x00, 0x30, 0x23, 0x00, 0x69, 0x02, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3f, 0x64, 0x61, 0x74, 0x61,
        0x6a, 0x02, 0xca, 0x00, 0x55, 0x55, 0x98, 0x10, 0x06, 0x20, 0xc7, 0xed, 0x4c, 0xfc, 0xc8, 0xa9, 0xff, 0x8d, 0x01, 0xd3,
        0x20, 0x1b, 0x32, 0xad, 0x5a, 0xe4, 0x8d, 0xcd, 0x31, 0xad, 0x5b, 0xe4, 0x8d, 0xce, 0x31, 0xa9, 0x00, 0x8d, 0x5a, 0xe4,
        0x85, 0xcd, 0xa9, 0xcc, 0x8d, 0x5b, 0xe4, 0x85, 0xce, 0xa9, 0x8f, 0x85, 0xcb, 0xa9, 0x30, 0x85, 0xcc, 0xa0, 0x00, 0xa2,
        0x03, 0xb1, 0xcb, 0x91, 0xcd, 0xc8, 0xd0, 0xf9, 0xe6, 0xcc, 0xe6, 0xce, 0xca, 0x10, 0xf2, 0xa2, 0x02, 0xbd, 0x89, 0x30,
        0x9d, 0x59, 0xeb, 0xbd, 0x8c, 0x30, 0x9d, 0x1d, 0xeb, 0xca, 0x10, 0xf1, 0x8e, 0xdb, 0x02, 0x8e, 0xf8, 0x03, 0x8e, 0x0d,
        0xfe, 0xa6, 0x62, 0xa9, 0x00, 0x8d, 0x80, 0x04, 0x9d, 0x91, 0xfe, 0xa9, 0x32, 0x9d, 0x93, 0xfe, 0xa9, 0xea, 0x8d, 0xf3,
        0xeb, 0x8d, 0xf4, 0xeb, 0xa9, 0xc0, 0x85, 0x6a, 0xa9, 0x84, 0x8d, 0x48, 0xfe, 0xa9, 0x0c, 0x8d, 0xfc, 0x02, 0x4c, 0x80,
        0xc6, 0x20, 0xf0, 0xcc, 0x20, 0x39, 0xcc, 0xad, 0x00, 0x03, 0xc9, 0x60, 0xd0, 0x2f, 0x20, 0x29, 0xcc, 0x30, 0x3b, 0xad,
        0x80, 0x04, 0x8d, 0x40, 0xcd, 0xa2, 0x02, 0xfe, 0x6b, 0xdb, 0xbd, 0x6b, 0xdb, 0xc9, 0x9a, 0xd0, 0x08, 0xa9, 0x90, 0x9d,
        0x6b, 0xdb, 0xca, 0x10, 0xee, 0xa0, 0x01, 0x60, 0xa2, 0x7f, 0xa9, 0x00, 0x8d, 0x3d, 0xcd, 0x20, 0xfd, 0xcc, 0xca, 0x10,
        0xfa, 0x6c, 0x3e, 0xcd, 0xf0, 0x0a, 0xa4, 0x30, 0x30, 0x06, 0xad, 0x17, 0x03, 0xf0, 0x01, 0x60, 0x68, 0x68, 0x20, 0xc7,
        0xed, 0xc0, 0x88, 0xd0, 0x07, 0xa9, 0x00, 0x8d, 0x41, 0xcd, 0x98, 0x60, 0xa2, 0x0a, 0xbd, 0xa3, 0xdb, 0x9d, 0x57, 0xdb,
        0xca, 0x10, 0xf7, 0xad, 0x30, 0x02, 0x85, 0x00, 0xad, 0x31, 0x02, 0x85, 0x01, 0xa0, 0x04, 0x18, 0xb1, 0x00, 0x69, 0x83,
        0x48, 0xc8, 0xb1, 0x00, 0x69, 0x02, 0x85, 0x01, 0x68, 0x85, 0x00, 0xa0, 0x49, 0xb9, 0x42, 0xcd, 0x91, 0x00, 0x88, 0x10,
        0xf8, 0x20, 0xf8, 0xf2, 0xa0, 0x49, 0xa9, 0x00, 0x91, 0x00, 0x88, 0x10, 0xfb, 0xa9, 0x34, 0x8d, 0x02, 0xd3, 0xa5, 0x14,
        0x18, 0x69, 0x32, 0xc5, 0x14, 0xd0, 0xfc, 0xac, 0x0b, 0xd4, 0xa2, 0x05, 0x8e, 0x0a, 0xd4, 0xad, 0x0f, 0xd2, 0x29, 0x10,
        0xf0, 0xf1, 0xcc, 0x0b, 0xd4, 0xd0, 0xf4, 0xca, 0xd0, 0xee, 0xa9, 0x40, 0x8d, 0x03, 0x03, 0x20, 0x29, 0xcc, 0x10, 0x03,
        0x4c, 0x47, 0xcc, 0xad, 0x80, 0x04, 0x0d, 0x41, 0xcd, 0xd0, 0x13, 0xa9, 0x01, 0x8d, 0x41, 0xcd, 0xa2, 0x0a, 0xbd, 0x98,
        0xdb, 0x9d, 0x57, 0xdb, 0xca, 0x10, 0xf7, 0xa0, 0x01, 0x60, 0x38, 0xed, 0x40, 0xcd, 0xf0, 0x05, 0x30, 0xd0, 0x4c, 0x47,
        0xcc, 0x20, 0xd1, 0xcc, 0x4c, 0x07, 0xcc, 0xad, 0x57, 0xdb, 0x29, 0x7f, 0xd0, 0x03, 0x20, 0x28, 0xcd, 0xad, 0x0d, 0xd2,
        0xac, 0x3d, 0xcd, 0xc0, 0x98, 0xf0, 0x07, 0xc0, 0x99, 0xf0, 0x03, 0x99, 0x94, 0xd9, 0xc8, 0xc0, 0x20, 0xd0, 0x02, 0xa0,
        0x28, 0xc0, 0x48, 0xd0, 0x02, 0xa0, 0x50, 0xc0, 0x70, 0xd0, 0x02, 0xa0, 0x78, 0xc0, 0x9a, 0xd0, 0x02, 0xa0, 0x00, 0x8c,
        0x3d, 0xcd, 0x60, 0xa2, 0x04, 0xfe, 0x51, 0xdb, 0xbd, 0x51, 0xdb, 0xc9, 0x9a, 0xd0, 0x08, 0xa9, 0x90, 0x9d, 0x51, 0xdb,
        0xca, 0x10, 0xee, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x25, 0x22, 0x2f, 0x22, 0x29, 0x2e, 0x25, 0x00, 0x33, 0x35,
        0x00, 0x23, 0x21, 0x33, 0x33, 0x25, 0x34, 0x34, 0x25, 0x00, 0x13, 0x00, 0x36, 0x35, 0x25, 0x2c, 0x34, 0x21, 0x33, 0x00,
        0x24, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x2f, 0x2e, 0x34, 0x21, 0x24, 0x2f, 0x32, 0x0c, 0x00, 0x30,
        0x32, 0x25, 0x33, 0x29, 0x2f, 0x2e, 0x25, 0x00, 0xd9, 0xb0, 0xac, 0xa1, 0xb9, 0x59, 0x39, 0xd9, 0xb2, 0xa5, 0xb4, 0xb5,
        0xb2, 0xae, 0x59, 0xa9, 0x40, 0x48, 0xaa, 0xa9, 0x00, 0x48, 0xa8, 0x84, 0xcd, 0x84, 0xcb, 0x86, 0xcc, 0xa2, 0xc0, 0x86,
        0xce, 0xb1, 0xcd, 0x91, 0xcb, 0x88, 0xd0, 0xf9, 0xe6, 0xcc, 0xe6, 0xce, 0xe8, 0xf0, 0x08, 0xe0, 0xd0, 0xd0, 0xee, 0xa2,
        0xd8, 0xd0, 0xe8, 0x78, 0x68, 0x8d, 0x0e, 0xd4, 0xad, 0x01, 0xd3, 0x29, 0xfe, 0x8d, 0x01, 0xd3, 0xa9, 0xcb, 0x8d, 0x2e,
        0x32, 0xa9, 0xcd, 0x8d, 0x30, 0x32, 0xa9, 0x60, 0x8d, 0x48, 0x32, 0xa9, 0x58, 0x8d, 0x43, 0x32, 0xa2, 0x40, 0x4c, 0x27,
        0x32, 0x72, 0x64, 0x61, 0x74, 0x61, 0x85, 0x00, 0x5d, 0x10, 0x55, 0x55, 0xfc, 0x00, 0x0c, 0x00, 0xd8, 0xeb, 0xdb, 0x18,
        0x60, 0x70, 0x70, 0x70, 0x42, 0x28, 0xd8, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x70, 0x70, 0x41, 0x08, 0xd8, 0x00, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52,
        0x57, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
        0x52, 0x52, 0x52, 0x52, 0x52, 0x57, 0x52, 0x52, 0x52, 0x52, 0x52, 0x45, 0x00, 0x00, 0x7c, 0x80, 0xad, 0xb0, 0xad, 0x80,
        0x7c, 0xb3, 0xa9, 0xb3, 0xb4, 0xa5, 0xad, 0xa1, 0x80, 0xa4, 0x8e, 0xa3, 0x8e, 0xa5, 0x8e, 0x80, 0xa3, 0xaf, 0xae, 0xa5,
        0xa3, 0xb4, 0xa1, 0xa4, 0xaf, 0x7c, 0x80, 0xad, 0xb0, 0xad, 0x80, 0x7c, 0x00, 0x00, 0x5a, 0x52, 0x52, 0x52, 0x52, 0x52,
        0x58, 0x00, 0x68, 0x64, 0x61, 0x74, 0x61, 0x85, 0x00, 0x58, 0x00, 0x55, 0x55, 0xfc, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
        0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x58, 0x52,
        0x52, 0x52, 0x52, 0x52, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x80, 0x8b, 0x80, 0xb3, 0xaf, 0xa6, 0xb4, 0xb7, 0xa1, 0xb2, 0xa5, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x33, 0x29, 0x01, 0x71, 0x64, 0x61, 0x74, 0x61, 0x85, 0x00, 0x58, 0x00, 0x55, 0x55, 0xfc, 0x25, 0x23, 0x2f, 0x24, 0x00,
        0x2c, 0x74, 0x64, 0x61, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x61, 0x73, 0x69, 0x6c, 0x6c, 0x61, 0x00, 0x11, 0x16, 0x12, 0x19, 0x16, 0x00,
        0x30, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x21, 0x2e, 0x34, 0x29,
        0x21, 0x27, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0xd1, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2,
        0xd2, 0xd2, 0xd2, 0x02, 0xb7, 0x64, 0x61, 0x74, 0x61, 0x85, 0x00, 0x51, 0x00, 0x55, 0x55, 0xfc, 0xd2, 0xd2, 0xd2, 0xd2,
        0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xc5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x03, 0x43, 0x64, 0x61, 0x74, 0x61, 0x85, 0x00, 0x4e, 0x00, 0x55, 0x55, 0xfc, 0x00, 0x00, 0x00,
        0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2,
        0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2,
        0xd2, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x9b, 0x64, 0x61, 0x74, 0x61, 0x85, 0x00, 0x50, 0x00, 0x55, 0x55, 0xfc, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xac, 0x64, 0x61, 0x74, 0x61, 0x85, 0x00, 0x58, 0x00, 0x55, 0x55, 0xfc, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
        0x52, 0x52, 0x52, 0x52, 0x52, 0x57, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x57, 0x52, 0x52,
        0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x45, 0x00, 0x00, 0x7c, 0xa2, 0xb9, 0xb4, 0xa5, 0xb3, 0x9a, 0x80,
        0x90, 0x90, 0x90, 0x90, 0x90, 0x7c, 0x80, 0x80, 0xac, 0xa5, 0xb9, 0xa5, 0xae, 0xa4, 0xaf, 0x80, 0x80, 0x7c, 0xa2, 0xac,
        0xaf, 0xb1, 0xb5, 0xa5, 0x9a, 0x80, 0x90, 0x90, 0x90, 0x7c, 0x00, 0x00, 0x5a, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
        0x52, 0x52, 0x52, 0x52, 0x52, 0x58, 0x52, 0x06, 0x9c, 0x64, 0x61, 0x74, 0x61, 0x85, 0x00, 0x5d, 0x00, 0x55, 0x55, 0xfc,
        0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x58, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
        0x52, 0x52, 0x43, 0x00, 0x80, 0x80, 0xac, 0xa5, 0xb9, 0xa5, 0xae, 0xa4, 0xaf, 0x80, 0x80, 0xa3, 0xaf, 0xb2, 0xb2, 0xa9,
        0xa7, 0xa9, 0xa5, 0xae, 0xa4, 0xaf, 0x00, 0xa2, 0x10, 0x9d, 0x48, 0x03, 0x98, 0x9d, 0x49, 0x03, 0x60, 0xa9, 0x02, 0xa0,
        0x00, 0x20, 0xaf, 0xdb, 0xa9, 0xcc, 0xa0, 0xdd, 0x9d, 0x44, 0x03, 0x98, 0x9d, 0x45, 0x03, 0xa9, 0x07, 0x9d, 0x42, 0x03,
        0x20, 0x2f, 0xdd, 0x10, 0x13, 0xa9, 0x3c, 0x8d, 0x02, 0xd3, 0xa2, 0x07, 0xbd, 0x08, 0xdd, 0x9d, 0x92, 0x03, 0xca, 0x10,
        0xf7, 0x4c, 0x92, 0x03, 0xa2, 0x10, 0x60, 0xa9, 0x04, 0x85, 0x01, 0xa9, 0x00, 0x85, 0x00, 0xa8, 0x91, 0x00, 0xc8, 0xd0,
        0xfb, 0xe6, 0x01, 0xa6, 0x01, 0xe0, 0xc0, 0xd0, 0x07, 0x97, 0x64, 0x61, 0x74, 0x61, 0x85, 0x00, 0x52, 0x00, 0x55, 0x55,
        0xfc, 0xf3, 0xa2, 0x1f, 0xa9, 0x00, 0x9d, 0x94, 0xd9, 0x9d, 0xbc, 0xd9, 0x9d, 0xe4, 0xd9, 0x9d, 0x0c, 0xda, 0xca, 0x10,
        0xf1, 0xa2, 0x00, 0x8e, 0x44, 0x02, 0xe8, 0x86, 0x09, 0x8e, 0xf8, 0x03, 0xa9, 0xc0, 0x85, 0x02, 0xa9, 0xe4, 0x85, 0x03,
        0xa9, 0x90, 0xa2, 0x02, 0x9d, 0x6b, 0xdb, 0x9d, 0x53, 0xdb, 0xca, 0x10, 0xf7, 0x20, 0x23, 0xdd, 0xa9, 0x3c, 0x8d, 0x02,
        0xd3, 0xa2, 0x10, 0xa9, 0x0c, 0x20, 0x2f, 0xdd, 0xa2, 0x03, 0xa9, 0x00, 0x9d, 0xe0, 0x02, 0xca, 0x10, 0xfa, 0x8d, 0xae,
        0xdb, 0xa2, 0x10, 0xa9, 0x03, 0x9d, 0x42, 0x03, 0xa9, 0xc9, 0x9d, 0x44, 0x03, 0xa9, 0xdd, 0x9d, 0x45, 0x03, 0xa9, 0x04,
        0x9d, 0x4a, 0x03, 0xa9, 0x80, 0x9d, 0x4b, 0x03, 0xa9, 0x0c, 0x8d, 0xfc, 0x02, 0x20, 0x2f, 0xdd, 0x20, 0xb9, 0xdb, 0xad,
        0xcc, 0xdd, 0x2d, 0xcd, 0xdd, 0xc9, 0xff, 0xd0, 0x07, 0x08, 0x50, 0x64, 0x61, 0x74, 0x61, 0x85, 0x00, 0x4e, 0x00, 0x55,
        0x55, 0xfc, 0xa9, 0x01, 0x8d, 0xae, 0xdb, 0xd0, 0xec, 0xad, 0xe0, 0x02, 0x0d, 0xe1, 0x02, 0xd0, 0x0c, 0xad, 0xcc, 0xdd,
        0x8d, 0xe0, 0x02, 0xad, 0xcd, 0xdd, 0x8d, 0xe1, 0x02, 0xad, 0xae, 0xdb, 0xd0, 0x03, 0x4c, 0x4d, 0xdd, 0xad, 0xcc, 0xdd,
        0x8d, 0x40, 0x02, 0xad, 0xcd, 0xdd, 0x8d, 0x41, 0x02, 0x20, 0xb9, 0xdb, 0x38, 0xad, 0xcc, 0xdd, 0xed, 0x40, 0x02, 0x9d,
        0x48, 0x03, 0xad, 0xcd, 0xdd, 0xed, 0x41, 0x02, 0x9d, 0x49, 0x03, 0xfe, 0x48, 0x03, 0xd0, 0x03, 0xfe, 0x49, 0x03, 0xad,
        0x40, 0x02, 0xac, 0x41, 0x02, 0x20, 0xc4, 0xdb, 0xad, 0xe2, 0x02, 0x0d, 0xe3, 0x02, 0xf0, 0x16, 0xa0, 0x10, 0xb9, 0xf7,
        0xdc, 0x99, 0xc0, 0x03, 0x88, 0x10, 0xf7, 0xa9, 0x00, 0x8d, 0xe2, 0x02, 0x8d, 0xe3, 0x02, 0x20, 0x23, 0xdd, 0x4c, 0x73,
        0xdc, 0xa9, 0xff, 0x8d, 0x01, 0xd3, 0x20, 0xce, 0x03, 0xa9, 0x09, 0x85, 0x64, 0x61, 0x74, 0x61, 0x85, 0x00, 0x50, 0x00,
        0x55, 0x55, 0xfc, 0xfe, 0x8d, 0x01, 0xd3, 0x60, 0x6c, 0xe2, 0x02, 0xa9, 0xff, 0x8d, 0x01, 0xd3, 0x6c, 0xe0, 0x02, 0xa9,
        0x3c, 0x8d, 0x02, 0xd3, 0xa2, 0x07, 0xbd, 0x08, 0xdd, 0x9d, 0x92, 0x03, 0xca, 0x10, 0xf7, 0x4c, 0x92, 0x03, 0xa9, 0x08,
        0x8d, 0x30, 0x02, 0xa9, 0xd8, 0x8d, 0x31, 0x02, 0x98, 0x60, 0xa9, 0x00, 0x8d, 0xc6, 0x02, 0x8d, 0x18, 0xd0, 0xa9, 0x0c,
        0x8d, 0xc5, 0x02, 0x8d, 0x17, 0xd0, 0xa9, 0x22, 0x8d, 0x2f, 0x02, 0x8d, 0x00, 0xd4, 0x20, 0x56, 0xe4, 0x4c, 0x23, 0xdd,
        0xad, 0xcc, 0xdd, 0x8d, 0x40, 0x02, 0xad, 0xcd, 0xdd, 0x8d, 0x41, 0x02, 0x20, 0xb9, 0xdb, 0x18, 0xad, 0xcc, 0xdd, 0x69,
        0x06, 0x85, 0x04, 0xad, 0xcd, 0xdd, 0x69, 0x00, 0x85, 0x05, 0x20, 0xb9, 0xdb, 0xad, 0xcc, 0xdd, 0x85, 0x0c, 0xad, 0xcd,
        0xdd, 0x85, 0x0d, 0xa0, 0x06, 0x0e, 0x41, 0x02, 0x2e, 0x40, 0x02, 0x0a, 0x8b, 0x64, 0x61, 0x74, 0x61, 0x85, 0x00, 0x56,
        0x00, 0x55, 0x55, 0xfc, 0x88, 0x10, 0xf7, 0xad, 0x40, 0x02, 0x9d, 0x49, 0x03, 0xad, 0x41, 0x02, 0x9d, 0x48, 0x03, 0xa5,
        0x04, 0x9d, 0x44, 0x03, 0xa5, 0x05, 0x9d, 0x45, 0x03, 0xa9, 0x07, 0x9d, 0x42, 0x03, 0x20, 0x2f, 0xdd, 0x38, 0xa5, 0x0c,
        0xe9, 0x01, 0xa8, 0xa9, 0x0d, 0xe9, 0x00, 0x48, 0x98, 0x48, 0xa0, 0x07, 0xb9, 0xc1, 0xdd, 0x99, 0x92, 0x03, 0x88, 0x10,
        0xf7, 0xa9, 0x3c, 0x8d, 0x02, 0xd3, 0x4c, 0x92, 0x03, 0xa9, 0xff, 0x8d, 0x01, 0xd3, 0x6c, 0x04, 0x00, 0x43, 0x3a, 0x9b,
        0x00, 0x04, 0x9d, 0x40, 0x02, 0xca, 0x10, 0xf7, 0xad, 0x42, 0x02, 0x85, 0x04, 0xad, 0x43, 0x02, 0x85, 0x05, 0xad, 0x04,
        0x04, 0x85, 0x0c, 0xad, 0x05, 0x04, 0x85, 0x0d, 0xa0, 0x7f, 0xb9, 0x00, 0x04, 0x91, 0x04, 0x88, 0x10, 0xf8, 0x18, 0xa5,
        0x04, 0x69, 0x80, 0x85, 0x04, 0xa5, 0x05, 0x69, 0x00, 0x85, 0x05, 0xce, 0x0b, 0x87, 0x64, 0x61, 0x74, 0x61, 0x85, 0x00,
        0x8d, 0x00, 0x55, 0x55, 0xfa, 0x41, 0x02, 0xf0, 0x12, 0xee, 0x0a, 0x03, 0x20, 0x59, 0xc6, 0x10, 0xdc, 0x20, 0x3e, 0xc6,
        0xad, 0xea, 0x03, 0xd0, 0xac, 0xf0, 0xf1, 0xad, 0xea, 0x03, 0xf0, 0x03, 0x20, 0x59, 0xc6, 0x20, 0x29, 0xc6, 0xb0, 0x9d,
        0x20, 0x3b, 0xc6, 0xe6, 0x09, 0x60, 0x18, 0xad, 0x42, 0x02, 0x69, 0x06, 0x85, 0x04, 0xad, 0x43, 0x02, 0x69, 0x00, 0x85,
        0x05, 0x6c, 0x04, 0x00, 0x6c, 0x0c, 0x00, 0xa2, 0x3d, 0xa0, 0xc4, 0x8a, 0xa2, 0x00, 0x9d, 0x44, 0x03, 0x98, 0x9d, 0x45,
        0x03, 0x00, 0x04, 0x9d, 0x40, 0x02, 0xca, 0x10, 0xf7, 0xad, 0x42, 0x02, 0x85, 0x04, 0xad, 0x43, 0x02, 0x85, 0x05, 0xad,
        0x04, 0x04, 0x85, 0x0c, 0xad, 0x05, 0x04, 0x85, 0x0d, 0xa0, 0x7f, 0xb9, 0x00, 0x04, 0x91, 0x04, 0x88, 0x10, 0xf8, 0x18,
        0xa5, 0x04, 0x69, 0x80, 0x85, 0x04, 0xa5, 0x05, 0x69, 0x00, 0x85, 0x05, 0x4c, 0x0c, 0xf0,
    };


}

#endif	/* LOADERS_H */

