#include "stdafx.h"

uint16_t ComputeCRC(const uint8_t *buf, uint32_t len, uint16_t initialCRC) {
	// x^16 + x^12 + x^5 + 1
	uint16_t crc = initialCRC;

	for(uint32_t i=0; i<len; ++i) {
		uint8_t c = buf[i];

		crc ^= (uint16_t)c << 8;

		for(int j=0; j<8; ++j) {
			uint16_t xorval = (crc & 0x8000) ? 0x1021 : 0;

			crc += crc;

			crc ^= xorval;
		}
	}

	return crc;
}

uint16_t ComputeInvertedCRC(const uint8_t *buf, uint32_t len, uint16_t initialCRC) {
	// x^16 + x^12 + x^5 + 1
	uint16_t crc = initialCRC;

	for(uint32_t i=0; i<len; ++i) {
		uint8_t c = ~buf[i];

		crc ^= (uint16_t)c << 8;

		for(int j=0; j<8; ++j) {
			uint16_t xorval = (crc & 0x8000) ? 0x1021 : 0;

			crc += crc;

			crc ^= xorval;
		}
	}

	return crc;
}

uint32_t ComputeByteSum(const void *buf, size_t len) {
	const uint8_t *src = (const uint8_t *)buf;

	uint32_t chk = 0;
	while(len--) {
		chk += *src++;
	}

	return chk;
}
