/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.general.m6502.instructions;

import org.javatari.general.m6502.Instruction;
import org.javatari.general.m6502.M6502;

public final class ASL
extends Instruction {
    private final int type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public ASL(M6502 cpu, int type) {
        super(cpu);
        this.type = type;
    }

    @Override
    public int fetch() {
        if (this.type == 0) {
            this.ea = -1;
            return 2;
        }
        if (this.type == 20) {
            this.ea = this.cpu.fetchZeroPageAddress();
            return 5;
        }
        if (this.type == 21) {
            this.ea = this.cpu.fetchZeroPageXAddress();
            return 6;
        }
        if (this.type == 10) {
            this.ea = this.cpu.fetchAbsoluteAddress();
            return 6;
        }
        if (this.type == 11) {
            this.ea = this.cpu.fetchAbsoluteXAddress();
            return 7;
        }
        throw new IllegalStateException("ASL Invalid Operand Type: " + this.type);
    }

    @Override
    public void execute() {
        if (this.type == 0) {
            byte val = this.cpu.A;
            this.cpu.CARRY = val < 0;
            this.cpu.A = val = (byte)(val << 1);
            this.cpu.ZERO = val == 0;
            this.cpu.NEGATIVE = val < 0;
        } else {
            byte val = this.cpu.bus.readByte(this.ea);
            this.cpu.CARRY = val < 0;
            val = (byte)(val << 1);
            this.cpu.ZERO = val == 0;
            this.cpu.NEGATIVE = val < 0;
            this.cpu.bus.writeByte(this.ea, val);
        }
    }
}

