/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.main;

import java.io.IOException;
import javax.swing.JOptionPane;
import org.javatari.parameters.Parameters;
import org.javatari.pc.room.Room;
import org.javatari.utils.Environment;
import org.javatari.utils.SwingHelper;
import org.javatari.utils.Terminator;

public final class MultiplayerClient {
    public static void main(String[] args) throws IOException, InterruptedException {
        Environment.init();
        Parameters.init(args);
        Room clientRoom = Room.buildClientRoom();
        clientRoom.powerOn();
        MultiplayerClient.askUserForConnection(clientRoom);
    }

    public static void askUserForConnection(final Room room) {
        SwingHelper.edtInvokeLater(new Runnable(){

            @Override
            public void run() {
                String server = Parameters.mainArg;
                while (true) {
                    if (server != null && !server.isEmpty()) {
                        try {
                            room.clientCurrentConsole().remoteReceiver().connect(server);
                            return;
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(null, "Unnable to connect to: " + server + "\n" + ex, "Atari Player 2 Client", 0);
                        }
                    }
                    do {
                        if ((server = (String)JOptionPane.showInputDialog(null, "Atari Player 1 Server address[:port]:", "Atari Player 2 Client", -1, null, null, server != null && !server.isEmpty() ? server : "localhost")) != null) continue;
                        Terminator.terminate();
                    } while ((server = server.trim()).isEmpty());
                }
            }
        });
    }
}

