/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.pc.cartridge;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jnlp.FileContents;
import javax.swing.JOptionPane;
import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeCreator;
import org.javatari.atari.cartridge.CartridgeDatabase;
import org.javatari.atari.cartridge.ROM;
import org.javatari.atari.cartridge.ROMFormatUnsupportedException;
import org.javatari.parameters.Parameters;
import org.javatari.pc.cartridge.BuiltInROM;

public final class ROMLoader {
    private static final int MAX_ROM_SIZE = 524288;
    private static final int MAX_STREAM_SIZE = 525312;
    public static final String VALID_LOAD_FILES_DESC = "ROM and Savestate files (.bin .rom .a26 .zip .jat)";
    public static final String[] VALID_LOAD_FILE_EXTENSIONS = new String[]{"bin", "rom", "a26", "zip", "jat"};
    public static final String VALID_STATE_FILE_DESC = "Javatari Savestate files (.jat)";
    public static final String VALID_STATE_FILE_EXTENSION = "jat";

    public static Cartridge load(String url, boolean provided) {
        try {
            return ROMLoader.load(new URL(url), provided);
        }
        catch (MalformedURLException ex) {
            ROMLoader.generalErrorMessage(ex, url);
            return null;
        }
    }

    public static Cartridge load(File file) {
        try {
            return ROMLoader.load(file.toURI().toURL(), false);
        }
        catch (MalformedURLException ex) {
            ROMLoader.generalErrorMessage(ex, file.getPath());
        }
        catch (AccessControlException ex) {
            ROMLoader.generalErrorMessage(ex, file.getPath());
        }
        return null;
    }

    public static Cartridge load(URL url, boolean provided) {
        InputStream stream = null;
        try {
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(5000);
            stream = conn.getInputStream();
            return ROMLoader.createFromExternalURL(stream, url.toString(), provided);
        }
        catch (AccessControlException ex) {
            ROMLoader.generalErrorMessage(ex, url.toString());
        }
        catch (IOException ex) {
            ROMLoader.generalErrorMessage(ex, url.toString());
        }
        return null;
    }

    public static Cartridge load(FileContents fileContents) {
        String fileName = "<unknown>";
        try {
            fileName = fileContents.getName();
            InputStream stream = fileContents.getInputStream();
            return ROMLoader.createFromExternalURL(stream, fileName, false);
        }
        catch (IOException ex) {
            ROMLoader.generalErrorMessage(ex, fileName);
            return null;
        }
    }

    public static Cartridge load(BuiltInROM builtInROM) {
        if (builtInROM.label != null) {
            Parameters.CARTRIDGE_LABEL = builtInROM.label;
        }
        if (builtInROM.labelColors != null) {
            Parameters.setCartridgeLabelColors(builtInROM.labelColors);
        }
        return ROMLoader.load(builtInROM.url, true);
    }

    private static Cartridge createFromExternalURL(InputStream stream, String romURL, boolean provided) {
        System.out.println("Loading Cartridge from: " + romURL);
        BufferedInputStream buffer = ROMLoader.bufferedStream(stream);
        try {
            Cartridge cartridge = ROMLoader.createCartridge(buffer, romURL, provided);
            return cartridge;
        }
        catch (ROMFormatUnsupportedException ex) {
            buffer.reset();
            InputStream romFromZIP = ROMLoader.getFirstROMFromZIP(buffer);
            if (romFromZIP == null) {
                throw ex;
            }
            Cartridge cartridge = ROMLoader.createCartridge(romFromZIP, romURL, provided);
            return cartridge;
        }
        catch (IOException ex) {
            ROMLoader.generalErrorMessage(ex, romURL);
        }
        finally {
            try {
                stream.close();
                buffer.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static Cartridge createCartridge(InputStream stream, String romURL, boolean provided) throws IOException, ROMFormatUnsupportedException {
        ROM rom = ROMLoader.createROM(stream, romURL);
        if (provided) {
            CartridgeDatabase.adjustInfoOfROMProvided(rom);
        }
        return CartridgeCreator.create(rom);
    }

    private static ROM createROM(InputStream stream, String romURL) throws IOException {
        int read;
        byte[] buffer = new byte[525312];
        int totalRead = 0;
        while ((read = stream.read(buffer, totalRead, 525312 - totalRead)) != -1 && (totalRead += read) < 525312) {
        }
        byte[] content = totalRead > 0 ? Arrays.copyOf(buffer, totalRead) : new byte[]{};
        return new ROM(romURL.trim(), content);
    }

    private static InputStream getFirstROMFromZIP(InputStream stream) throws IOException, ROMFormatUnsupportedException {
        ZipInputStream zipStream = new ZipInputStream(stream);
        ZipEntry entry;
        block0: while ((entry = zipStream.getNextEntry()) != null) {
            String entryName = entry.getName().toUpperCase();
            int i = 0;
            while (true) {
                if (i >= VALID_LOAD_FILE_EXTENSIONS.length) continue block0;
                if (entryName.endsWith(VALID_LOAD_FILE_EXTENSIONS[i].toUpperCase())) {
                    return zipStream;
                }
                ++i;
            }
            break;
        }
        return null;
    }

    private static BufferedInputStream bufferedStream(InputStream stream) {
        BufferedInputStream buf = new BufferedInputStream(stream, 525312);
        buf.mark(525312);
        return buf;
    }

    private static void generalErrorMessage(Exception ex, String location) {
        String tLoc;
        System.out.println("Could not load Cartridge from: " + location);
        System.out.println(ex);
        String string = tLoc = location == null ? "" : location.trim();
        if (tLoc.length() > 80) {
            tLoc = String.valueOf(tLoc.substring(0, 79)) + "...";
        }
        JOptionPane.showMessageDialog(null, "Could not load Cartridge from:\n" + tLoc + "\n\n" + ex.getClass().getSimpleName() + ": " + ex.getMessage(), "Error loading Cartridge", 0);
    }

    private static void romFormatUnsupportedErrorMessage(ROMFormatUnsupportedException ex, String location) {
        String tLoc;
        System.out.println("Could not load Cartridge from: " + location);
        System.out.println(ex.getMessage());
        String string = tLoc = location == null ? "" : location.trim();
        if (tLoc.length() > 80) {
            tLoc = String.valueOf(tLoc.substring(0, 79)) + "...";
        }
        JOptionPane.showMessageDialog(null, "Could not load Cartridge from:\n" + tLoc + "\n\n" + ex.getMessage(), "Error loading Cartridge", 0);
    }
}

