/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.pc.room;

import javax.swing.RootPaneContainer;
import org.javatari.pc.room.Room;
import org.javatari.pc.screen.DesktopScreenWindow;
import org.javatari.pc.screen.PanelScreen;
import org.javatari.pc.screen.Screen;

public class EmbeddedRoom
extends Room {
    private final RootPaneContainer parentContainer;
    private PanelScreen embeddedScreen;
    private DesktopScreenWindow windowScreen;

    private EmbeddedRoom(RootPaneContainer rootPaneContainer) {
        this.parentContainer = rootPaneContainer;
    }

    @Override
    protected Screen buildScreenPeripheral() {
        this.embeddedScreen = new PanelScreen(true);
        this.parentContainer.setContentPane(this.embeddedScreen);
        return this.embeddedScreen;
    }

    public void popUpScreen(boolean fullScreen) {
        if (this.screen != this.embeddedScreen) {
            return;
        }
        if (this.windowScreen == null) {
            this.windowScreen = this.buildDesktopScreenPeripheral();
        }
        this.currentConsole.pause();
        this.windowScreen.monitor().setCartridgeChangeEnabled(this.embeddedScreen.monitor().isCartridgeChangeEnabled());
        this.windowScreen.connect(this.currentConsole.videoOutput(), this.currentConsole.controlsSocket(), this.currentConsole.cartridgeSocket(), this.currentConsole.saveStateSocket());
        this.awtControls.connectScreen(this.windowScreen);
        this.windowScreen.powerOn(fullScreen);
        this.embeddedScreen.powerOff();
        this.embeddedScreen.setVisible(false);
        this.currentConsole.go();
        this.screen = this.windowScreen;
    }

    public void reembedScreen() {
        if (this.screen != this.windowScreen) {
            return;
        }
        this.currentConsole.pause();
        this.embeddedScreen.monitor().setCartridgeChangeEnabled(this.windowScreen.monitor().isCartridgeChangeEnabled());
        this.embeddedScreen.connect(this.currentConsole.videoOutput(), this.currentConsole.controlsSocket(), this.currentConsole.cartridgeSocket(), this.currentConsole.saveStateSocket());
        this.awtControls.connectScreen(this.embeddedScreen);
        this.embeddedScreen.powerOn();
        this.windowScreen.powerOff();
        this.windowScreen.setVisible(false);
        this.currentConsole.go();
        this.screen = this.embeddedScreen;
    }

    @Override
    public void exit() {
        this.powerOff();
    }

    public static Room buildStandaloneRoom(RootPaneContainer rootPaneContainer) {
        if (currentRoom != null) {
            throw new IllegalStateException("Room already built");
        }
        currentRoom = new EmbeddedRoom(rootPaneContainer);
        currentRoom.buildPeripherals();
        currentRoom.adjustPeripheralsToStandaloneOrServerOperation();
        currentRoom.buildAndPlugStandaloneConsole();
        return currentRoom;
    }

    public static Room buildServerRoom(RootPaneContainer rootPaneContainer) {
        if (currentRoom != null) {
            throw new IllegalStateException("Room already built");
        }
        currentRoom = new EmbeddedRoom(rootPaneContainer);
        currentRoom.buildPeripherals();
        currentRoom.adjustPeripheralsToStandaloneOrServerOperation();
        currentRoom.buildAndPlugServerConsole();
        return currentRoom;
    }

    public static Room buildClientRoom(RootPaneContainer rootPaneContainer) {
        if (currentRoom != null) {
            throw new IllegalStateException("Room already built");
        }
        currentRoom = new EmbeddedRoom(rootPaneContainer);
        currentRoom.buildPeripherals();
        currentRoom.adjustPeripheralsToClientOperation();
        currentRoom.buildAndPlugClientConsole();
        return currentRoom;
    }
}

