/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.pc.screen;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.TransferHandler;
import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeSocket;
import org.javatari.atari.console.savestate.SaveStateSocket;
import org.javatari.atari.controls.ConsoleControlsSocket;
import org.javatari.general.av.video.VideoSignal;
import org.javatari.parameters.Parameters;
import org.javatari.pc.screen.ConsolePanel;
import org.javatari.pc.screen.Monitor;
import org.javatari.pc.screen.MonitorPanel;
import org.javatari.pc.screen.ROMTransferHandlerUtil;
import org.javatari.pc.screen.Screen;

public final class PanelScreen
extends JPanel
implements Screen {
    public MonitorPanel monitorPanel = new MonitorPanel();
    public ConsolePanel consolePanel;
    private static final boolean CONSOLE_PANEL = Parameters.SCREEN_CONSOLE_PANEL;
    private static final long serialVersionUID = 1L;

    public PanelScreen(boolean screenFixedSize) {
        this.monitorPanel.monitor().setFixedSize(screenFixedSize);
        if (CONSOLE_PANEL) {
            this.consolePanel = new ConsolePanel(this.monitorPanel.monitor(), null);
        }
        this.monitorPanel.monitor().addControlInputComponents(this.keyControlsInputComponents());
        this.setup();
    }

    @Override
    public void connect(VideoSignal videoSignal, ConsoleControlsSocket controlsSocket, CartridgeSocket cartridgeSocket, SaveStateSocket savestateSocket) {
        this.monitorPanel.connect(videoSignal, controlsSocket, cartridgeSocket, savestateSocket);
        if (this.consolePanel != null) {
            this.consolePanel.connect(controlsSocket, cartridgeSocket);
        }
    }

    @Override
    public void powerOn() {
        this.setVisible(true);
        this.monitorPanel.powerOn();
        this.monitorPanel.requestFocus();
    }

    @Override
    public void powerOff() {
        this.monitorPanel.powerOff();
    }

    @Override
    public void destroy() {
        this.close();
        this.monitorPanel.destroy();
    }

    @Override
    public void close() {
        this.setVisible(false);
    }

    @Override
    public Monitor monitor() {
        return this.monitorPanel.monitor();
    }

    @Override
    public List<Component> keyControlsInputComponents() {
        ArrayList<Component> comps = new ArrayList<Component>(Arrays.asList(this));
        comps.addAll(this.monitorPanel.keyControlsInputComponents());
        if (this.consolePanel != null) {
            comps.add(this.consolePanel);
        }
        return comps;
    }

    private void setup() {
        this.setTransferHandler(new ROMDropTransferHandler());
        this.monitorPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (e.getComponent() == PanelScreen.this.monitorPanel) {
                    PanelScreen.this.validate();
                }
            }
        });
        this.setLayout(new FlowLayout(1, 0, 0));
        this.setOpaque(false);
        this.add(this.monitorPanel);
        if (this.consolePanel != null) {
            this.add(this.consolePanel);
        }
        this.validate();
    }

    private class ROMDropTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;

        private ROMDropTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!PanelScreen.this.monitorPanel.monitor().isCartridgeChangeEnabled()) {
                return false;
            }
            Transferable transf = support.getTransferable();
            if (!ROMTransferHandlerUtil.canAccept(transf)) {
                return false;
            }
            if (support.isDrop() && support.getUserDropAction() != 0x40000000) {
                support.setDropAction(1);
            }
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            PanelScreen.this.monitorPanel.monitor().showOSD("LOADING CARTRIDGE...", true);
            Cartridge cart = ROMTransferHandlerUtil.importCartridgeData(support.getTransferable());
            PanelScreen.this.monitorPanel.monitor().showOSD(null, true);
            if (cart == null) {
                return false;
            }
            boolean autoPower = !support.isDrop() || support.getDropAction() != 0x40000000;
            PanelScreen.this.monitorPanel.monitor().cartridgeInsert(cart, autoPower);
            return true;
        }
    }
}

