/*
 *      ether.h             (c) Peter Rottengatter  1997
 *                              perot@pallas.amp.uni-hannover.de
 *
 *      Included into the ETHER.STX source code files
 *
 *		Heavily modified for RTL 8012 by Vassilis Papathanassiou 1999
 */

#ifndef ETHER_H
#define ETHER_H



/*--------------------------------------------------------------------------*/


/*
 *   Ethernet packet header.
 */

typedef  struct eth_hdr {
     uint8   destination[6];    /* Destination hardware address             */
     uint8   source[6];         /* Source hardware address                  */
     uint16  type;              /* Ethernet protocol type                   */
     uint8   data[0];           /* Data block                               */
 } ETH_HDR;

#define  TYPE_IP      0x0800
#define  TYPE_ARP     0x0806
#define  TYPE_RARP    0x8035



/*--------------------------------------------------------------------------*/


/*
 *   ARP packet structure.
 */

typedef  struct arp_pkt {
     uint16  hardware_space;    /* Hardware address space identifier        */
     uint16  protocol_space;    /* Protocol address space identifier        */
     uint8   hardware_len;      /* Length of hardware address               */
     uint8   protocol_len;      /* Length of protocol address               */
     uint16  op_code;           /* Operation Code                           */
     uint8   src_ether[6];      /* Sender's hardware address                */
     uint32  src_ip;            /* Sender's protocol address                */
     uint8   dest_ether[6];     /* Target's hardware address                */
     uint32  dest_ip;           /* Target's protocol address                */
 } ARP;

#define  ARP_HARD_ETHER    1



/*--------------------------------------------------------------------------*/


/*
 *   ARP cache entry.
 */

typedef  struct arp_entry {
     int16   valid;             /* Validity flag                            */
     uint32  ip_addr;           /* IP address                               */
     uint8   ether[6];          /* EtherNet station address                 */
     struct arp_entry  *next;   /* Address of next ARP in chain             */
 } ARP_ENTRY;



/*--------------------------------------------------------------------------*/

/*
 *   Virtual initialisation block (kept from LANCE for simplicity).
 */

typedef  struct virt_init
{
     uint16  mode;              /* Mode word                                */
     uint8   addr[6];           /* Hardware address of this Etherport       */
     uint32  ladrf[2];          /* Logical address filter for multicasting  */
} VIRT_INIT;


/*--------------------------------------------------------------------------*/

/*
 *   Buffer access block for received packets
 */

typedef  struct bab
{
	uint8		junk[3];
	uint8		len_LSB;
	uint8		len_MSB;
	uint8		pkt_status;
	uint8		next_ptr[2];
	ETH_HDR		*data;         /* Address of data block                    */
	struct bab	*next_bab;     /* Address of next BAB in circular chain    */
} BAB;


/*--------------------------------------------------------------------------*/


#endif /* ETHER_H */
