//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include <stdio.h>
#include "fmain.h"
#include "ucstfile.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
Tfrm_main *frm_main;
//---------------------------------------------------------------------------
__fastcall Tfrm_main::Tfrm_main(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall Tfrm_main::SpeedButton1Click(TObject *Sender)
{
    if (dg_open->Execute()){
        ed_fname->Text = dg_open->FileName;
    };
}
//---------------------------------------------------------------------------
void __fastcall Tfrm_main::btn_startClick(TObject *Sender)
{
    TMFile *f = new TMFile(NULL);
    TMFile *f_out = new TMFile(NULL);
    AnsiString output_dir(ed_fname->Text);
    int address;            // offset pierwszego bajtu danych
    unsigned char ch,ch1;   // odczytany znak
    int screws;
    int count=0;            // ilo odczytanych znakw danego poziomu
    AnsiString buffer,str;

    sscanf(ed_address->Text.c_str(),"%X",&address);
    //if (!ed_output_dir->Text.IsEmpty() && *ed_output_dir->Text.AnsiLastChar() != '\\') ed_output_dir->Text += "\\";
    while(!output_dir.IsEmpty() && *output_dir.AnsiLastChar() != '\\') output_dir.Delete(output_dir.Length(),1);

    try{
        f->Path = ed_fname->Text;
        f->ReadOnly = true;
        f->Open();

        f->Pointer = address;
        str.sprintf ("Start at: %04Xh",address);
        m_output->Lines->Add(str);

        for(int y=0;y<ud_level_count->Position;++y){

            str.sprintf ("Level %d: %04Xh",y+ud_numeruj->Position,f->Pointer);
            m_output->Lines->Add(str);

            buffer.SetLength(0);
            count=0;
            screws=0;
            do{
                f->Read (&ch,1);
                if (ch<0x80){
                    // pakiet skompresowany - w ch ilo bajtw skompresowanych
                    f->Read (&ch1,1);
                    if (ch1==0) break;
                    for (int x=0;x<ch;++x){
                        buffer += (char)ch1;
                        ++ count;
                    };
                }else{
                    // pakiet nieskompresowany - w ch ilo bajtw nieskompresowanych
                    for (int x=0;x<ch-0x80;++x){
                        f->Read (&ch1,1);
                        buffer += (char)ch1;

                        // w tym bajcie ilo rubek
                        if (count==497) screws = ch1;

                        ++ count;
                    };
                };
            }while(/*count < 496*/ch!=0);

            // zapisz poziom do pliku
            f_out->Close();
            f_out->Path.sprintf("%slevel%03d.txt",output_dir,y+ud_numeruj->Position);
            f_out->ReadOnly = false;
            f_out->Open();

            // przekonwertuj znaki na drukowalne
            if (cbx_convert->Checked) Convert(buffer);

            // zapisz ilo rubek - rubki s liczb BCD - tutaj konwersja
            // zapisane jako hex, a odczytywane bda jako dec
            str.sprintf ("%03X",screws);
            f_out->WriteLine(str);

            // zapisz linie levelu
            for (int x=0;x<31;++x){
                str = buffer.SubString((x*16)+1,16);
                //m_output->Lines->Add(str);
                f_out->WriteLine(str);
            };

            f_out->Close();
        };

        f->Close();
    }catch(...){
        f->Close();
        f_out->Close();
        throw;
    };

    m_output->Lines->Add(AnsiString("Poziomy zapisano w: ") + output_dir);

};
//---------------------------------------------------------------------------



//--------------------------------------------------------
// Konwersja niektrych kodw na widoczne znaki
//--------------------------------------------------------
#define CONV_COUNT  35
unsigned char conv_table[2][CONV_COUNT] = {
//                                                    dziako                 blaster               laser      dziako ruchome   nietoperze              n.strzelaj.    stworki l.             stworki p.
    {0xA0,0x5C,0x7C,0x12,0x14,0x2B,0x13,0x06,0x2E,    0x1E,0x1F,0x1C,0x1D,    0x01,0x04,0x18,0x17,  0x5E,0x27, 0x0D,0x0E,        0x4B,0x4A,0x49,0x4C,    0x4E,0x4D,     0x41,0x42,0x43,0x44,    0x45,0x46,0x47,0x48},
    {'M' ,'M' ,'D' ,'D' ,'K' ,' ' ,'x' ,'o' ,'z' ,    '{' ,'}' ,'u' ,'d' ,    '[' ,']' ,'g' ,'h' ,  '^' ,'q' , '-' ,'-' ,        'a' ,'s' ,'v' ,'f' ,    'j' ,'k' ,     'A' ,'A' ,'A' ,'A' ,    'E' ,'E' ,'E' ,'E' }
};

void __fastcall Tfrm_main::Convert(AnsiString &_str){
    int len=_str.Length();

    for (int x=1;x<=len;++x){
        for (int y=0;y<CONV_COUNT;++y){
            if ((unsigned char)(_str[x]) == conv_table[0][y]){
                _str[x] = conv_table[1][y];
                break;
            };
        };
    };
};
