/*
 * Decompiled with CFR 0.152.
 */
package Robbo;

import Robbo.TAbout;
import Robbo.TBoard;
import Robbo.THelp;
import Robbo.TIntro;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class MidlRobbo
extends MIDlet
implements CommandListener {
    private Display mainDisplay;
    private TIntro introCanvas;
    private TBoard gameCanvas;
    private THelp helpCanvas;
    private TAbout aboutCanvas;
    private Command nextLevelCommand = new Command("Next level", 8, 1);
    private Command prevLevelCommand = new Command("Prev. level", 8, 1);
    private Command introExitCommand = new Command("Back", 2, 1);
    private Command explodeCommand = new Command("Explode", 4, 1);
    private Command backCommand = new Command("Back", 2, 2);
    private Command helpBackCommand = new Command("Back", 2, 1);

    public MidlRobbo() throws Exception {
        this.mainDisplay = Display.getDisplay((MIDlet)this);
        this.gameCanvas = new TBoard();
        this.introCanvas = new TIntro(this.gameCanvas, this);
        this.helpCanvas = new THelp(this.gameCanvas, this);
        this.aboutCanvas = new TAbout(this.gameCanvas, this);
        this.introCanvas.setFullScreenMode(true);
        this.gameCanvas.setFullScreenMode(true);
        this.helpCanvas.setFullScreenMode(true);
        this.aboutCanvas.setFullScreenMode(true);
        this.introCanvas.setCommandListener(this);
        this.introCanvas.addCommand(this.introExitCommand);
        this.gameCanvas.setCommandListener(this);
        this.gameCanvas.addCommand(this.explodeCommand);
        this.gameCanvas.addCommand(this.backCommand);
    }

    public void startApp() throws MIDletStateChangeException {
        if (this.gameCanvas.thread != null && this.gameCanvas.thread.isAlive()) {
            this.mainDisplay.setCurrent((Displayable)this.gameCanvas);
        } else {
            this.mainDisplay.setCurrent((Displayable)this.introCanvas);
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        try {
            this.gameCanvas.sound.Stop(5);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mainDisplay.setCurrent((Displayable)null);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.nextLevelCommand) {
            try {
                this.mainDisplay.setCurrent((Displayable)this.gameCanvas);
                this.gameCanvas.PlayLevelNo(this.gameCanvas.score.GetLevelNumber() + 1);
            }
            catch (Exception exception) {
                System.out.print(exception.toString() + "\r\n");
            }
        }
        if (command == this.prevLevelCommand) {
            try {
                this.mainDisplay.setCurrent((Displayable)this.gameCanvas);
                this.gameCanvas.PlayLevelNo(this.gameCanvas.score.GetLevelNumber() - 1);
            }
            catch (Exception exception) {
                System.out.print(exception.toString() + "\r\n");
            }
        }
        if (command == this.introExitCommand) {
            this.introCanvas.ExitCommand();
        }
        if (command == this.explodeCommand) {
            this.gameCanvas.ExplodeRobbo();
        }
        if (command == this.backCommand) {
            try {
                this.gameCanvas.StopPlaying();
                this.mainDisplay.setCurrent((Displayable)this.introCanvas);
            }
            catch (Exception exception) {
                System.out.print(exception.toString() + "\r\n");
            }
        }
        if (command == this.helpBackCommand) {
            System.out.print("helpBackCommand\r\n");
            this.mainDisplay.setCurrent((Displayable)this.introCanvas);
        }
    }

    public void PlayContinue() {
        try {
            this.mainDisplay.setCurrent((Displayable)this.gameCanvas);
            this.gameCanvas.PlayCurrentLevel();
        }
        catch (Exception exception) {
            System.out.print(exception.toString() + "\r\n");
        }
    }

    public void PlayNew() {
        try {
            this.mainDisplay.setCurrent((Displayable)this.gameCanvas);
            this.gameCanvas.PlayNewGame();
        }
        catch (Exception exception) {
            System.out.print(exception.toString() + "\r\n");
        }
    }

    public void Exit() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void Help() {
        this.mainDisplay.setCurrent((Displayable)this.helpCanvas);
    }

    public void About() {
        this.mainDisplay.setCurrent((Displayable)this.aboutCanvas);
    }

    public void Intro() {
        this.mainDisplay.setCurrent((Displayable)this.introCanvas);
    }
}

