/*
 * Decompiled with CFR 0.152.
 */
package Robbo;

import Robbo.TBoardItem;
import Robbo.TScore;
import Robbo.TSound;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.TiledLayer;

class TBoard
extends GameCanvas
implements Runnable {
    public static final int BOARD_WIDTH = 16;
    public static final int BOARD_HEIGHT = 31;
    private static final int CELL_SIZE = 16;
    private static final int ACTION_DELAY = 130;
    private static final int NO_OF_HI_LEVELS = 50;
    private static final int NO_OF_LO_LEVELS = 50;
    private static final int MAX_TICK = 1;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PLAYING = 1;
    private static final int STATE_STOP = 2;
    private static final int STATE_STOPPING = 3;
    private Image layerImage;
    private Image img_explode;
    private Image img_back;
    private TiledLayer layer;
    private Graphics g;
    public Thread thread;
    public Random rand;
    public TScore score;
    public TSound sound;
    private int thread_state;
    private int canvas_width;
    private int canvas_height;
    private int current_level;
    private int current_language;
    private int canvas_pos_x;
    private int canvas_pos_y;
    private int backg_color_r;
    private int backg_color_g;
    private int backg_color_b;
    public int wall_tile;
    public TBoardItem[][] items;
    public TBoardItem nullItem;
    public int robbo_pos_x;
    public int robbo_pos_y;
    public int keys;
    public int screws;
    public int ammo;
    public boolean zero_screws_informed;
    public boolean level_completed;
    public boolean robbo_defeated;
    public boolean robbo_frozen;
    public boolean robbo_catched_by_magnes;
    public int tick;
    private static final String[][] info = new String[][]{{"Level", "Keys", "Screws", "Ammo"}, {"Poziom", "Klucze", "\u015arubki", "Naboje"}};

    public TBoard() throws Exception {
        super(true);
        try {
            this.items = new TBoardItem[16][31];
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 31; ++j) {
                    this.items[i][j] = new TBoardItem();
                }
            }
            this.nullItem = new TBoardItem();
            this.nullItem.SetNew((byte)77, -1, -1, this);
            this.layerImage = Image.createImage((String)"/Robbo/res/Tiles.png");
            this.img_back = Image.createImage((String)"/Robbo/res/back_key.png");
            this.img_explode = Image.createImage((String)"/Robbo/res/explode_key.png");
            this.layer = new TiledLayer(16, 31, this.layerImage, 16, 16);
            this.rand = new Random();
            this.score = new TScore();
            this.sound = new TSound(this.score);
            this.thread_state = 0;
            this.current_language = 0;
            this.Clear();
        }
        catch (Exception exception) {
            throw new Exception("TBoard.TBoard " + exception.toString() + "\r\n");
        }
    }

    private void InitCanvas() {
        this.canvas_width = this.getWidth() / 16;
        this.canvas_height = this.getHeight() / 16;
    }

    private int NoOfLevels() throws Exception {
        switch (this.score.GetDifficulty()) {
            case 0: {
                return 50;
            }
            case 1: {
                return 50;
            }
        }
        throw new Exception("TBoard::NoOfLevels -> bad difficulty");
    }

    private void LoadLevelFromFile(int n) throws IOException, Exception {
        String string;
        InputStream inputStream = null;
        byte[] byArray = new byte[18];
        this.Clear();
        switch (this.score.GetDifficulty()) {
            case 0: {
                string = "lo";
                break;
            }
            case 1: {
                string = "hi";
                break;
            }
            default: {
                string = "lo";
            }
        }
        String string2 = String.valueOf(n);
        while (string2.length() < 3) {
            string2 = "0" + string2;
        }
        inputStream = this.getClass().getResourceAsStream("/Robbo/levels/" + string + "/level" + string2 + ".txt");
        if (inputStream != null) {
            inputStream.read(byArray, 0, 17);
            String string3 = new String(byArray, 0, 15);
            this.screws = Integer.parseInt(string3.substring(0, 3));
            this.wall_tile = Integer.parseInt(string3.substring(3, 6));
            this.backg_color_r = Integer.parseInt(string3.substring(6, 9));
            this.backg_color_g = Integer.parseInt(string3.substring(9, 12));
            this.backg_color_b = Integer.parseInt(string3.substring(12, 15));
            for (int i = 0; i < 31; ++i) {
                if (inputStream.read(byArray, 0, 18) != 18) {
                    throw new Exception("Too short line or no line in levelxxx.txt file");
                }
                if (byArray[16] != 13) {
                    throw new Exception("Too long line in levelxxx.txt file");
                }
                for (int j = 0; j < 16; ++j) {
                    this.items[j][i].SetNew(byArray[j], j, i, this);
                }
            }
        } else {
            throw new IOException("Could not find the game board for level " + n);
        }
        inputStream.close();
        this.current_level = n;
    }

    private void Clear() {
        this.layer.fillCells(0, 0, 16, 31, 1);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 31; ++j) {
                this.items[i][j].Clear();
            }
        }
        this.canvas_pos_x = 8 - this.canvas_width / 2;
        this.canvas_pos_y = 15 - this.canvas_height / 2;
        this.layer.setPosition(this.canvas_pos_x * 16 * -1, this.canvas_pos_x * 16 * -1);
        this.backg_color_r = 25;
        this.backg_color_g = 105;
        this.backg_color_b = 0;
        this.wall_tile = 66;
        this.robbo_pos_x = -1;
        this.robbo_pos_x = -1;
        this.current_level = 0;
        this.keys = 0;
        this.screws = 0;
        this.ammo = 0;
        this.zero_screws_informed = false;
        this.level_completed = false;
        this.robbo_defeated = false;
        this.robbo_frozen = false;
        this.robbo_catched_by_magnes = false;
        this.tick = 0;
    }

    private void SetCapsulesActive() {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 31; ++j) {
                if (this.items[i][j].type != 75) continue;
                this.items[i][j].action_item = true;
            }
        }
    }

    private void DrawBoard() {
        if (this.screws == 0 && !this.zero_screws_informed) {
            this.g.setColor(255, 255, 255);
            this.SetCapsulesActive();
            this.zero_screws_informed = true;
        } else {
            this.g.setColor(this.backg_color_r, this.backg_color_g, this.backg_color_b);
        }
        this.g.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 31; ++j) {
                this.layer.setCell(i, j, this.items[i][j].tile);
            }
        }
        this.layer.paint(this.g);
        this.g.setColor(200, 200, 200);
        this.g.setFont(Font.getFont((int)64, (int)0, (int)8));
        this.g.drawString(info[this.current_language][0] + ": " + this.current_level, 0, 0, 20);
        this.g.drawString(info[this.current_language][1] + ": " + this.keys, 0, 10, 20);
        this.g.drawString(info[this.current_language][2] + ": " + this.screws, 0, 20, 20);
        this.g.drawString(info[this.current_language][3] + ": " + this.ammo, 0, 30, 20);
        this.g.drawImage(this.img_back, this.getWidth(), this.getHeight(), 40);
        this.g.drawImage(this.img_explode, 0, this.getHeight(), 36);
        this.flushGraphics();
    }

    private void SetNewLayerPositionOnRobboMove() {
        if (this.robbo_pos_x - 2 < this.canvas_pos_x) {
            this.canvas_pos_x = this.robbo_pos_x - 3;
        } else if (this.robbo_pos_x + 2 > this.canvas_pos_x + this.canvas_width - 1) {
            this.canvas_pos_x = this.robbo_pos_x + 3 - (this.canvas_width - 1);
        }
        if (this.robbo_pos_y - 2 < this.canvas_pos_y) {
            this.canvas_pos_y = this.robbo_pos_y - 3;
        } else if (this.robbo_pos_y + 2 > this.canvas_pos_y + this.canvas_height - 1) {
            this.canvas_pos_y = this.robbo_pos_y + 3 - (this.canvas_height - 1);
        }
        if (this.canvas_pos_x < 0) {
            this.canvas_pos_x = 0;
        } else if (this.canvas_pos_x + this.canvas_width >= 16) {
            this.canvas_pos_x = 16 - this.canvas_width;
        }
        if (this.canvas_pos_y < 0) {
            this.canvas_pos_y = 0;
        } else if (this.canvas_pos_y + this.canvas_height >= 31) {
            this.canvas_pos_y = 31 - this.canvas_height;
        }
    }

    private void MoveLayerToNewPosition() {
        int n = 0;
        int n2 = 0;
        int n3 = this.canvas_pos_x * 16 * -1;
        int n4 = this.canvas_pos_y * 16 * -1;
        int n5 = this.layer.getX() - n3;
        int n6 = n5 > 48 || n5 < -48 ? 4 : 2;
        n5 = this.layer.getY() - n4;
        int n7 = n5 > 48 || n5 < -48 ? 4 : 2;
        if (this.layer.getX() > n3) {
            n = -1 * n6;
        } else if (this.layer.getX() < n3) {
            n = n6;
        }
        if (this.layer.getY() > n4) {
            n2 = -1 * n7;
        } else if (this.layer.getY() < n4) {
            n2 = n7;
        }
        this.layer.move(n, n2);
    }

    private void DrawStartingAnimation() throws Exception {
        this.sound.Effect(10);
        this.DrawBoard();
    }

    private void DrawStoppingAnimation() {
        long l = System.currentTimeMillis();
        if (this.level_completed) {
            this.g.setColor(255, 255, 255);
            this.g.setFont(Font.getFont((int)0, (int)1, (int)16));
            this.g.drawString("Level completed!!!", 10, 50, 20);
            this.flushGraphics();
        }
        while (System.currentTimeMillis() < l + 1500L) {
        }
    }

    private void DrawGratulationsAnimation() {
        long l = System.currentTimeMillis();
        if (this.level_completed) {
            this.g.setColor(255, 255, 255);
            this.g.setFont(Font.getFont((int)0, (int)1, (int)16));
            this.g.drawString("Congratulations!!!", 10, 70, 20);
            this.flushGraphics();
        }
        while (System.currentTimeMillis() < l + 1500L) {
        }
    }

    public void ExplodeRobbo() {
        this.Robbo().onShooted();
    }

    private void onGameAnimation() throws Exception {
        int n;
        int n2;
        for (n2 = 0; n2 < 16; ++n2) {
            for (n = 0; n < 31; ++n) {
                this.items[n2][n].Animate();
            }
        }
        for (n2 = 0; n2 < 16; ++n2) {
            for (n = 0; n < 31; ++n) {
                this.items[n2][n].animated_in_this_step = false;
            }
        }
    }

    private void onKeysPressed(int n) throws Exception {
        if ((n & 0x20) != 0 && this.FirePressed(n)) {
            this.Robbo().Shoot(0, false);
        } else if ((n & 0x40) != 0 && this.FirePressed(n)) {
            this.Robbo().Shoot(1, false);
        } else if ((n & 4) != 0 && this.FirePressed(n)) {
            this.Robbo().Shoot(2, false);
        } else if ((n & 2) != 0 && this.FirePressed(n)) {
            this.Robbo().Shoot(3, false);
        } else if ((n & 0x20) != 0) {
            this.Robbo().LetRobboMove(0);
        } else if ((n & 0x40) != 0) {
            this.Robbo().LetRobboMove(1);
        } else if ((n & 4) != 0) {
            this.Robbo().LetRobboMove(2);
        } else if ((n & 2) != 0) {
            this.Robbo().LetRobboMove(3);
        }
    }

    private boolean FirePressed(int n) {
        return (n & 0x800) != 0 || (n & 0x1000) != 0 || (n & 0x100) != 0;
    }

    public TBoardItem Robbo() {
        return this.items[this.robbo_pos_x][this.robbo_pos_y];
    }

    public void PlayNewGame() throws IOException, Exception {
        this.PlayLevelNo(1);
    }

    public void PlayCurrentLevel() throws IOException, Exception {
        this.PlayLevelNo(this.score.GetLevelNumber());
    }

    public void PlayLevelNo(int n) throws IOException, Exception {
        int n2 = n;
        this.current_language = this.score.GetLanguage();
        if (n2 < 1) {
            n2 = 1;
        } else if (n2 > this.NoOfLevels()) {
            n2 = this.NoOfLevels();
        }
        this.score.SetLevelNumber((byte)n2);
        this.InitCanvas();
        this.thread = new Thread(this);
        this.LoadLevelFromFile(n2);
        this.g = this.getGraphics();
        this.DrawStartingAnimation();
        this.thread.start();
    }

    public void StopPlaying() {
        this.thread_state = 2;
        try {
            System.out.print("joining...\r\n");
            this.thread.join();
            System.out.print("end of joining...\r\n");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        block11: {
            int n = 0;
            long l = System.currentTimeMillis();
            this.thread_state = 1;
            System.out.print("thread active!\r\n");
            try {
                while (true) {
                    this.score.SetLevelNumber((byte)this.current_level);
                    do {
                        if (this.thread_state == 1) {
                            this.SetNewLayerPositionOnRobboMove();
                            this.MoveLayerToNewPosition();
                            if (System.currentTimeMillis() > l + 130L) {
                                l = System.currentTimeMillis();
                                ++this.tick;
                                if (this.tick > 1) {
                                    this.tick = 0;
                                }
                                this.onGameAnimation();
                                n = this.getKeyStates();
                                if (!this.robbo_frozen && n != 0) {
                                    this.onKeysPressed(n);
                                }
                            }
                        } else {
                            this.thread_state = this.thread_state == 2 ? 3 : 0;
                        }
                        this.DrawBoard();
                    } while (this.thread_state != 0 && !this.level_completed && !this.robbo_defeated);
                    this.DrawStoppingAnimation();
                    if (this.thread_state == 0) break block11;
                    int n2 = this.level_completed ? this.current_level + 1 : this.current_level;
                    if (n2 > this.NoOfLevels()) break;
                    try {
                        this.LoadLevelFromFile(n2);
                        this.DrawStartingAnimation();
                    }
                    catch (Exception exception) {
                        break block11;
                    }
                }
                this.DrawGratulationsAnimation();
            }
            catch (Exception exception) {
                System.out.print(exception.toString() + "\r\n");
            }
        }
        this.thread_state = 0;
        System.out.print("end of thread work\r\n");
    }
}

