/*
 * Decompiled with CFR 0.152.
 */
package Robbo;

import Robbo.TBoard;

public class TBoardItem {
    public static final int TILE_NULL = 65;
    public static final int TILE_WALL_01 = 66;
    public static final int TILE_ROBBO_DOWN_1 = 25;
    public static final int TILE_ROBBO_DOWN_2 = 26;
    public static final int TILE_ROBBO_RIGHT_1 = 27;
    public static final int TILE_ROBBO_RIGHT_2 = 28;
    public static final int TILE_ROBBO_LEFT_1 = 29;
    public static final int TILE_ROBBO_LEFT_2 = 30;
    public static final int TILE_ROBBO_UP_1 = 31;
    public static final int TILE_ROBBO_UP_2 = 32;
    public static final int TILE_SCREW = 11;
    public static final int TILE_BOX = 9;
    public static final int TILE_ROLLBOX = 10;
    public static final int TILE_DOOR = 17;
    public static final int TILE_CAPSULE_01 = 41;
    public static final int TILE_CAPSULE_02 = 42;
    public static final int TILE_AMMO = 12;
    public static final int TILE_BOMB = 13;
    public static final int TILE_KEY = 14;
    public static final int TILE_SUPRISE = 15;
    public static final int TILE_RUBBLE = 16;
    public static final int TILE_LASER_L = 35;
    public static final int TILE_LASER_R = 33;
    public static final int TILE_LASER_U = 36;
    public static final int TILE_LASER_D = 34;
    public static final int TILE_MOV_GUN = 37;
    public static final int TILE_TELEPORT_1 = 43;
    public static final int TILE_TELEPORT_2 = 44;
    public static final int TILE_EXPLO_1 = 57;
    public static final int TILE_EXPLO_2 = 58;
    public static final int TILE_EXPLO_3 = 59;
    public static final int TILE_EXPLO_4 = 60;
    public static final int TILE_EXPLO_5 = 61;
    public static final int TILE_EXPLO_6 = 62;
    public static final int TILE_BULLET_UD = 51;
    public static final int TILE_BULLET_LR = 49;
    public static final int TILE_VOID = 56;
    public static final int TILE_R_HAND_MONSTER_1 = 5;
    public static final int TILE_R_HAND_MONSTER_2 = 6;
    public static final int TILE_L_HAND_MONSTER_1 = 7;
    public static final int TILE_L_HAND_MONSTER_2 = 8;
    public static final int TILE_MAGNES_L = 63;
    public static final int TILE_MAGNES_R = 64;
    public static final int TILE_BIRD_1 = 3;
    public static final int TILE_BIRD_2 = 4;
    public static final int TILE_EYES_UP = 1;
    public static final int TILE_EYES_DN = 2;
    public static final byte TYPE_NOT_INITIALIZED = 0;
    public static final byte TYPE_FLOOR = 32;
    public static final byte TYPE_WALL = 77;
    public static final byte TYPE_ROBBO = 42;
    public static final byte TYPE_SCREW = 36;
    public static final byte TYPE_BOX = 35;
    public static final byte TYPE_ROLLBOX = 111;
    public static final byte TYPE_DOOR = 68;
    public static final byte TYPE_CAPSULE = 75;
    public static final byte TYPE_AMMO = 33;
    public static final byte TYPE_BOMB = 64;
    public static final byte TYPE_KEY = 61;
    public static final byte TYPE_SUPRISE = 63;
    public static final byte TYPE_RUBBLE = 37;
    public static final byte TYPE_LASER_L = 60;
    public static final byte TYPE_LASER_R = 62;
    public static final byte TYPE_LASER_U = 94;
    public static final byte TYPE_LASER_D = 113;
    public static final byte TYPE_GUN_L = 123;
    public static final byte TYPE_GUN_R = 125;
    public static final byte TYPE_GUN_U = 117;
    public static final byte TYPE_GUN_D = 100;
    public static final byte TYPE_ROT_GUN = 122;
    public static final byte TYPE_BLASTER_L = 93;
    public static final byte TYPE_BLASTER_R = 91;
    public static final byte TYPE_BLASTER_U = 103;
    public static final byte TYPE_BLASTER_D = 104;
    public static final byte TYPE_VOID = 120;
    public static final byte TYPE_R_HAND_MONSTER = 69;
    public static final byte TYPE_L_HAND_MONSTER = 65;
    public static final byte TYPE_MAGNES_L = 41;
    public static final byte TYPE_MAGNES_R = 40;
    public static final byte TYPE_BIRD_R = 115;
    public static final byte TYPE_BIRD_D = 102;
    public static final byte TYPE_BIRD_L = 118;
    public static final byte TYPE_BIRD_U = 97;
    public static final byte TYPE_MOV_BIRD_R = 106;
    public static final byte TYPE_MOV_BIRD_L = 107;
    public static final byte TYPE_MOV_GUN = 45;
    public static final byte TYPE_EYES = 38;
    public static final byte TYPE_TELEPORT_0 = 48;
    public static final byte TYPE_TELEPORT_1 = 49;
    public static final byte TYPE_TELEPORT_2 = 50;
    public static final byte TYPE_TELEPORT_3 = 51;
    public static final byte TYPE_TELEPORT_4 = 52;
    public static final byte TYPE_TELEPORT_5 = 53;
    public static final byte TYPE_TELEPORT_6 = 54;
    public static final byte TYPE_TELEPORT_7 = 55;
    public static final byte TYPE_TELEPORT_8 = 56;
    public static final byte TYPE_TELEPORT_9 = 57;
    public static final byte TYPE_EXPLOSION = -128;
    public static final byte TYPE_BULLET_UD = -127;
    public static final byte TYPE_BULLET_LR = -126;
    public static final byte TYPE_LASER_ACTIVE_UD = -125;
    public static final byte TYPE_LASER_ACTIVE_LR = -124;
    public static final byte TYPE_LASER_PASSIVE_UD = -123;
    public static final byte TYPE_LASER_PASSIVE_LR = -122;
    public static final byte TYPE_BLASTER_BULLET = -121;
    private static final int SHOOT_PROPABILITY = 12;
    private static final int SHOOT_PROPABILITY_BIRD = 6;
    private static final int EYES_MOV_PROPABILITY = 3;
    private static final int GUN_ROT_PROPABILITY = 12;
    private static final int SHOOT_PROPABILITY_GUN_ROT = 7;
    public static final byte NO_SIDE = -1;
    public static final byte RIGHT = 0;
    public static final byte DOWN = 1;
    public static final byte LEFT = 2;
    public static final byte UP = 3;
    private static final int[] SRH_TELEPORT_RIGHT = new int[]{0, 3, 1, 2};
    private static final int[] SRH_TELEPORT_DOWN = new int[]{1, 2, 0, 3};
    private static final int[] SRH_TELEPORT_LEFT = new int[]{2, 1, 3, 0};
    private static final int[] SRH_TELEPORT_UP = new int[]{3, 0, 2, 1};
    public static final int ANI_SEQUENCE_MAX_LENGTH = 25;
    public static final int ANI_NO_SEQUENCE = 0;
    public static final int ANI_FREEZE_ROBBO = 2001;
    public static final int ANI_UNFREEZE_ROBBO = 2002;
    public static final int ANI_DO_NOTHING = 2003;
    public static final int ANI_SET_LEVEL_COMPLETED = 2004;
    public static final int ANI_SET_ROBBO_DEFEATED = 2005;
    public static final int ANI_EXPLODE_ALL_AROUND = 2006;
    public static final int ANI_EXPLODE_ALL_ITEMS = 2007;
    public static final int ANI_CHANGE_TYPE_TO = 1000;
    public static final int ANI_ACTIONS = 2000;
    private static final int[] SEQ_ROBBO_CAPSULE_APPEAR = new int[]{2003, 2003, 2003, 62, 61, 60, 59, 25, 2002};
    private static final int[] SEQ_ROBBO_CAPSULE_DISAPPEAR = new int[]{59, 60, 61, 62, 65, 2004};
    private static final int[] SEQ_ROBBO_TELEPORT_DISAPPEAR = new int[]{59, 60, 61, 62, 1032};
    private static final int[] SEQ_ROBBO_TELEPORT_APPEAR = new int[]{62, 61, 60, 59, 25, 2002};
    private static final int[] SEQ_ROBBO_TELEPORT_NOMOVE = new int[]{59, 60, 61, 62, 65, 62, 61, 60, 59, 25, 2002};
    private static final int[] SEQ_ROBBO_DEFEATED = new int[]{2001, 58, 59, 60, 61, 62, 65, 2007, 2003, 2003, 2003, 2003, 2003, 2003, 2005};
    private static final int[] SEQ_ITEM_EXPLODE_AND_DISAPPEAR = new int[]{58, 59, 60, 61, 62, 1032};
    private static final int[] SEQ_EXPLODE_BOMB = new int[]{57, 2006, 58, 59, 60, 61, 62, 1032};
    private static final int[] SEQ_BULLET_PUFF_AND_DISAPPEAR = new int[]{62, 1032};
    private static final int[] SEQ_BLASTER = new int[]{60, 59, 60, 61, 62, 1032};
    private static final int[] SEQ_LASER_EXPLODE_AND_DISAPPEAR = new int[]{62, 1032};
    private static final byte[] SUPRISES = new byte[]{36, 36, 36, 35, 111, 33, 33, 64, 61, 61, 63, 63, 63, 122, 45, 38, 38};
    public byte type;
    public int tile;
    public boolean action_item;
    public int pos_x;
    public int pos_y;
    private TBoard board;
    public int[] ani_sequence = new int[25];
    public int ani_pointer;
    public int moving_direction;
    public boolean animated_in_this_step;
    private boolean gun_move_in_this_step;

    public TBoardItem() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void Clear() {
        this.type = 0;
        this.tile = 65;
        this.action_item = false;
        this.pos_x = -1;
        this.pos_y = -1;
        this.ani_pointer = 0;
        this.animated_in_this_step = false;
        this.moving_direction = -1;
        this.gun_move_in_this_step = false;
    }

    private void Copy(TBoardItem tBoardItem, TBoardItem tBoardItem2) {
        tBoardItem2.action_item = tBoardItem.action_item;
        tBoardItem2.tile = tBoardItem.tile;
        tBoardItem2.type = tBoardItem.type;
        tBoardItem2.ani_pointer = tBoardItem.ani_pointer;
        tBoardItem2.moving_direction = tBoardItem.moving_direction;
        tBoardItem2.animated_in_this_step = tBoardItem.animated_in_this_step;
        tBoardItem2.gun_move_in_this_step = tBoardItem.gun_move_in_this_step;
        for (int i = 0; i < tBoardItem.ani_pointer; ++i) {
            tBoardItem2.ani_sequence[i] = tBoardItem.ani_sequence[i];
        }
    }

    public void SetNew(byte by, int n, int n2, TBoard tBoard) {
        this.Clear();
        this.type = by;
        this.pos_x = n;
        this.pos_y = n2;
        this.board = tBoard;
        this.tile = this.GetDefaultTile(by);
        this.action_item = this.GetDefaultActionType(by);
        switch (by) {
            case 42: {
                this.AniAddSequence(SEQ_ROBBO_CAPSULE_APPEAR);
                this.tile = 41;
                this.board.robbo_frozen = true;
                this.board.robbo_pos_x = this.pos_x;
                this.board.robbo_pos_y = this.pos_y;
                break;
            }
            case 36: {
                break;
            }
            case 115: {
                this.moving_direction = 0;
                break;
            }
            case 102: {
                this.moving_direction = 1;
                break;
            }
            case 118: {
                this.moving_direction = 2;
                break;
            }
            case 97: {
                this.moving_direction = 3;
                break;
            }
            case 106: {
                this.moving_direction = 0;
                break;
            }
            case 107: {
                this.moving_direction = 2;
                break;
            }
            case 45: {
                this.moving_direction = 0;
                break;
            }
            case 122: {
                this.moving_direction = 3;
            }
        }
    }

    private int GetDefaultTile(byte by) {
        int n = 65;
        switch (by) {
            case 77: {
                n = this.board.wall_tile;
                break;
            }
            case 42: {
                n = 25;
                break;
            }
            case 36: {
                n = 11;
                break;
            }
            case 35: {
                n = 9;
                break;
            }
            case 111: {
                n = 10;
                break;
            }
            case 68: {
                n = 17;
                break;
            }
            case 75: {
                n = 41;
                break;
            }
            case 33: {
                n = 12;
                break;
            }
            case 64: {
                n = 13;
                break;
            }
            case 61: {
                n = 14;
                break;
            }
            case 63: {
                n = 15;
                break;
            }
            case 37: {
                n = 16;
                break;
            }
            case 60: 
            case 93: 
            case 123: {
                n = 35;
                break;
            }
            case 62: 
            case 91: 
            case 125: {
                n = 33;
                break;
            }
            case 94: 
            case 103: 
            case 117: {
                n = 36;
                break;
            }
            case 100: 
            case 104: 
            case 113: {
                n = 34;
                break;
            }
            case 122: {
                n = 33;
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                n = 43;
                break;
            }
            case -128: {
                n = 65;
                break;
            }
            case -127: {
                n = 51;
                break;
            }
            case -126: {
                n = 49;
                break;
            }
            case 120: {
                n = 56;
                break;
            }
            case 69: {
                n = 5;
                break;
            }
            case 65: {
                n = 7;
                break;
            }
            case 41: {
                n = 63;
                break;
            }
            case 40: {
                n = 64;
                break;
            }
            case -125: 
            case -123: {
                n = 51;
                break;
            }
            case -124: 
            case -122: {
                n = 49;
                break;
            }
            case -121: {
                n = 62;
                break;
            }
            case 97: 
            case 102: 
            case 106: 
            case 107: 
            case 115: 
            case 118: {
                n = 4;
                break;
            }
            case 45: {
                n = 37;
                break;
            }
            case 38: {
                n = 1;
                break;
            }
            default: {
                n = 65;
            }
        }
        return n;
    }

    private boolean GetDefaultActionType(byte by) {
        boolean bl;
        switch (by) {
            case 77: {
                bl = false;
                break;
            }
            case 42: {
                bl = false;
                break;
            }
            case 36: {
                bl = false;
                break;
            }
            case 35: {
                bl = false;
                break;
            }
            case 111: {
                bl = false;
                break;
            }
            case 68: {
                bl = false;
                break;
            }
            case 75: {
                bl = false;
                break;
            }
            case 33: {
                bl = false;
                break;
            }
            case 64: {
                bl = false;
                break;
            }
            case 61: {
                bl = false;
                break;
            }
            case 63: {
                bl = false;
                break;
            }
            case 37: {
                bl = false;
                break;
            }
            case 60: 
            case 62: 
            case 91: 
            case 93: 
            case 94: 
            case 100: 
            case 103: 
            case 104: 
            case 113: 
            case 117: 
            case 123: 
            case 125: {
                bl = true;
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                bl = true;
                break;
            }
            case -128: {
                bl = false;
                break;
            }
            case -127: 
            case -126: {
                bl = true;
                break;
            }
            case -125: 
            case -124: {
                bl = true;
                break;
            }
            case -123: 
            case -122: {
                bl = false;
                break;
            }
            case -121: {
                bl = true;
                break;
            }
            case 120: {
                bl = false;
                break;
            }
            case 65: 
            case 69: {
                bl = true;
                break;
            }
            case 40: 
            case 41: {
                bl = true;
                break;
            }
            case 38: 
            case 45: 
            case 97: 
            case 102: 
            case 106: 
            case 107: 
            case 115: 
            case 118: {
                bl = true;
                break;
            }
            case 122: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean LetRobboMove(int n) throws Exception {
        int[] nArray = new int[1];
        switch (n) {
            case 0: {
                if (this.tile != 27 && this.tile != 28) {
                    this.tile = 27;
                }
                nArray[0] = this.tile == 27 ? 28 : 27;
                break;
            }
            case 1: {
                if (this.tile != 25 && this.tile != 26) {
                    this.tile = 25;
                }
                nArray[0] = this.tile == 25 ? 26 : 25;
                break;
            }
            case 2: {
                if (this.tile != 29 && this.tile != 30) {
                    this.tile = 29;
                }
                nArray[0] = this.tile == 29 ? 30 : 29;
                break;
            }
            case 3: {
                if (this.tile != 31 && this.tile != 32) {
                    this.tile = 31;
                }
                int n2 = nArray[0] = this.tile == 31 ? 32 : 31;
            }
        }
        if ((this.ItemOn((int)n).type < 48 || this.ItemOn((int)n).type > 57) && this.ani_pointer == 0) {
            this.AniAddSequence(nArray);
        }
        switch (this.ItemOn((int)n).type) {
            case 32: {
                this.Move(n);
                this.board.sound.Effect(1);
                this.LetRobboToCheckDeadlyItemsAround();
                return true;
            }
            case 35: 
            case 45: 
            case 63: 
            case 64: 
            case 111: {
                if (this.ItemOn(n).LetItemMove(n)) {
                    this.board.sound.Effect(6);
                    this.Move(n);
                    this.LetRobboToCheckDeadlyItemsAround();
                    return true;
                }
                return false;
            }
            case 61: {
                this.board.sound.Effect(9);
                this.Move(n);
                this.LetRobboToCheckDeadlyItemsAround();
                ++this.board.keys;
                return true;
            }
            case 68: {
                if (this.board.keys <= 0) break;
                this.board.sound.Effect(14);
                this.Move(n);
                --this.board.keys;
                this.LetRobboToCheckDeadlyItemsAround();
                return true;
            }
            case 36: {
                this.Move(n);
                if (this.board.screws > 0) {
                    --this.board.screws;
                }
                this.board.sound.Effect(2);
                this.LetRobboToCheckDeadlyItemsAround();
                return true;
            }
            case 33: {
                this.board.sound.Effect(8);
                this.Move(n);
                this.board.ammo += 9;
                this.LetRobboToCheckDeadlyItemsAround();
                return true;
            }
            case 75: {
                if (this.ItemOn((int)n).action_item) {
                    this.board.robbo_frozen = true;
                    this.board.sound.Effect(11);
                    this.AniAddSequence(SEQ_ROBBO_CAPSULE_DISAPPEAR);
                    return false;
                }
                if (this.ItemOn(n).LetItemMove(n)) {
                    this.board.sound.Effect(6);
                    this.Move(n);
                    this.LetRobboToCheckDeadlyItemsAround();
                    return true;
                }
                return false;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.board.sound.Effect(7);
                this.TeleportRobbo(n);
            }
        }
        return false;
    }

    private void TeleportRobbo(int n) {
        TBoardItem tBoardItem = this.ItemOn(n).FindNextTeleport();
        while (!this.TeleportTo(tBoardItem, n)) {
            tBoardItem = tBoardItem.FindNextTeleport();
        }
    }

    private TBoardItem FindNextTeleport() {
        int n;
        int n2;
        for (n2 = this.pos_y; n2 < 31; ++n2) {
            for (n = 0; n < 16; ++n) {
                if (n2 == this.pos_y && n <= this.pos_x || this.board.items[n][n2].type != this.type) continue;
                return this.board.items[n][n2];
            }
        }
        for (n2 = 0; n2 <= this.pos_y; ++n2) {
            for (n = 0; n < 16; ++n) {
                if (n2 == this.pos_y && n >= this.pos_x || this.board.items[n][n2].type != this.type) continue;
                return this.board.items[n][n2];
            }
        }
        return this;
    }

    private boolean TeleportTo(TBoardItem tBoardItem, int n) {
        int[] nArray = new int[4];
        switch (n) {
            case 0: {
                nArray = SRH_TELEPORT_RIGHT;
                break;
            }
            case 1: {
                nArray = SRH_TELEPORT_DOWN;
                break;
            }
            case 2: {
                nArray = SRH_TELEPORT_LEFT;
                break;
            }
            case 3: {
                nArray = SRH_TELEPORT_UP;
            }
        }
        for (int i = 0; i < 4; ++i) {
            if (tBoardItem.ItemOn((int)nArray[i]).type == 32) {
                TBoardItem tBoardItem2 = tBoardItem.ItemOn(nArray[i]);
                this.board.robbo_frozen = true;
                this.Copy(this, tBoardItem2);
                tBoardItem2.tile = 65;
                tBoardItem2.AniAddSequence(SEQ_ROBBO_TELEPORT_APPEAR);
                this.board.robbo_pos_x = tBoardItem2.pos_x;
                this.board.robbo_pos_y = tBoardItem2.pos_y;
                this.type = (byte)-128;
                this.AniAddSequence(SEQ_ROBBO_TELEPORT_DISAPPEAR);
                return true;
            }
            if (tBoardItem.ItemOn((int)nArray[i]).type != 42) continue;
            this.board.robbo_frozen = true;
            this.AniAddSequence(SEQ_ROBBO_TELEPORT_NOMOVE);
            return true;
        }
        return false;
    }

    private void LetItemToGoAndToFrom() throws Exception {
        if (this.type == 45) {
            boolean bl = this.gun_move_in_this_step = !this.gun_move_in_this_step;
            if (this.gun_move_in_this_step) {
                return;
            }
        }
        if (this.ItemOn((int)this.moving_direction).type != 32) {
            this.moving_direction = this.GetOppositeSide(this.moving_direction);
        } else {
            this.LetItemMove(this.moving_direction);
        }
        this.LetRobboToCheckDeadlyItemsAround();
    }

    private void LetEyesMove() {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        boolean bl = false;
        if (this.randomInt(3) == 0) {
            n = this.randomInt(4);
            if (n == 3) {
                this.tile = 1;
            }
            if (n == 1) {
                this.tile = 2;
            }
            this.LetItemMove(n);
        } else {
            if (this.pos_y > this.board.robbo_pos_y) {
                n3 = 3;
            } else if (this.pos_y < this.board.robbo_pos_y) {
                n3 = 1;
            }
            if (this.pos_x > this.board.robbo_pos_x) {
                n2 = 2;
            } else if (this.pos_x < this.board.robbo_pos_x) {
                n2 = 0;
            }
            if (n3 != -1) {
                if (n3 == 3) {
                    this.tile = 1;
                }
                if (n3 == 1) {
                    this.tile = 2;
                }
                bl = this.LetItemMove(n3);
            }
            if (!bl && n2 != -1) {
                this.LetItemMove(n2);
            }
        }
    }

    private void RandomRotateGun() throws Exception {
        if (this.randomInt(12) == 0) {
            this.moving_direction = this.randomInt(2) == 0 ? this.GetSideOnRightOf(this.moving_direction) : this.GetSideOnLeftOf(this.moving_direction);
            switch (this.moving_direction) {
                case 0: {
                    this.tile = 33;
                    break;
                }
                case 1: {
                    this.tile = 34;
                    break;
                }
                case 2: {
                    this.tile = 35;
                    break;
                }
                case 3: {
                    this.tile = 36;
                }
            }
        }
    }

    public boolean LetItemMove(int n) {
        if (this.ItemOn((int)n).type != 32) {
            if (this.type == 111) {
                if (this.action_item) {
                    this.ItemOn(n).onShooted();
                }
                this.action_item = false;
                this.moving_direction = -1;
            }
            return false;
        }
        if (this.type == 111) {
            this.action_item = true;
            this.moving_direction = n;
        }
        this.Move(n);
        return true;
    }

    private boolean LetLaserMove(int n) throws Exception {
        switch (this.ItemOn((int)n).type) {
            case 32: {
                this.MoveLaser(n);
                return true;
            }
            case -123: {
                if (n == 3 || n == 1) {
                    this.Move(n);
                    return true;
                }
                return false;
            }
            case -122: {
                if (n == 0 || n == 2) {
                    this.Move(n);
                    return true;
                }
                return false;
            }
            case 60: 
            case 62: 
            case 94: 
            case 113: {
                if (this.ItemOn((int)this.GetOppositeSide((int)n)).type == -122 || this.ItemOn((int)this.GetOppositeSide((int)n)).type == -123) {
                    return false;
                }
                this.action_item = false;
                this.AniAddSequence(SEQ_BULLET_PUFF_AND_DISAPPEAR);
                return true;
            }
        }
        this.ItemOn(this.moving_direction).onShooted();
        return false;
    }

    private void Move(int n) {
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n3 = 1;
                break;
            }
            case 2: {
                n2 = -1;
                break;
            }
            case 3: {
                n3 = -1;
            }
        }
        if (this.type == 42) {
            this.board.robbo_pos_x = this.pos_x + n2;
            this.board.robbo_pos_y = this.pos_y + n3;
        }
        this.Copy(this, this.board.items[this.pos_x + n2][this.pos_y + n3]);
        this.ChangeToFloor();
    }

    private void MoveLaser(int n) {
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n3 = 1;
                break;
            }
            case 2: {
                n2 = -1;
                break;
            }
            case 3: {
                n3 = -1;
            }
        }
        if (this.type == 42) {
            this.board.robbo_pos_x = this.pos_x + n2;
            this.board.robbo_pos_y = this.pos_y + n3;
        }
        this.Copy(this, this.board.items[this.pos_x + n2][this.pos_y + n3]);
        if (n == 0 || n == 2) {
            this.type = (byte)-122;
            this.tile = 49;
        } else {
            this.type = (byte)-123;
            this.tile = 51;
        }
        this.action_item = false;
    }

    private void ChangeToFloor() {
        this.action_item = false;
        this.ani_pointer = 0;
        this.tile = 65;
        this.type = (byte)32;
    }

    private TBoardItem ItemOn(int n) {
        if (this.pos_x == 0 && n == 2 || this.pos_y == 0 && n == 3 || this.pos_x >= 15 && n == 0 || this.pos_y >= 30 && n == 1) {
            System.out.print("TBoardItem::ItemOn - asking for over game board\r\n");
            return this.board.nullItem;
        }
        switch (n) {
            case 0: {
                return this.board.items[this.pos_x + 1][this.pos_y];
            }
            case 1: {
                return this.board.items[this.pos_x][this.pos_y + 1];
            }
            case 2: {
                return this.board.items[this.pos_x - 1][this.pos_y];
            }
            case 3: {
                return this.board.items[this.pos_x][this.pos_y - 1];
            }
        }
        return null;
    }

    public void Animate() throws Exception {
        if (this.animated_in_this_step) {
            return;
        }
        this.AnimateSequence();
        if (!this.action_item) {
            return;
        }
        this.animated_in_this_step = true;
        switch (this.type) {
            case -127: 
            case -126: {
                if (this.LetItemMove(this.moving_direction)) break;
                this.ItemOn(this.moving_direction).onShooted();
                this.type = (byte)-128;
                this.tile = 61;
                this.AniAddSequence(SEQ_BULLET_PUFF_AND_DISAPPEAR);
                break;
            }
            case -125: 
            case -124: {
                if (this.LetLaserMove(this.moving_direction)) break;
                this.moving_direction = this.GetOppositeSide(this.moving_direction);
                break;
            }
            case -121: {
                this.LetBlasterMove(this.moving_direction);
                break;
            }
            case 125: {
                this.RandomShoot(0, 12, false);
                break;
            }
            case 100: {
                this.RandomShoot(1, 12, false);
                break;
            }
            case 123: {
                this.RandomShoot(2, 12, false);
                break;
            }
            case 117: {
                this.RandomShoot(3, 12, false);
                break;
            }
            case 62: {
                this.RandomShoot(0, 12, true);
                break;
            }
            case 113: {
                this.RandomShoot(1, 12, true);
                break;
            }
            case 60: {
                this.RandomShoot(2, 12, true);
                break;
            }
            case 94: {
                this.RandomShoot(3, 12, true);
                break;
            }
            case 91: {
                this.RandomBlast(0, 12);
                break;
            }
            case 104: {
                this.RandomBlast(1, 12);
                break;
            }
            case 93: {
                this.RandomBlast(2, 12);
                break;
            }
            case 103: {
                this.RandomBlast(3, 12);
                break;
            }
            case 65: {
                this.OnTickSwitchTile(7, 8);
                this.MoveLeftHandMonster();
                this.LetRobboToCheckDeadlyItemsAround();
                break;
            }
            case 69: {
                this.OnTickSwitchTile(5, 6);
                this.MoveRightHandMonster();
                this.LetRobboToCheckDeadlyItemsAround();
                break;
            }
            case 41: {
                this.FindRobboToCatchHim(2);
                break;
            }
            case 40: {
                this.FindRobboToCatchHim(0);
                break;
            }
            case 42: {
                this.MoveRobboCatchedByMagnes();
                this.LetRobboToCheckDeadlyItemsAround();
                break;
            }
            case 111: {
                this.LetItemMove(this.moving_direction);
                break;
            }
            case 97: 
            case 102: 
            case 115: 
            case 118: {
                this.OnTickSwitchTile(3, 4);
                this.LetItemToGoAndToFrom();
                this.LetRobboToCheckDeadlyItemsAround();
                break;
            }
            case 106: 
            case 107: {
                this.OnTickSwitchTile(3, 4);
                this.RandomShoot(1, 6, false);
                this.LetItemToGoAndToFrom();
                this.LetRobboToCheckDeadlyItemsAround();
                break;
            }
            case 45: {
                this.RandomShoot(3, 12, false);
                this.LetItemToGoAndToFrom();
                this.LetRobboToCheckDeadlyItemsAround();
                break;
            }
            case 122: {
                this.RandomRotateGun();
                this.RandomShoot(this.moving_direction, 7, false);
                break;
            }
            case 38: {
                this.LetEyesMove();
                this.LetRobboToCheckDeadlyItemsAround();
                break;
            }
            case 75: {
                this.OnTickSwitchTile(41, 42);
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.OnTickSwitchTile(43, 44);
            }
        }
    }

    private void AnimateSequence() throws Exception {
        if (this.ani_pointer <= 0) {
            return;
        }
        int n = this.AniGet();
        if (n < 1000) {
            this.tile = n;
        } else if (n > 1000 && n < 2000) {
            this.type = (byte)(n - 1000);
            this.tile = this.GetDefaultTile(this.type);
            this.action_item = this.GetDefaultActionType(this.type);
            this.moving_direction = 0;
        } else {
            switch (n) {
                case 2001: {
                    this.board.robbo_frozen = true;
                    break;
                }
                case 2002: {
                    this.board.robbo_frozen = false;
                    break;
                }
                case 2003: {
                    break;
                }
                case 2006: {
                    this.ExplodeAllAround();
                    break;
                }
                case 2004: {
                    this.board.level_completed = true;
                    break;
                }
                case 2005: {
                    this.board.robbo_defeated = true;
                    break;
                }
                case 2007: {
                    this.ExplodeAllItems();
                }
            }
        }
    }

    private void ExplodeAllAround() throws Exception {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                if (this.pos_x + i < 0 || this.pos_y + j < 0 || this.pos_x + i >= 16 || this.pos_y + j >= 31 || i == 0 && j == 0) continue;
                this.board.items[this.pos_x + i][this.pos_y + j].onExplosion();
            }
        }
    }

    public void ExplodeAllItems() {
        try {
            this.board.sound.Effect(16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < 16; ++i) {
            block6: for (int j = 0; j < 31; ++j) {
                switch (this.board.items[i][j].type) {
                    case -128: 
                    case 0: 
                    case 32: 
                    case 77: 
                    case 120: {
                        continue block6;
                    }
                    default: {
                        this.board.items[i][j].type = (byte)-128;
                        this.board.items[i][j].tile = 57;
                        this.board.items[i][j].AniAddSequence(SEQ_ITEM_EXPLODE_AND_DISAPPEAR);
                    }
                }
            }
        }
    }

    private void AniAddSequence(int[] nArray) {
        int n = nArray.length;
        if (25 - this.ani_pointer < n) {
            System.out.print("Type: " + this.type + ", position: " + this.pos_x + "/" + this.pos_y + "\r\n");
            System.out.print("No more place for animation sequence!!!\r\n");
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.ani_sequence[this.ani_pointer + i] = nArray[i];
        }
        this.ani_pointer += n;
    }

    private int AniGet() {
        if (this.ani_pointer > 0) {
            int n = this.ani_sequence[0];
            for (int i = 0; i < this.ani_pointer - 1; ++i) {
                this.ani_sequence[i] = this.ani_sequence[i + 1];
            }
            --this.ani_pointer;
            return n;
        }
        return 0;
    }

    public void Shoot(int n, boolean bl) {
        if (this.type == 42) {
            switch (n) {
                case 0: {
                    this.tile = 27;
                    break;
                }
                case 1: {
                    this.tile = 25;
                    break;
                }
                case 2: {
                    this.tile = 29;
                    break;
                }
                case 3: {
                    this.tile = 31;
                }
            }
            if (this.board.ammo <= 0) {
                return;
            }
            --this.board.ammo;
        }
        if (this.ItemOn((int)n).type == 32) {
            this.ItemOn((int)n).type = n == 0 || n == 2 ? (bl ? (byte)-124 : (byte)-126) : (bl ? (byte)-125 : (byte)-127);
            this.ItemOn((int)n).action_item = this.GetDefaultActionType(this.ItemOn((int)n).type);
            this.ItemOn((int)n).moving_direction = n;
            this.ItemOn((int)n).tile = this.GetDefaultTile(this.ItemOn((int)n).type);
            if (this.type != 42) {
                this.ItemOn((int)n).animated_in_this_step = true;
            }
        } else if (this.ItemOn((int)n).type != -126 && this.ItemOn((int)n).type != -127) {
            this.ItemOn(n).onShooted();
        }
    }

    private void RandomShoot(int n, int n2, boolean bl) {
        int n3 = this.randomInt(n2);
        if (n3 == 0) {
            this.Shoot(n, bl);
        }
    }

    public void onShooted() {
        int[] nArray = new int[1];
        switch (this.type) {
            case 42: {
                if (!this.IsRobboVisible()) break;
                this.type = (byte)-128;
                this.board.robbo_frozen = true;
                this.AniAddSequence(SEQ_ROBBO_DEFEATED);
                try {
                    this.board.sound.Effect(15);
                }
                catch (Exception exception) {}
                break;
            }
            case 64: {
                this.type = (byte)-128;
                this.tile = 57;
                this.AniAddSequence(SEQ_EXPLODE_BOMB);
                try {
                    this.board.sound.Effect(12);
                }
                catch (Exception exception) {}
                break;
            }
            case 63: {
                this.type = (byte)-128;
                this.tile = 57;
                this.AniAddSequence(SEQ_ITEM_EXPLODE_AND_DISAPPEAR);
                nArray[0] = 1000 + SUPRISES[this.randomInt(SUPRISES.length)];
                this.AniAddSequence(nArray);
                try {
                    this.board.sound.Effect(15);
                }
                catch (Exception exception) {}
                break;
            }
            case 33: 
            case 37: 
            case 38: 
            case 65: 
            case 69: 
            case 97: 
            case 102: 
            case 106: 
            case 107: 
            case 115: 
            case 118: {
                this.type = (byte)-128;
                this.tile = 57;
                this.AniAddSequence(SEQ_ITEM_EXPLODE_AND_DISAPPEAR);
                try {
                    this.board.sound.Effect(15);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void RandomBlast(int n, int n2) {
        int n3 = this.randomInt(n2);
        if (n3 != 0) {
            return;
        }
        if (this.ItemOn((int)n).type == 42) {
            this.ItemOn(n).onShooted();
        } else if (this.IsBlastedItem(this.ItemOn((int)n).type)) {
            this.ItemOn((int)n).type = (byte)-121;
            this.ItemOn((int)n).tile = 62;
            this.ItemOn((int)n).moving_direction = n;
            this.ItemOn((int)n).action_item = true;
        }
    }

    private boolean IsBlastedItem(int n) {
        switch (n) {
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 63: 
            case 65: 
            case 69: 
            case 97: 
            case 102: 
            case 106: 
            case 107: 
            case 115: 
            case 118: {
                return true;
            }
        }
        return false;
    }

    private void LetBlasterMove(int n) throws Exception {
        int n2 = 0;
        int n3 = 0;
        if (this.IsBlastedItem(this.ItemOn((int)n).type)) {
            switch (n) {
                case 0: {
                    n2 = 1;
                    break;
                }
                case 1: {
                    n3 = 1;
                    break;
                }
                case 2: {
                    n2 = -1;
                    break;
                }
                case 3: {
                    n3 = -1;
                }
            }
            this.Copy(this, this.board.items[this.pos_x + n2][this.pos_y + n3]);
        } else {
            switch (this.ItemOn((int)n).type) {
                case 42: 
                case 64: {
                    this.ItemOn(n).onShooted();
                }
            }
            this.ChangeToFloor();
        }
        this.type = (byte)-128;
        this.tile = 61;
        this.action_item = false;
        this.AniAddSequence(SEQ_BLASTER);
    }

    public void onExplosion() throws Exception {
        switch (this.type) {
            case 42: {
                this.type = (byte)-128;
                this.board.robbo_frozen = true;
                this.AniAddSequence(SEQ_ROBBO_DEFEATED);
                break;
            }
            case 64: {
                this.board.sound.Effect(12);
                this.type = (byte)-128;
                this.AniAddSequence(SEQ_EXPLODE_BOMB);
                break;
            }
            case -128: 
            case -125: 
            case -124: 
            case -123: 
            case -122: 
            case 0: 
            case 40: 
            case 41: 
            case 75: 
            case 77: 
            case 120: {
                break;
            }
            case 60: 
            case 62: 
            case 94: 
            case 113: {
                this.LaserDisappear();
                this.type = (byte)-128;
                this.tile = 57;
                this.AniAddSequence(SEQ_ITEM_EXPLODE_AND_DISAPPEAR);
                break;
            }
            default: {
                this.type = (byte)-128;
                this.tile = 57;
                this.AniAddSequence(SEQ_ITEM_EXPLODE_AND_DISAPPEAR);
            }
        }
    }

    private void LaserDisappear() {
        block9: {
            int n;
            System.out.print("Laser disappear\r\n");
            switch (this.type) {
                case 60: {
                    n = 2;
                    break;
                }
                case 62: {
                    n = 0;
                    break;
                }
                case 94: {
                    n = 3;
                    break;
                }
                case 113: {
                    n = 1;
                    break;
                }
                default: {
                    return;
                }
            }
            TBoardItem tBoardItem = this;
            while (true) {
                tBoardItem = tBoardItem.ItemOn(n);
                if (tBoardItem.type == -122 && (n == 2 || n == 0)) {
                    tBoardItem.AniAddSequence(SEQ_LASER_EXPLODE_AND_DISAPPEAR);
                    continue;
                }
                if (tBoardItem.type == -124 && (n == 2 || n == 0)) {
                    tBoardItem.AniAddSequence(SEQ_LASER_EXPLODE_AND_DISAPPEAR);
                    break block9;
                }
                if (tBoardItem.type != -123 || n != 3 && n != 1) break;
                tBoardItem.AniAddSequence(SEQ_LASER_EXPLODE_AND_DISAPPEAR);
            }
            if (tBoardItem.type != -125 || n != 3 && n != 1) break block9;
            tBoardItem.AniAddSequence(SEQ_LASER_EXPLODE_AND_DISAPPEAR);
        }
    }

    private void MoveLeftHandMonster() throws Exception {
        if (this.moving_direction == -1) {
            this.moving_direction = this.ItemOn((int)1).type != 32 ? this.GetSideOnRightOf(1) : (this.ItemOn((int)0).type != 32 ? this.GetSideOnRightOf(0) : (this.ItemOn((int)3).type != 32 ? this.GetSideOnRightOf(3) : 3));
        }
        for (int i = 0; i < 2; ++i) {
            if (this.LetItemMove(this.GetSideOnLeftOf(this.moving_direction))) {
                this.ItemOn((int)this.GetSideOnLeftOf((int)this.moving_direction)).moving_direction = this.GetSideOnLeftOf(this.moving_direction);
                break;
            }
            this.moving_direction = this.GetSideOnRightOf(this.moving_direction);
        }
    }

    private void MoveRightHandMonster() throws Exception {
        if (this.moving_direction == -1) {
            this.moving_direction = this.ItemOn((int)3).type != 32 ? this.GetSideOnLeftOf(3) : (this.ItemOn((int)2).type != 32 ? this.GetSideOnLeftOf(2) : (this.ItemOn((int)1).type != 32 ? this.GetSideOnLeftOf(1) : 1));
        }
        for (int i = 0; i < 2; ++i) {
            if (this.LetItemMove(this.GetSideOnRightOf(this.moving_direction))) {
                this.ItemOn((int)this.GetSideOnRightOf((int)this.moving_direction)).moving_direction = this.GetSideOnRightOf(this.moving_direction);
                break;
            }
            this.moving_direction = this.GetSideOnLeftOf(this.moving_direction);
        }
    }

    private int GetSideOnLeftOf(int n) throws Exception {
        int n2;
        switch (n) {
            case 0: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            default: {
                throw new Exception("Illegal moving direction when asking for left hand");
            }
        }
        return n2;
    }

    private void FindRobboToCatchHim(int n) {
        block11: {
            block10: {
                if (this.board.robbo_catched_by_magnes) {
                    return;
                }
                if (this.board.robbo_frozen) {
                    return;
                }
                if (n != 0) break block10;
                for (int i = this.pos_x + 1; i < 16; ++i) {
                    if (this.board.items[i][this.pos_y].type != 32 && this.board.items[i][this.pos_y].type != 42) {
                        return;
                    }
                    if (this.board.items[i][this.pos_y].type != 42) continue;
                    try {
                        this.board.sound.Effect(13);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.board.robbo_frozen = true;
                    this.board.robbo_catched_by_magnes = true;
                    this.board.Robbo().moving_direction = 2;
                    this.board.Robbo().action_item = true;
                    this.board.Robbo().tile = 28;
                }
                break block11;
            }
            if (n != 2) break block11;
            for (int i = this.pos_x - 1; i >= 0; --i) {
                if (this.board.items[i][this.pos_y].type != 32 && this.board.items[i][this.pos_y].type != 42) {
                    return;
                }
                if (this.board.items[i][this.pos_y].type != 42) continue;
                try {
                    this.board.sound.Effect(13);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.board.robbo_frozen = true;
                this.board.robbo_catched_by_magnes = true;
                this.board.Robbo().moving_direction = 0;
                this.board.Robbo().action_item = true;
                this.board.Robbo().tile = 30;
            }
        }
    }

    private void MoveRobboCatchedByMagnes() {
        if (this.ItemOn((int)this.moving_direction).type == 32) {
            this.Move(this.moving_direction);
        } else {
            this.action_item = false;
            this.onShooted();
        }
    }

    private int GetSideOnRightOf(int n) throws Exception {
        int n2;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 0;
                break;
            }
            default: {
                throw new Exception("Illegal moving direction when asking for left hand");
            }
        }
        return n2;
    }

    private int GetOppositeSide(int n) throws Exception {
        int n2;
        switch (n) {
            case 0: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 1;
                break;
            }
            default: {
                throw new Exception("Illegal moving direction when asking for left hand");
            }
        }
        return n2;
    }

    private void LetRobboToCheckDeadlyItemsAround() {
        if (this.IsDeadlyItem(this.board.items[this.board.robbo_pos_x][this.board.robbo_pos_y].ItemOn((int)0).type) || this.IsDeadlyItem(this.board.items[this.board.robbo_pos_x][this.board.robbo_pos_y].ItemOn((int)1).type) || this.IsDeadlyItem(this.board.items[this.board.robbo_pos_x][this.board.robbo_pos_y].ItemOn((int)2).type) || this.IsDeadlyItem(this.board.items[this.board.robbo_pos_x][this.board.robbo_pos_y].ItemOn((int)3).type)) {
            this.board.ExplodeRobbo();
        }
    }

    private boolean IsDeadlyItem(int n) {
        switch (n) {
            case 38: 
            case 65: 
            case 69: 
            case 97: 
            case 102: 
            case 106: 
            case 107: 
            case 115: 
            case 118: {
                return true;
            }
        }
        return false;
    }

    private void OnTickSwitchTile(int n, int n2) {
        if (this.board.tick == 0) {
            this.tile = this.tile == n ? n2 : n;
        }
    }

    private boolean IsRobboVisible() {
        switch (this.tile) {
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private int randomInt(int n) {
        if (n <= 0) {
            return 0;
        }
        int n2 = this.board.rand.nextInt();
        n2 = n2 < 0 ? n2 * -1 : n2;
        return n2 % n;
    }

    private void jbInit() throws Exception {
    }
}

