/*
 * Decompiled with CFR 0.152.
 */
package Robbo;

import Robbo.MidlRobbo;
import Robbo.TBoard;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TIntro
extends Canvas {
    private Image introImage;
    private Image logoRobboImage;
    private TBoard board;
    private MidlRobbo midlet;
    private static final String[][] menu_0 = new String[][]{{"Play game", "Options", "Help", "About", "Exit"}, {"Gra", "Opcje", "Pomoc", "O tw\u00f3rcach", "Wyj\u015bcie"}};
    private static final String[][] menu_1 = new String[][]{{"Continue game", "New game", "Back"}, {"Kontynuuj", "Nowa gra", "Wr\u00f3\u0107"}};
    private static final String[][] menu_2 = new String[][]{{"Language: ", "Difficulty: ", "Sound: ", "Effects: ", "Back"}, {"J\u0119zyk: ", "Poziom: ", "Muzyka: ", "D\u017awi\u0119ki: ", "Wr\u00f3\u0107"}};
    private static final String[] languages = new String[]{"English", "Polski"};
    private static final String[][] diffs = new String[][]{{"easy", "hard"}, {"\u0142atwy", "trudny"}};
    private static final String[][] onOff = new String[][]{{"off", "on"}, {"wy\u0142.", "w\u0142."}};
    private String[] cur_menu;
    private int cur_menui = 0;
    private int cur_item = 0;
    private int cur_language = 0;
    private int cur_diff = 0;
    private int cur_sound = 1;
    private int cur_effects = 1;
    private boolean intro;

    public TIntro(TBoard tBoard, MidlRobbo midlRobbo) {
        this.board = tBoard;
        this.midlet = midlRobbo;
        this.intro = true;
        this.SetCurrentMenuItems();
        try {
            this.introImage = Image.createImage((String)"/Robbo/res/menu.png");
            this.logoRobboImage = Image.createImage((String)"/Robbo/res/robbo_logo.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(10, 10, 10);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.drawImage(this.introImage, graphics.getClipWidth() / 2, graphics.getClipHeight() / 2, 3);
        if (this.intro) {
            graphics.drawImage(this.logoRobboImage, graphics.getClipWidth() / 2, graphics.getClipHeight() / 2, 3);
        } else {
            Font font = Font.getFont((int)64, (int)1, (int)0);
            graphics.setFont(font);
            int n = graphics.getClipWidth() / 2;
            int n2 = graphics.getClipHeight() / 2 - 30;
            for (int i = 0; i < this.cur_menu.length; ++i) {
                String string = this.cur_menu[i];
                if (this.cur_menui == 2) {
                    if (i == 0) {
                        string = string + languages[this.cur_language];
                    }
                    if (i == 1) {
                        string = string + diffs[this.cur_language][this.cur_diff];
                    }
                    if (i == 2) {
                        string = string + onOff[this.cur_language][this.cur_sound];
                    }
                    if (i == 3) {
                        string = string + onOff[this.cur_language][this.cur_effects];
                    }
                }
                graphics.setColor(105, 105, 105);
                graphics.drawString(string, n - font.stringWidth(string) / 2, n2 + font.getHeight() * i, 20);
                if (i == this.cur_item) {
                    graphics.setColor(255, 80, 80);
                } else {
                    graphics.setColor(40, 40, 255);
                }
                graphics.drawString(string, n - font.stringWidth(string) / 2 - 1, n2 + font.getHeight() * i - 1, 20);
            }
        }
    }

    protected void keyPressed(int n) {
        if (this.intro) {
            this.intro = false;
        } else {
            switch (this.getGameAction(n)) {
                case 1: {
                    if (this.cur_item <= 0) break;
                    --this.cur_item;
                    break;
                }
                case 6: {
                    if (this.cur_item >= this.cur_menu.length - 1) break;
                    ++this.cur_item;
                    break;
                }
                case 8: {
                    this.OnSelectedMenuItem();
                }
            }
        }
        this.repaint();
        this.serviceRepaints();
        this.repaint();
        this.serviceRepaints();
    }

    protected void showNotify() {
        try {
            this.board.sound.Effect(5);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cur_language = this.board.score.GetLanguage();
        this.cur_diff = this.board.score.GetDifficulty();
        this.cur_sound = this.board.score.GetSound();
        this.cur_effects = this.board.score.GetEffects();
        this.cur_menui = 0;
        this.cur_item = 0;
        this.SetCurrentMenuItems();
    }

    protected void hideNotify() {
    }

    protected void SetCurrentMenuItems() {
        switch (this.cur_menui) {
            case 0: {
                this.cur_menu = menu_0[this.cur_language];
                break;
            }
            case 1: {
                this.cur_menu = menu_1[this.cur_language];
                break;
            }
            case 2: {
                this.cur_menu = menu_2[this.cur_language];
                break;
            }
            case 3: {
                this.cur_menu = languages;
                break;
            }
            case 4: {
                this.cur_menu = diffs[this.cur_language];
                break;
            }
            case 5: {
                this.cur_menu = onOff[this.cur_language];
                break;
            }
            case 6: {
                this.cur_menu = onOff[this.cur_language];
            }
        }
        this.cur_item = 0;
    }

    public void ExitCommand() {
        switch (this.cur_menui) {
            case 0: {
                this.midlet.Exit();
                break;
            }
            default: {
                this.cur_menui = 0;
                this.SetCurrentMenuItems();
                this.repaint();
                this.serviceRepaints();
                this.repaint();
                this.serviceRepaints();
            }
        }
    }

    private void OnSelectedMenuItem() {
        switch (this.cur_menui) {
            case 0: {
                this.OnSelectedMainMenuItem();
                break;
            }
            case 1: {
                this.OnSelectedPlayMenuItem();
                break;
            }
            case 2: {
                this.OnSelectedOptionsMenuItem();
                break;
            }
            case 3: {
                this.OnSelectedLanguagesMenuItem();
                break;
            }
            case 4: {
                this.OnSelectedDiffMenuItem();
                break;
            }
            case 5: {
                this.OnSelectedSoundMenuItem();
                break;
            }
            case 6: {
                this.OnSelectedEffectsMenuItem();
            }
        }
    }

    private void OnSelectedMainMenuItem() {
        switch (this.cur_item) {
            case 0: {
                this.cur_menui = 1;
                this.SetCurrentMenuItems();
                break;
            }
            case 1: {
                this.cur_menui = 2;
                this.SetCurrentMenuItems();
                break;
            }
            case 2: {
                this.midlet.Help();
                break;
            }
            case 3: {
                this.midlet.About();
                break;
            }
            case 4: {
                this.midlet.Exit();
            }
        }
    }

    private void OnSelectedPlayMenuItem() {
        switch (this.cur_item) {
            case 0: {
                try {
                    this.board.sound.Stop(5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.midlet.PlayContinue();
                break;
            }
            case 1: {
                try {
                    this.board.sound.Stop(5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.midlet.PlayNew();
                break;
            }
            case 2: {
                this.cur_menui = 0;
                this.SetCurrentMenuItems();
            }
        }
    }

    private void OnSelectedOptionsMenuItem() {
        switch (this.cur_item) {
            case 0: {
                this.cur_menui = 3;
                this.SetCurrentMenuItems();
                break;
            }
            case 1: {
                this.cur_menui = 4;
                this.SetCurrentMenuItems();
                break;
            }
            case 2: {
                this.cur_menui = 5;
                this.SetCurrentMenuItems();
                break;
            }
            case 3: {
                this.cur_menui = 6;
                this.SetCurrentMenuItems();
                break;
            }
            case 4: {
                this.cur_menui = 0;
                this.SetCurrentMenuItems();
            }
        }
    }

    private void OnSelectedLanguagesMenuItem() {
        this.cur_language = this.cur_item;
        this.board.score.SetLanguage((byte)this.cur_language);
        this.cur_menui = 2;
        this.SetCurrentMenuItems();
    }

    private void OnSelectedDiffMenuItem() {
        this.cur_diff = this.cur_item;
        this.board.score.SetDifficulty((byte)this.cur_diff);
        this.cur_menui = 2;
        this.SetCurrentMenuItems();
    }

    private void OnSelectedSoundMenuItem() {
        this.cur_sound = this.cur_item;
        this.board.score.SetSound((byte)this.cur_sound);
        if (this.cur_sound == 1) {
            try {
                this.board.sound.Effect(5);
            }
            catch (Exception exception) {}
        } else {
            try {
                this.board.sound.Stop(5);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cur_menui = 2;
        this.SetCurrentMenuItems();
    }

    private void OnSelectedEffectsMenuItem() {
        this.cur_effects = this.cur_item;
        this.board.score.SetEffects((byte)this.cur_effects);
        this.cur_menui = 2;
        this.SetCurrentMenuItems();
    }
}

