/*
 * Decompiled with CFR 0.152.
 */
package Robbo;

import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class TScore {
    private static final int SCORE_SIZE = 10;
    private static final int SCO_LEVEL_LO = 0;
    private static final int SCO_LEVEL_HI = 1;
    private static final int SCO_DIFFICULTY = 2;
    private static final int SCO_LANGUAGE = 3;
    private static final int SCO_SOUND = 4;
    private static final int SCO_EFFECTS = 5;
    private byte[] score = new byte[10];
    private RecordStore store;
    public byte sound_enable = 1;
    public byte effects_enable = 1;

    public TScore() {
        this.Clear();
        this.sound_enable = this.GetSound();
        this.effects_enable = this.GetEffects();
    }

    private void Clear() {
        for (int i = 0; i < 10; ++i) {
            this.score[i] = 0;
        }
        this.score[0] = 1;
        this.score[1] = 1;
        this.score[2] = 0;
        this.score[3] = 0;
        this.score[4] = 1;
        this.score[5] = 1;
    }

    private boolean Read() {
        this.Clear();
        try {
            this.store = RecordStore.openRecordStore((String)"RobboScore", (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            System.out.print(recordStoreException.toString());
        }
        if (this.store == null) {
            return false;
        }
        try {
            RecordEnumeration recordEnumeration = this.store.enumerateRecords(null, null, false);
            if (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                this.store.getRecord(n, this.score, 0);
            } else {
                this.Save();
            }
        }
        catch (RecordStoreException recordStoreException) {
            try {
                this.store.closeRecordStore();
            }
            catch (Exception exception) {
                System.out.print(exception.toString());
            }
            return false;
        }
        try {
            this.store.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.print(exception.toString());
        }
        return true;
    }

    private boolean Save() {
        try {
            this.store = RecordStore.openRecordStore((String)"RobboScore", (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            System.out.print(recordStoreException.toString());
        }
        if (this.store == null) {
            return false;
        }
        try {
            RecordEnumeration recordEnumeration = this.store.enumerateRecords(null, null, false);
            if (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                this.store.setRecord(n, this.score, 0, 10);
            } else {
                this.store.addRecord(this.score, 0, 10);
            }
        }
        catch (RecordStoreException recordStoreException) {
            try {
                this.store.closeRecordStore();
            }
            catch (Exception exception) {
                System.out.print(exception.toString());
            }
            return false;
        }
        try {
            this.store.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.print(exception.toString());
        }
        return true;
    }

    public byte GetLevelLoNumber() {
        this.Read();
        byte by = this.score[0];
        if (by < 1) {
            by = 1;
        }
        return by;
    }

    public void SetLevelLoNumber(byte by) {
        this.Read();
        this.score[0] = by;
        this.Save();
    }

    public byte GetLevelHiNumber() {
        this.Read();
        byte by = this.score[1];
        if (by < 1) {
            by = 1;
        }
        return by;
    }

    public void SetLevelHiNumber(byte by) {
        this.Read();
        this.score[1] = by;
        this.Save();
    }

    public byte GetLevelNumber() {
        this.Read();
        switch (this.score[2]) {
            case 0: {
                return this.score[0];
            }
            case 1: {
                return this.score[1];
            }
        }
        return 1;
    }

    public void SetLevelNumber(byte by) {
        this.Read();
        switch (this.score[2]) {
            case 0: {
                this.score[0] = by;
                break;
            }
            case 1: {
                this.score[1] = by;
            }
        }
        this.Save();
    }

    public byte GetDifficulty() {
        this.Read();
        return this.score[2];
    }

    public void SetDifficulty(byte by) {
        this.Read();
        this.score[2] = by;
        this.Save();
    }

    public byte GetLanguage() {
        this.Read();
        return this.score[3];
    }

    public void SetLanguage(byte by) {
        this.Read();
        this.score[3] = by;
        this.Save();
    }

    public byte GetSound() {
        this.Read();
        return this.score[4];
    }

    public void SetSound(byte by) {
        this.Read();
        this.score[4] = by;
        this.Save();
        this.sound_enable = by;
    }

    public byte GetEffects() {
        this.Read();
        return this.score[5];
    }

    public void SetEffects(byte by) {
        this.Read();
        this.score[5] = by;
        this.Save();
        this.effects_enable = by;
    }
}

