//-------------------------------
// Snakes of Atari Island
//
// Author: Jakub "JKR" Krzak
// Katowice, April 2012
//-------------------------------

.macro PRINT_AT
; :1 - column
; :2 - row
    ldy #:2
    lda _scr_lo,y
    clc
    adc #:1
    sta _arr
    lda _scr_hi,y
    adc #0
    sta _arr+1
    jsr _std_print_adr
.endm

.macro mvza
    mva #0 :1
.endm

.macro mwza
    mwa #0 :1
.endm


.macro setArrAt
; :1 - array name
; :2 - X
; :3 - Y
; :4 - value
   ldy :3
   lda :1_lo,y
   sta _arr
   lda :1_hi,y
   sta _arr+1
   ldy :2
   lda :4
   sta (_arr),y
.endm

.macro getArrAt
; :1 - array name
; :2 - X
; :3 - Y
   ldy :3
   lda :1_lo,y
   sta _arr
   lda :1_hi,y
   sta _arr+1
   ldy :2
   lda (_arr),y
.endm

    
.macro setScrAt
	setArrAt _scr :1 :2 :3
.endm

.macro getScrAt
	getArrAt _scr :1 :2
.endm


.macro setFldW
	setArrAt arrSnakeFldW :1 :2 :3
.endm

.macro getFldW
	getArrAt arrSnakeFldW :1 :2
.endm


.macro setFldB
	setArrAt arrSnakeFldB :1 :2 :3
.endm

.macro getFldB
	getArrAt arrSnakeFldB :1 :2
.endm


.macro getColor
	getArrAt ColorSchemes :1 :2
.endm

    
.macro putArrOnScr
; :1 - X
; :2 - Y
; :3 - width
; :4 - height
; :5 - array name
	mvza __x
	#while .byte __x <= #:3-1
		mvza __y
		#while .byte __y <= #:4-1
			mva __x __a
			adb __a #:1
			mva __y __b
			adb __b #:2
			
			ldy __y
			lda :5_lo,y
			sta _arr
			lda :5_hi,y
			sta _arr+1
			ldy __x
			lda (_arr),y
			sta __c
			setScrAt __a __b __c
			
			inc __y
		#end
		inc __x
	#end
.endm


.macro clearArray
; :1 - X
; :2 - Y
; :3 - width
; :4 - height
; :5 - array name
	mvza __x
	#while .byte __x <= #:3-1
		mvza __y
		#while .byte __y <= #:4-1
			mva __x __a
			adb __a #:1
			mva __y __b
			adb __b #:2
			
			setArrAt :5 __a __b #0
			
			inc __y
		#end
		inc __x
	#end
.endm

.macro clearFldW
	fillMemory arrSnakeFldW arrSnakeFldW_End 0
.endm

.macro clearFldB
	fillMemory arrSnakeFldB arrSnakeFldB_End 0
.endm

.macro IncW
	clc
	lda :1
	adc #1
	sta :1
	lda :1+1
	adc #0
	sta :1+1
.endm

.macro fillMemory
; :1 - targetAddr
; :2 - targetAddrEnd
; :3 - value
	mwa #:1 __a
	#while .word __a <> #:2
		ldy #0
		lda #:3
		sta (__a),y
		IncW __a
	#end
.endm

.macro exchangeMemory
; :1 - Addr1
; :2 - Addr1End
; :3 - Addr2
; :4 - procChange
	mwa #:1 __a
	mwa #:3 __x
	#while .word __a <> #:2
		ldy #0
		lda (__x),y
		pha
		lda (__a),y
		jsr :4
		jcc l1
		ldy #0
		sta (__x),y
l1
		pla
		jsr :4
		jcc l1
		ldy #0
		sta (__a),y
l2
		IncW __a 
		IncW __x 
	#end
.endm

.macro changeMemory
; :1 - Addr1
; :2 - Addr1End
; :3 - procChange
	mwa #:1 __a
	#while .word __a <> #:2
		ldy #0
		lda (__a),y
		jsr :3
		jcc l1
		ldy #0
		sta (__a),y
l1
		IncW __a
	#end
.endm

.macro checkFlag
	lda :1
	and #:2
	clc
	beq l1
	sec
l1
.endm

.macro setFlag
	lda :1
	ora #:2
	sta :1
.endm

.macro clearFlag
	lda :1
	and #(~:2)
	sta :1
.endm

.macro m_GetStickState
; :1 - SnW_Dir / SnB_Dir
; :2 - STICK0 / STICK1
	#if .byte :1 = #cRight
		lda :2 
		ora #8
		sta __a
	#else
	#if .byte :1 = #cUp
		lda :2 
		ora #1
		sta __a
	#else
	#if .byte :1 = #cLeft
		lda :2
		ora #4
		sta __a
	#else
		lda :2
		ora #2
		sta __a
	#end
	#end
	#end
.endm

.macro m_SetDirection 
; :1 - SnB_Dir / SnW_Dir
; :2 - SnB_tmpDir / SnW_tmpDir 
	#if .byte __a = #cRight .or .byte __a = #cLeft 
		#if .byte :1 = #cUp .or .byte :1 = #cDown
			mva __a :2 
		#end
	#else
	#if .byte __a = #cUp .or .byte __a = #cDown
		#if .byte :1 = #cRight .or .byte :1 = #cLeft
			mva __a :2
		#end
	#end
	#end
.endm

