//-------------------------------
// Snakes of Atari Island
//
// Author: Jakub "JKR" Krzak
// Katowice, April 2012
//-------------------------------


;-------------------------------------------------------------------------
IncrementBgrndColorPtr .proc
   lda _bgrndColorPtr
   cmp #5
   jne l1
   mvza _bgrndColorPtr
   jmp l2
l1:
   inc _bgrndColorPtr
l2:
   ldy _bgrndColorPtr
   lda ColorSchemes_lo,y
   sta _arr
   lda ColorSchemes_hi,y
   sta _arr+1
   ldy #0
   lda (_arr),y
   sta _bgrndClr
   rts
.endp


;-------------------------------------------------------------------------
CheckKeys .proc
	lda CH
	cmp #62 ;S
	jne l1
	
	; mute/unmute
	lda _mute
	jne l2
	mva #1 _mute
	mva #'d' _scr
	mva #'e' _scr+1
	jsr CMC_Stop
	mvza CH
	rts
l2:		
	mvza _mute
	mva #" " _scr
	mva #" " _scr+1
	ldx #0
	jsr CMC_PlaySong
	mvza CH
	rts

l1:
	cmp #18 ;C
	jne l3
	jsr IncrementBgrndColorPtr
	#if .word SDLSTL = #DList2
		ldy #3
		lda (_arr),y
		ora #$03
		sta PM_COLS0
		sta PM_COLS1
	#else
		ldy #3
		lda (_arr),y
		sta PM_COLS0
		sta PM_COLS1
		sta PM_COLS2
	#end
	mvza CH

l3:
	cmp #47 ;Q
	jne l4
	mva #cUp _tmpState
	mvza CH
	rts
	
l4:
	cmp #63 ;A
	jne l5
	mva #cDown _tmpState
	mvza CH
	rts

l5:
	cmp #8 ;O
	jne l6
	mva #cLeft _tmpState
	mvza CH
	rts

l6:
	cmp #10 ;P
	jne l7
	mva #cRight _tmpState
	mvza CH
	rts

l7:
	rts
.endp

;-------------------------------------------------------------------------
CheckTrigger .proc
	#if .byte STRIG0 = #btn_pressed .or .byte STRIG1 = #btn_pressed
		jmp Released 
	#end
	lda CH
	cmp #33 ;Space
	 jeq Released
	clc
	rts
	
Released
	#if .byte STRIG0 = #btn_pressed .or .byte STRIG1 = #btn_pressed
		jmp Released 
	#end
	lda SKSTAT
	and #4
	 jeq Released
	sec
	rts
.endp

;-------------------------------------------------------------------------
ChangeMsg .proc

	mwa #_msg _arr

	#if .byte _msgNum = #0
		jsr _std_print_adr
		dta 40, c'    aaa  SNAKES OF ATARI ISLAND  aaa    ', 0
	#else

	#if .byte _msgNum = #1
		jsr _std_print_adr
		dta 40, c'       AUTHOR:  JAKUB "JKR" KRZAK       ', 0
	#else

	#if .byte _msgNum = #2
		jsr _std_print_adr
		dta 40, c'    MUSIC BY: PIOTR "PAPTAK" NOWICKI    ', 0
	#else

	#if .byte _msgNum = #3
		jsr _std_print_adr
		dta 40, c'  GREETINGS TO 8-BIT ATARI ENTHUSIASTS  ', 0
	#else

	#if .byte _msgNum = #4
		jsr _std_print_adr
		dta 40, c'       AT GRZYBSONIADA 2012 PARTY       ', 0
	#else

	#if .byte _msgNum = #5
		jsr _std_print_adr
		dta 40, c'         AND ALL OVER THE WORLD         ', 0
	#else

	#if .byte _msgNum = #6
		jsr _std_print_adr
		dta 40, c'    aaa  PRESS TRIGGER TO START  aaa    ', 0
	#else

	#if .byte _msgNum = #7
		jsr _std_print_adr
		dta 40, c'   aaa  PRESS S FOR SOUND ON/OFF  aaa   ', 0
	#else

	#if .byte _msgNum = #8
		jsr _std_print_adr
		dta 40, c'  aaa   PRESS C TO CHANGE COLORS   aaa  ', 0
		mva #(0 -1) _msgNum ; loop msgs
	#else


	#if .byte _msgNum = #10
		jsr _std_print_adr
		dta 40, c'  aaa  SELECT GAME MODE WITH  i j  aaa  ', 0
	#else    

	#if .byte _msgNum = #11
		jsr _std_print_adr
		dta 40, c'    aaa  SELECT WALLS WITH  k l  aaa    ', 0
	#else

	#if .byte _msgNum = #12
		jsr _std_print_adr
		dta 40, c'   aaa  PRESS S FOR SOUND ON/OFF  aaa   ', 0
	#else

	#if .byte _msgNum = #13
		jsr _std_print_adr
		dta 40, c'  aaa   PRESS C TO CHANGE COLORS   aaa  ', 0
	#else

	#if .byte _msgNum = #14
		jsr _std_print_adr
		dta 40, c'    aaa  PRESS TRIGGER TO START  aaa    ', 0
		mva #(10 -1) _msgNum ; loop msgs
		
	#end
	#end
	#end
	#end
	#end
	#end
	#end
	#end
	#end
	#end
	#end
	#end
	#end
	#end

	inc _msgNum
	setFlag _msgFlags cMsgDown_Change
	
	#if .word HiScore <> #$FFFF
		#if .byte _msgNum2 = #0

			mwa #_msg2 _arr
			jsr _std_print_adr
		   	dta 40, c'    aaa    HIGH SCORE:         aaa      ', 0
			mwa #_msg2+23 _arr
			jsr _std_print_adr
			dta 130, a(HiScore), 0
			
			setFlag _msgFlags cMsgUp_Change
			inc _msgNum2

		#else
		#if .byte _msgNum2 = #1

			lda #<_msg2
			sta _arr
			lda #>_msg2
			sta _arr+1
			jsr _std_print_adr
		   	dta 40, c'    aaa  SNAKES OF ATARI ISLAND  aaa    ', 0

			setFlag _msgFlags cMsgUp_Change
			mvza _msgNum2

		#end
		#end
	#end

	lda #0
	sta tmrDisplMsgs 
	sta tmrDisplMsgs +1 
	rts
.endp

;-------------------------------------------------------------------------
ClearMsg .proc
	
	mvza _msgFlags
	
	ldx #2
l1	mva #0 _scr,x
	inx
	cpx #40
	bne l1
	ldx #0
l2	mva #0 _scrL24,x
	inx
	cpx #40
	bne l2
	
	mva #2 DLScrllLine
	mva #2 DLScrllLine2
	mva #cMaxMsgBrtnss _msgBrLower
	mva #cMaxMsgBrtnss _msgBrUpper
	rts
.endp


;-------------------------------------------------------------------------
Rainbow .proc
; do the Atari rainbow (COL_BK = VCOUNT * 2 + RTCLOCK)
   lda VCOUNT
   asl
   clc
   adc RTCLOCK
   sta COL_BK

   lda _mute
   seq
   rts
   
   lda CMCplayer_songLine
   cmp #23
   sne 
   jsr CMC_StopFadeOut	; stop CMC

   rts
.endp
