//-------------------------------
// Snakes of Atari Island
//
// Author: Jakub "JKR" Krzak
// Katowice, April 2012
//-------------------------------
	
	;switch off BASIC
	ORG $2000
	mva #$FF PORTB
	mva #$02 $22F  ; swith off display
	rts
	INI $2000

	ORG $9000
	
scr	INS "include\snake.raw"

	.ALIGN $0400
ant	ANTIC_PROGRAM scr,ant

splash

c0	lda #$0E
	sta 712
c1	lda #$00
	sta 708
c2	lda #$B8; E8
	sta 709
c3	lda #$06
	sta 710
c4	lda #$08
	sta 711

	mwa #ant 560

	mva #$22 $22F  ; swith on display

    ; set VBI vector
    mva #0 NMIEN
    mwa #SPL_VBI_Proc VVBLKD
    mva #64 NMIEN
   
    jsr CMC_Init
    
	mva RTCLOCK 0
	
	ldx #.len(Notes) -1
	
loop
	
	lda RTCLOCK
	and #$F8
	beq loop
	
	mva #0 RTCLOCK
	
   	lda Notes,x 
   	tay
   	
   	txa
   	pha

	tya
	tax ; note
	lda #1 ; channel
	ldy #2 ; instrument   	
	jsr CMC_PlayNote
	
	pla
	tax
	dex
	bpl loop

go
    ; set VBI vector
    mva #0 NMIEN
    mwa #$e462 VVBLKD
    mva #64 NMIEN

	rts			;return to ... DOS

SPL_VBI_Proc .proc
	jsr CMCplayer_tact
	jmp $e462
.endp

.array Notes .byte
	0, 29, 27, 25, 25, 29, 27, 25, 25
.enda
 
.MACRO	ANTIC_PROGRAM
	dta $70
	dta $70
	dta $4e,a(:1+$0000),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0140),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0280),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$03C0),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0500),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0640),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0780),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$08C0),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0A00),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0B40),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0C80),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0DC0),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$1000),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$1140),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$1280),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$13C0),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$1500),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$1640),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$1780),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$18C0),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$1A00),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$1B40),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$1C80),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$1DC0),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$2000),$e 
	dta $41,a(:2)
.ENDM

