//-------------------------------
// Snakes of Atari Island
//
// Author: Jakub "JKR" Krzak
// Katowice, April 2012
//-------------------------------


_scr equ $7000
_scrL12 equ _scr + 12*40
_scrL20 equ _scr + 20*40
_scrL24 equ _scr + 24*40
_scrL25 equ _scr + 25*40 ; first line after the screen memory
						 ; first byte of this line must be 0

DList:
;$70
   dta b(112)
;$70 + $80
   dta b(240)
;$42, _scr	
   dta b(66)
   dta a(_scr)
;$10 + $80
   dta b(144)
;$10
   dta b(16)
;23 times ($02 + $80)
   :23 dta b(130)
;$10 + $80
   dta b(144)
DLScrllLine:
;$02 ;+ $10 ; optionally with scroll
   dta b(2)
;$41, DList
   dta b(65)
   dta a(DList)
   
   
DList2:
;$70
   dta b(112)
;$70 + $80
   dta b(240)
;$42, _scr			;0
   dta b(66)
   dta a(_scr)
;$10 + $80
   dta b(144)
;$10
   dta b(16)
;10 times ($02 + $80);1..10
   :10 dta b(130)
;$10					;11
   dta b(16)
;$10 + $80
   dta b(144)
;$10 
   dta b(16)
;$10
   dta b(16)
;$42 + $80, _scrL12 ;12
   dta b(194)
   dta a(_scrL12)
;6 times ($02 + $80) ;13..18
   :6 dta b(130)
;$10	+ $80			;19
   dta b(144)
;$10 
   dta b(16)
;$10 
   dta b(16)
;$10 
   dta b(16)
;$42 + $80, _scrL20 ;20
   dta b(194)
   dta a(_scrL20)
;3 times ($02 + $80) ;21..23
   :3 dta b(130)
;$10 + $80
   dta b(144)

DLScrllLine2:
;$02 ;+ $10 ; optionally with scroll	; 24
   dta b(2)
;$41, DList2
   dta b(65)
   dta a(DList2)


;Color schemes
    .array ColorSchemes .byte
    $B0, $42, $62, $F0
    $A0, $42, $62, $F0
    $40, $B2, $62, $F0
    $30, $B2, $62, $F0
    $D0, $42, $62, $F0
    $00, $42, $62, $F0
    .enda
    
    
.array FHighlight[25] .byte = 0
.enda

.array FHighlightEx[25] .byte = 0
.enda
	 
;-------------------------------------------------------------------------
    
DLI_Proc1 .proc
	pha
	txa
	pha

	ldx vcnt

	cpx #0
	 jne l2
	mva _msgBrUpper COL_PF1

l2
	sta WSYNC
	
	cpx #1
	 jne l0
	mva _bgrndClr COL_BK

l0
	lda FHighlight,x
	sta PM_PATRN
	lda FHighlightEx,x
	sta PM_PATRN+1
	
	cpx #24
	 jne l1
	mva _msgBrLower COL_PF1
	sta WSYNC
	mva COL_BK_S COL_BK
	mva COL_PF2_S COL_PF2
	jmp ex

l1
	cpx #1
	 jne ex
	mva _bgrndClr COL_PF2
    mva COL_PF1_S COL_PF1

ex	   
	inc vcnt
	pla
	tax
	pla
	rti
.endp

;-------------------------------------------------------------------------
    
DLI_Proc1A .proc
	pha
	txa
	pha

	ldx vcnt

	cpx #0
	 jne l0
	mva _msgBrUpper COL_PF1

l0
	sta WSYNC

	lda FHighlight,x
	sta PM_PATRN
	lda FHighlightEx,x
	sta PM_PATRN+1
	
	cpx #24
	 jne l1
	mva _msgBrLower COL_PF1
	sta WSYNC
	mva COL_PF2_S COL_PF2
	jmp ex

l1
	cpx #0
	 jne l2
	mva _msgBrUpper COL_PF1
	jmp ex
	
l2
	cpx #1
	 jne ex
	mva _bgrndClr COL_PF2
    mva COL_PF1_S COL_PF1

ex	   
	inc vcnt
	pla
	tax
	pla
	rti
.endp


;-------------------------------------------------------------------------

DLI_Proc2 .proc
   pha
   lda vcnt

   cmp #7
   jne l1
   mva #255 PM_PATRN
   mva #255 PM_PATRN+1
   mva #255 PM_PATRN+2
   jmp ex
   
l1
   cmp #17
   jne l2
   mva #0 PM_PATRN
   mva #0 PM_PATRN+1
   mva #0 PM_PATRN+2
   jmp ex
   
l2
   lda vcnt
   cmp #1
   jne l3
   sta WSYNC
   mva _bgrndClr COL_BK
   mva _bgrndClr COL_PF2
   mva COL_PF1_S COL_PF1
   jmp ex
   
l3
   cmp #0
   jne l4
   mva _msgBrUpper COL_PF1
   jmp ex
   
l4
   cmp #24
   jne ex
   mva _msgBrLower COL_PF1
   sta WSYNC
   mva COL_BK_S COL_BK
   mva COL_PF2_S COL_PF2

ex
   inc vcnt
   pla
   rti
.endp

;-------------------------------------------------------------------------

DLI_Proc2A .proc
   pha
   lda vcnt
   
   cmp #12
   jne l1
   sta WSYNC
   mva #255 PM_PATRN
   mva #255 PM_PATRN+1
   jmp ex
   
l1
   cmp #20
   jne l2
   sta WSYNC
   mva #0 PM_PATRN
   mva #0 PM_PATRN+1
   jmp ex
   
l2
   cmp #1
   jne l3
   sta WSYNC
   mva _bgrndClr COL_BK
   mva _bgrndClr COL_PF2
   jmp ex
   
l3
   cmp #0
   jne l4
   mva _msgBrUpper COL_PF1
   jmp ex
   
l4
   cmp #24
   jne ex
   mva _msgBrLower COL_PF1
   sta WSYNC
   mva COL_BK_S COL_BK
   mva COL_PF2_S COL_PF2

ex   
   inc vcnt
   pla
   rti
.endp


;-------------------------------------------------------------------------
ClearScr .proc
	fillMemory _scr (_scr + 40*24) 0 
	rts
.endp
