;                       /|
;                      //|.
;                     //_| .
;                 __ // /| .
;                /_ \/\__|. 
;                \\_/  _/|_
;                .g.e.n.d.a.
;
;                    &
;
;                 ___      _  _
;          /   /\  |  /\  | >
;           \ /__\ | <  > | \ |
;          /       |  \/      |
;                sato.di gi             
;                 ri   tal
;______________________________________________________
;
; aatori (256b intro for SV2019)
; small 4.5-fx glitchy trancey co-op with Satori :)
; zden & svoy
; tomaswoj@gmail.com
; http://pl.linkedin.com/in/tomaswoj
; Cracow
; some stable undocumented opcodes used here (lax, alr)
; https://xxl.atari.pl/sally-6502c/
; kudos to my fellow Agenda coders - Koala for some optimization tips, and Gorgh for tests on real HW!

FRMCNT	equ $80 ; on ZP
SECTION	equ $82 ; which note we are currently in (cap at 16, 0-15)
FRMBIT	equ $84 ; flipflop flag
BACKCOL	equ $85 ; flashing background

RASTPOS	equ $90 ; rasters positions
PMGPOS	equ $90 ; PMG placeholder
RASTCOL equ $a0 ; rasters colors
RASTSIZ equ $b0 ; rasters sizes
;FLIPFLO	equ $d0 ; %10101010 pattern for randomization
; rasters data to be rendered
RASTAB	equ $3000 ; 

WSYNC	equ $D40a
; original/initial DLIst $BC20
; hires DLI is $8f

;MYBASE	equ $6000 ; 2K boundary
MYBASE	equ $6000 ; 1K boundary

AUDF1	equ $D200
AUDC1	equ $D201
AUDF2	equ $D202
AUDC2	equ $D203
AUDF3	equ $D204
AUDC3	equ $D205
AUDF4	equ $D206
AUDC4	equ $D207
AUDCTL 	equ $D208 ;
SKCTL	equ $D20f;
VCOUNT	equ $D40B

PMGC1	equ $D012
PCOL1	equ $D017;
PCOL2	equ $D018;
COLBAK	equ $D01A
GPRIOR	equ $D01B


	opt h+
		
	org $2000

;----------------------------------------
; PMG data for pictures/icons
pics:
;pic1	dta b($18,$18,$18,$FF,$FF,$18,$18,$18); plus
;pic2	dta b($C3,$81,$81,$BD,$BD,$81,$81,$C3); 
;pic3	dta b($FF,$C3,$18,$DB,$DB,$18,$C3,$FF);

; by zden
pic1	dta b($7E,$0,$18,$2C,$2C,$34,$34,$18); // division by zero - by zden
pic2 	dta b($0,$80,$96,$A9,$A9,$16,$80,$0); //not infinity
pic3	dta b($7F,$40,$41,$C3,$59,$41,$41,$41); //negative root - updated
pic4	dta b($1,$3A,$64,$4A,$52,$26,$5C,$80); empty set - original by zden
 
; format:
; each byte is one line, each bit in byte is a single pixel (0 or 1) 

;----------------------------------------
;----------------------------------------		
fx01: //moving screen content (text mode) and show PMG (if present)
	; wait for first line
	;lax VCOUNT ; to be used as 0 in x below, to clean background ;3b
	;bne fx01 ; 2b
	lda #$0f ;2b;	
	sta PCOL2 ;3b		; pot 5b
	lda #$a0	; 2b			
 	sta $9c25 ; 3b
 	lda $D20a ; randomize ;3b	 
 	sta $9c24 ; 3b
	;inc $9c24 ; instead of randomizing ; pot 3b	
	rts ; $60

;----------------------------------------
;----------------------------------------	
fx02: //static PMG and random background
;	lax VCOUNT ; to be used as 0 in x below, to clean background ;3b
;	bne fx02 ; 2b
	lda #$50	; 2b	
 	sta $9c25 ; 3b	
	;ldy #255 ; 2b
fx02loop
	lda $D20a ; 3b
	and #$3f
	ora SECTION
	;asl
	sta WSYNC ; 3b
	sta PCOL2 ; 3b
	dex ;1
	bne fx02loop ;2b	
	rts
;----------------------------------------
;----------------------------------------	
fx04: // moving PMG and moving background
;	lax VCOUNT ; to be used as 0 in x below, to clean background ;3b
;	bne fx04 ; 2b
 
	;dec $9c24 ; instead of randomizing ; pot 3b
;	lda FRMCNT ; 2b
	lax FRMCNT
	;tay
	and #%00011111 ; 2b
	adc #98 ; 2b
	sta $D000 ;3b
; now loop with background through the $b0/$c0 universe
	;ldy FRMCNT ; 2b
	;ldy #255 ; 2b
	; use X=0 from lax above
fx04loop:
	;lda $c000,y ; 3b
	lda $c000,x ; 3b
	and #%10101111 ; pot 2b	
	sta WSYNC ; 3b
	sta PCOL2 ; 3b
	;eor FRMCNT
	;iny ; 1b
	;dex ; 1b
	inx
	dey
	bne fx04loop ;2b	
	rts

;----------------------------------------
;----------------------------------------
fx03: // supercolorful PMG
;	lax VCOUNT ; to be used as 0 in x below, to clean background ;3b
;	bne fx03 ; 2b
	lda #%000010 ; double line, no missle DMA; 2b
	sta $D400; DMACTL - 62 - single line, normal playfield ; 3b
	;lda #$3
;	inx	
;	stx $D008 ; 3b
	ora FRMCNT ; 2b
	sta $D00D ; GRAFP0 ; 3b -> move it down, then 2b pot
	;ldx #0 ; from VCOUNT
fx03loop:	
	txa ;1b
	;ora FRMCNT ; 3b
	eor FRMCNT ; 3b - even better!	 
	sta WSYNC ; 3b
	sta $D000 ; 3b PMG pos
	sta $D012; PMG color
	dex ;1
	bne fx03loop ;2	
	rts

main:	
		
 	ldy #$60 ; PMBASE	
	sty $D407; PMBASE

	lda #(2+1)
initpmg:
	sta $D008,y
	dey
	bne initpmg	
	sta SKCTL ; sound init
	;sta $D01D ; GRACTL -set both players and missles
	;sta GPRIOR
	;sta $D008 ; PMG size

 	 	
frame:		
		lax VCOUNT ; X=0 used in several effects reached by jsr
		bne frame ; wait for new frame
fx_run:
		jsr $2000+<fx01 ; jump to fx subroutine (one of fx01-fx04 above)		
; play sound:			
		lax FRMCNT
		ora #$c2 ; distortion 12b, clean tones?, $c2 is nice!
		;ora #$a2 ; distortion 12b, clean tones? also nice, but calmer
		sta AUDC4 ; joined channels 3+4, so push to 4th		
		ora #%10101000 ; good, interesting, less background, more foreward, base - also nice! (as a lead?)
		;ora #%10101010 ; good, interesting, less background, more foreward, base - also nice! (as a lead?)
		;and #%11101101 ; good, interesting, more light/buzzy background
		;eor #%10101001 ; good, interesting, less background, more foreward, base - also nice! (as a lead?)
		sta AUDC3
audiomod:		
		lda #$7a
		sta AUDF3
		sta AUDF1
		txa ; FRMCNT from X to A
		;lsr
		;and #%10101111 ; %10101111 is nice! ; consider alr - 1b
		alr #%01011110		
		ora SECTION
		;and SECTION
		sta AUDC1
 		
		; now blink the background
		txa
		;and #%00011110
		;lsr
		alr #%00011110 		
		sta $D01a
		sta PCOL1		
		
		; go back to PMG
		lda #%101110 ; double line, no missle DMA
		sta $D400; DMACTL - 62 - single line, normal playfield

		; now copy the logo
		; copy logo to pmg1
		ldy #(4*8-1)	
fx1logocpy:
		;lda agpmg,y
		tya
		lsr
		lsr
		tax
picloadoffset:			
		;lda $2000+<pic4,x ; this will be modified by code below
		lda $20ff,x ; this will be modified by code below, but nice empty first run :P
		sta mybase+512+14+34,y
		dey
		bne fx1logocpy
		; set PMG color to 0, using y=0
		; sty $D012 ; yay. not needed :P
		
		lda #112
		sta $D000		
						
		; now play with fx selection
		dec FRMCNT 					
		bne skipsectionswap		
		inc SECTION
		;inc audiomod+1
		lda section
		and #%00000111 ; use it for fx selection
		tay
		and #%00000011 ; use it for icon selection				
		asl
		asl
		asl
		;adc #<pics ; not needed if we start from pictures 
		sta picloadoffset+1 
		lda fxorder,y
		;and #%01100000
		sta fx_run+1		
		; now randomize picture		
		;lda picindex,x ; offsets of 4 pictures below
		;sta picloadoffset+1
skipsectionswap:		
		bcc frame
fxorder	dta b(<fx03,<fx01,<fx02,<fx03,<fx04,<fx01,<fx04,<fx02);
				
		run main

				
		    	


  	
					