; SINE WARS
; By Pigu
; Atari XL 256-byte intro for SV2019
; Assemble with `64tass -C -a -B --atari-xex`

rHPOSP0 = $d000 ; player hpos
rHPOSP1 = $d001
rCOLPM0 = $d012 ; player+missile colors
rCOLPM1 = $d013
rCOLBK  = $d01a ; background color
rPRIOR  = $d01b ; player-playfield priority
rVDELAY = $d01c ; vertical delay
rGRACTL = $d01d ; graphic control
rCONSOL = $d01f ; console switch port
rRANDOM = $d20a ; rng
rDMACTL = $d400 ; DMA control
rCHACTL = $d401 ; character control
rDLISTL = $d402 ; display list address
rDLISTH = $d403
rWSYNC  = $d40a ; wait for hblank
rVCOUNT = $d40b ; vertical line counter

VVBLKD = $224
SETVBV = $e45c
XITVBV = $e462

lines = 240
dlist = $2019

*	= $02e0
	.word start
	
*	= dlist+lines*3
start
	lda #6 ; set VVBLKI
	ldx #>vbi
	ldy #<vbi
	jsr SETVBV
	
	; fill display list with the same line
	ldx #lines
-	
	ldy #3
-
	lda modeline-1,y
	dex ; addr hi
	sta dlist,x
	sta dlist+lines,x
	sta dlist+lines*2,x
	dey
	bne -
	cpx #0
	bne --
	
	txa
	sta dlist+lines*3-3 ; prevent hires line 247 bug
	sta rVDELAY
	sta rCHACTL
	lda #%01101000 ; gr.9, all players above pf
	sta rPRIOR
	lda #%00000011 ; turn on player DMA on GTIA only for "random" player grapics
	sta rGRACTL
	lda #%00110011
	sta rDMACTL
	
	.page
loop
	sta rWSYNC
	lda sintab,x
	adc sintab,y
	sta rCONSOL ; make a sound on beeper
	tay
	adc #32
	sta rHPOSP0
	eor #$ff
	sta rHPOSP1
	lda rRANDOM
	ora ddata,y
	sta ddata,y
	lda #0
pos	= *-1
	adc #1
	and #31
	sta pos
	tax
	lda #0
posf = *-1
	adc #0
wave = *-1
	sta posf
	lda #0
pos2 = *-1
	adc #0
	and #31
	sta pos2
	tay
	asl a ; only write darkest luma to background
	asl a
	asl a
	asl a
	sta rCOLBK
	jmp loop
	.endp
	
vbi
	lda #<dlist ; reset dlist
	sta rDLISTL
	lda #>dlist
	sta rDLISTH
	
	; update wave phase
	lda #0
wavef = *-1
	clc
	adc #9
	sta wavef
	lda #0
curwave = *-1
	adc #0
	and #7
	sta curwave
	tax
	lda waves,x
	sta wave
	
	; update player colors
	lda #0
pcolf = *-1
	clc
	adc #9*16
	sta pcolf
	lda #0
pcol = *-1
	adc #0
	sta pcol
	sta rCOLPM0
	sta rCOLPM1
	
	; clear display data
	lda #0
	ldx #48
-
	dex
	sta ddata,x
	bne -
-	
	cmp rVCOUNT
	bne -
	jmp XITVBV
	
modeline
	.byte $4f, <ddata, >ddata
	
waves
	.byte $1, $41, $81, $c1, $ff, $3f, $7f, $bf
	
sintab
_x := 0
	.rept 33 ; one extra entry so the executable is nicely 256 bytes long
	.byte sin(rad(_x*360.0/32.0))*11+11
_x := _x + 1
	.next
	.fill 16

	.align $100
ddata	.fill 48
