;compile with sjasmplus
	device zxspectrum128
        ORG #6000
begin
spo equ $B000 ; sine tab position
ct equ spo+256 ; calc table
adt equ ct+256 ; 512bytes for screen char pos

	di:ld sp,$5FFF
	;debug grid
;	ld hl,$5800,de,$5803,bc,765:set 6,(hl):ldir
	ld a,r,(R1),a
	;copy sin
	ld hl,st,de,spo,bc,256:ldir

; fill 2nd screen
	ld a,$17,bc,$7ffd:out (c),a
	ld hl,$4000,de,$4001,bc,6143,(hl),l:ldir
	ld hl,$5800,de,$5801,bc,767,(hl),$9:ldir
	ld hl,$4000,de,$C000,bc,6912:ldir
	

; build screen address
	ld hl,adt
	ld de,$C000
bslp:
	ld b,8
bs1:
	ld (hl),e
	inc h
	ld (hl),d
	dec h
	inc l
	djnz bs1
	ld a,e
	add a,32
	ld e,a
	sbc a,a
	and 8
	add a,d
	ld d,a
	cp $D8
	jr nz,bslp

; prepare stack routine
	ld hl,ou
	ld bc,384
stl: ld (hl),$D5:inc hl ; push de
	dec bc
	ld a,b:or c
	jr nz,stl
	ld (hl),$31:inc hl ; ld sp,NNNN
	ld (ous+2),hl
	inc hl,hl
	ld (hl),$C9
; test plot

;	ld ix,ct
;testp:
;	ld b,(ix+0)
;	ld c,ixl
;;	; Get screen address
;;	; B = Y pixel position
;;	; C = X pixel position
;;	; Returns address in HL
;Get_Pixel_Address:  LD A,B          ; Calculate Y2,Y1,Y0
;	                    AND %00000111   ; Mask out unwanted bits
;	                    OR %01000000    ; Set base address of screen
;	                    LD H,A          ; Store in H
;	                    LD A,B          ; Calculate Y7,Y6
;	                    RRA             ; Shift to position
;	                    RRA
;	                    RRA
;	                    AND %00011000   ; Mask out unwanted bits
;	                    OR H            ; OR with Y2,Y1,Y0
;	                    LD H,A          ; Store in H
;	                    LD A,B          ; Calculate Y5,Y4,Y3
;	                    RLA             ; Shift to position
;	                    RLA
;	                    AND %11100000   ; Mask out unwanted bits
;	                    LD L,A          ; Store in L
;	                    LD A,C          ; Calculate X4,X3,X2,X1,X0
;	                    RRA             ; Shift into position
;	                    RRA
;	                    RRA
;	                    AND %00011111   ; Mask out unwanted bits
;	                    OR L            ; OR with Y5,Y4,Y3
;	ld l,a
;;bit weight
;	ld a,c
;	and 7
;	ld b,a
;	ld a,128
;	jr z,exrol
;ro: rrca
;	djnz ro
;exrol:
;	or (hl)
;	ld (hl),a
;	inc ixl
;	jp nz,testp

; setup interrupt
	di
	ld hl,$BE00,de,$BE01,bc,256,(hl),$BF:ldir
	ld a,$BE,i,a
	im 2
	ld a,$C3,($BFBF),a
	ld hl,INTVEC,($BFC0),hl
introl:
	ei:halt
pg: ld a,$17,bc,$7FFD:out (c),a
	xor $0A:ld (pg+1),a

	call empty
	call ous

	;calc data,fill table

	ld hl,spo
	ld bc,ct
v1: ld de,0
	ld a,e
v2:	add a,-2
	ld e,a
	ld a,d
v3: add a,5
	ld d,a
	ld (v1+1),de
cdlp: ld l,e
	ld a,(hl)
	ld l,d
	add a,(hl)
; mirror
	sub 191
	neg
	ld (bc),a
	ld a,e
v4:	add a,2 ;only -3..3
	ld e,a
	ld a,d
v5: add a,3
	ld d,a
	inc c
	jr nz,cdlp

;draw graph
	ld ix,ct
	ld bc,$8000
tdr1:
	ld l,(ix+0)
	ld h,adt/256
	ld a,(hl)
	inc h
	ld h,(hl)
	or c
	ld l,a
	ld a,(ix+0)
;	cpl
	and 7
	or h
	ld h,a
	ld a,(hl)
	or b
	ld (hl),a
;convert to attr
	ld a,h:and %00111000
	rra:rra:rra
	or %11011000
	ld h,a
cv1:	ld (hl),#0E ; 8+6 paper,ink
	rrc b
	jr nc,nonxtx
	inc c
nonxtx
	inc ixl
	jr nz,tdr1
;	jr $
	
;fill screen

	ld hl,$D800
ro4: ld c,0
ro3: push hl
ro2: ld de,32

ro1:
	ld a,h
	cp $DB
	jp z,nxtr
	ld a,(hl)
cv2:	cp $0E:jr z,exfill ; 8+6,p/i
cv3:	ld (hl),8
ro5: add hl,de
	ld a,h
	cp $DB
	jp z,nxtr
	jr ro1
exfill:
;$40=10 000 000
;$58=10 110 000
;$48=10 010 000
;$59=10 110 010
;$50=10 100 000
;$5A=10 110 100

	push hl
	ld a,h
	and 7
	add a,a
	add a,a
	add a,a
	add a,$C0
	ld h,a
	ld a,c
	xor (hl):ld (hl),a:inc h
	xor (hl):ld (hl),a:inc h
	xor (hl):ld (hl),a:inc h
	xor (hl):ld (hl),a:inc h
	xor (hl):ld (hl),a:inc h
	xor (hl):ld (hl),a:inc h
	xor (hl):ld (hl),a:inc h
	xor (hl):ld (hl),a
;	jr $
	ld c,a
	pop hl
	add hl,de
	ld a,(hl)
cv6:	cp $36:jp nz,ro1
nxtr:
	pop hl
	inc l
	ld a,l
	and 31
	jp nz,ro4
;counter
dlay equ $100
co: ld hl,dlay
	dec hl
	ld a,h:or l:jp nz,nopar
	call random
	and 3
	ld e,a,d,0,hl,delta
	add hl,de
	ld a,(hl),(v4+1),a
	ld a,e
	add a,2
	and 3
	ld e,a
	ld hl,delta
	add hl,de
	ld a,(hl),(v5+1),a

	call random
	and $0F:jr z,contpar
	bit 3,a:jr z,noinv1
	xor $F0
noinv1:
	ld (v2+1),a
	and 3
	jr nz,nozero
	inc a
nozero:
	ld (v3+1),a
contpar:
;    ld hl,$5AFF,de,$5AFe,bc,$1B00-1,(hl),0:lddr
	ld a,($5800)
	and %00111000
	ld l,a
	srl a
	srl a
	srl a
	or l
	ld hl,$5800,de,$5801,bc,767,(hl),a:ldir
	ld hl,$4000,de,$4001,bc,6143,(hl),l:ldir
    ld a,$17,bc,$7FFD
    ei:halt
    out (c),a
    ld (pg+1),a
    ;ld hl,$DAFF,de,$DAFe,bc,$1B00-1,(hl),0:lddr
	ld hl,$C000,de,$C001,bc,6143,(hl),l:ldir

cco: ld a,0 ; color counter
	inc a
	ld (cco+1),a
	and 3
	ld l,a,e,a
	ld h,0,d,h
	add hl,hl
	add hl,de
	ld de,coltab
	add hl,de
	ld a,(hl):inc hl
	ld (cv1+1),a
	ld (cv2+1),a
	ld (cv4+1),a
	ld a,(hl):inc hl
	ld (cv3+1),a
	ld a,(hl):inc hl
	ld (cv6+1),a
	ld (cv5+1),a
	ld (cv5+2),a

	ld hl,dlay
nopar:
	ld (co+1),hl
	jp introl
delta db -2,-1,1,2
random  PUSH BC:LD A,(R1),C,A
        LD A,(R2):ADD A,C:LD C,A
        LD (R1),A,A,(R3)
        SUB C:LD C,A,(R2),A
        RRCA:LD (R3),A
        LD A,C:POP BC
        RET

R1      DB #15
R2      DB #70
R3      DB #FD 

coltab
 db $0E ; cv1,cv2,cv4 1*8+6
 db 8 ; cv3 1*8
 db $36; cv6,cv5 6*9

 db 8+5
 db 8
 db 5*9

 db 2*8+7
 db 2*8
 db 7*9

 db 4
 db 0
 db 4*9

empty:
	ld de,$D800
	ld hl,#C000
e1:
	ld a,(de)
cv4:	cp $0E:jp nz,enxt
	ld c,h
	xor a
	ld (hl),a:inc h
	ld (hl),a:inc h
	ld (hl),a:inc h
	ld (hl),a:inc h
	ld (hl),a:inc h
	ld (hl),a:inc h
	ld (hl),a:inc h
	ld (hl),a
	ld h,c
enxt:
	inc de
	inc l
	jr nz,noh8
	ld a,h:add a,8:ld h,a
noh8:
	ld a,d
	cp $DB
	jp nz,e1
	ret
INTVEC  PUSH AF,BC,DE,HL,IX
        EXX:PUSH AF,BC,DE,HL
        EXA:PUSH AF
        call psgplay
        POP AF:EXA
        POP HL,DE,BC,AF:EXX
        POP IX,HL,DE,BC,AF
        EI:RETI

;---------------play PSG dump-----------
psgplay:ld a,1:or a:jr z,psga
 dec a:ld (psgplay+1),a:ret
psga: ld hl,song+16

dumpreg:
 	ld e,(hl):inc hl
 	ld a,e
 	cp #FF:jr z,stoplay
 	cp #FE:jr nz,nogetwait
    ld e,(hl):inc hl;(hl)*4
 ld a,e
 add a,a
 add a,a
 ld (psgplay+1),a:jr stoplay

nogetwait:
    cp #FD:jr z,stoplay2
	ld bc,0xfffd
	out (c),e
	ld e,(hl):inc hl

  
	ld b,0xbf
	out (c),e
    jr dumpreg
stoplay2:
  ld hl,song+16
stoplay:
 ld (psga+1),hl
 ret

song: incbin "redref_tune.psg"
 db $FD
ous: ld (0),sp
cv5: ld de,$3636
	ld sp,$DB00
ou:
st: incbin "wavysin.data"
end
	display /d,end-begin
	savesna "wavy.sna",begin
	savebin "wavy.code", begin,end-begin

