/*
 * keyb_de.h - a keyboard layout definition
 *
 * Copyright (c) 2001 The EmuTOS development team
 *
 * Authors:
 *  LVL   Laurent Vogel
 *
 * This file is distributed under the GPL, version 2 or at your
 * option any later version.  See doc/license.txt for details.
 */

static const UBYTE keytbl_de_norm[] = {
    0x00, 0x1b,  '1',  '2',  '3',  '4',  '5',  '6',
     '7',  '8',  '9',  '0', 0x9e, '\'', 0x08, 0x09,
     'q',  'w',  'e',  'r',  't',  'z',  'u',  'i',
     'o',  'p', 0x81,  '+', 0x0d, 0x00,  'a',  's',
     'd',  'f',  'g',  'h',  'j',  'k',  'l', 0x94,
    0x84,  '#', 0x00,  '~',  'y',  'x',  'c',  'v',
     'b',  'n',  'm',  ',',  '.',  '-', 0x00, 0x00,
    0x00,  ' ', 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00,  '-', 0x00, 0x00, 0x00, '+',  0x00,
    0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     '<', 0x00, 0x00,  '(',  ')',  '/',  '*',  '7',
     '8',  '9',  '4',  '5',  '6',  '1',  '2',  '3',
     '0',  '.', 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static const UBYTE keytbl_de_shft[] = {
    0x00, 0x1b,  '!', '\"', 0xdd,  '$',  '%',  '&',
     '/',  '(',  ')',  '=',  '?',  '`', 0x08, 0x09,
     'Q',  'W',  'E',  'R',  'T',  'Z',  'U',  'I',
     'O',  'P', 0x9a,  '*', 0x0d, 0x00,  'A',  'S',
     'D',  'F',  'G',  'H',  'J',  'K',  'L', 0x99,
    0x8e,  '^', 0x00,  '>',  'Y',  'X',  'C',  'V',
     'B',  'N',  'M',  ';',  ':',  '_', 0x00, 0x00,
    0x00,  ' ', 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  '7',
     '8', 0x00,  '-',  '4', 0x00,  '6',  '+', 0x00,
     '2', 0x00,  '0', 0x7f, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     '>', 0x00, 0x00,  '(',  ')',  '/',  '*',  '7',
     '8',  '9',  '4',  '5',  '6',  '1',  '2',  '3',
     '0',  '.', 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static const UBYTE keytbl_de_caps[] = {
    0x00, 0x1b,  '1',  '2',  '3',  '4',  '5',  '6',
     '7',  '8',  '9',  '0', 0x9e, '\'', 0x08, 0x09,
     'Q',  'W',  'E',  'R',  'T',  'Z',  'U',  'I',
     'O',  'P', 0x9a, '+',  0x0d, 0x00,  'A',  'S',
     'D',  'F',  'G',  'H',  'J',  'K',  'L', 0x99,
    0x8e,  '#', 0x00,  '<',  'Y',  'X',  'C',  'V',
     'B',  'N',  'M',  ',',  '.',  '-', 0x00, 0x00,
    0x00,  ' ', 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00,  '-', 0x00, 0x00, 0x00,  '+', 0x00,
    0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     '<', 0x00, 0x00,  '(',  ')',  '/',  '*',  '7',
     '8',  '9',  '4',  '5',  '6',  '1',  '2',  '3',
     '0',  '.', 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};


/* the tables below were not checked
 * (they come out of Minix 1.5 source code)
 */

static const UBYTE keytbl_de_altnorm[] = {
    0x1a, '@',
    0x27, '[',
    0x28, ']',
    0,
};

static const UBYTE keytbl_de_altshft[] = {
    0x1a, '\\',
    0x27, '{',
    0x28, '}',
    0,
};

static const UBYTE keytbl_de_altcaps[] = {
    0x1a, '@',
    0x27, '[',
    0x28, ']',
    0,
};

static const struct keytbl keytbl_de = {
    keytbl_de_norm,
    keytbl_de_shft,
    keytbl_de_caps,
    keytbl_de_altnorm,
    keytbl_de_altshft,
    keytbl_de_altcaps,
    NULL
};
