;;
;; ATARIMAX common definitions and macros
;;
;; Version 1.0.0 11/30/2004 Matthias Reichl
;; Version 1.0.1 12/15/2004 Matthias Reichl
;;
;; Updates and information at http://www.atarimax.com/
;; email: classics@atarimax.com, backup: atari@yahoo.com
;; Copyright (C) 2003 Steven J Tucker
;; 
;; ATasm/Linux version (c) 2004 by Matthias Reichl <hias@horus.com>
;;
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.
;; 
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;; 
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;;


	.macro saveregs
	pha
	txa
	pha
	tya
	pha
	.endm

	.macro restregs
	pla
	tay
	pla
	tax
	pla
	.endm

	.macro split_xY	; address
	.if %0 <> 1 
	.error "split_xY requires 1 parameter"
	.else
	ldx #<[%1]
	ldy #>[%1]
	.endif
	.endm

	.macro split_aY ; address
	.if %0 <> 1 
	.error "split_aY requires 1 parameter"
	.else
	lda #<[%1]
	ldy #>[%1]
	.endif
	.endm

	.macro doprintc ; var, len
	.if %0 <> 2
	.error "doprintc requires 2 parameters"
	.else
	lda #[%2]
	sta ebytes
	split_aY [%1]
	jsr cprint
	.endif
	.endm

	.macro doprints ; var
	.if %0 <> 1
	.error "doprints requires 1 parameter"
	.else
	split_aY [%1]
	jsr print
	.endif
	.endm

	.macro gotoXY ; x,y
	.if %0 <> 2
	.error "gotoXY requires 2 parameters"
	.else
	ldx #[%1]
	ldy #[%2]
	jsr setxy
	.endif
	.endm

	.macro printxy ; x,y,var
	.if %0 <> 3
	.error "printxy requires 3 parameters"
	.else
	ldx #[%1]
	ldy #[%2]
	jsr setxy
	doprints [%3]
	.endm

	.macro bitprefix
	.byte $2c
	.endm

dosvec			=	$a
irqen_shadow		=	$10	
critic			=	$42

dliptr			=	$200	
sdlstl			=	$230	

dmactl_shadow		=	$22f	

colbase			=	$2c0	
colpf1_shadow		=	$2c5	
colpf2_shadow		=	$2c6	

runad			=	$2E0	
initad			=	$2E2	

chact			=	$2f3	
chbase_shadow		=	$2f4	
ch			=	$2fc	

devid			=	$23A
sec_lo			=	$23C
sec_hi			=	$23D
ddevic			=	$0300
dunit			=	$0301
dcomnd			=	$0302
dstats			=	$0303
dbuflo			=	$0304
dbufhi			=	$0305
daux1			=	$030A
daux2			=	$030B

gintlk			=	$03fa

carbase 		=	$A000	
carend			=	$BFFF	

trig0			=	$D010	
trig1			=	$D011	
trig3			=	$D013	
colpf0			=	$d016	
colpf1			=	$d017	
colpf2			=	$d018	
colpf3			=	$d019	
clrreg			=	$D01A	
console			=	$D01F	

serout			=	$D20D   
audc3			=	$D205   
audc4			=	$D207   
audctl			=	$D208   
kbcode			=	$D209
irqen			=	$D20E	
skctl			=	$D20F   

porta			=	$D300	
portb   		=	$D301   
pactl			=	$D302   
pbctl			=	$D303   

dmactl			=	$d400	
chactl			=	$d401	
anticdl			=	$d402	
chbase			=	$d409	
wsync   		=	$D40A   
nmien   		=	$D40E   

ciov			=	$E456
siov			=	$E459
warmst			=	$E474	
coldst			=	$E477	

.if .def 1MB
ldbank			=	$D500	
cartoff 		=	$D510	
.endif

.if .def 4MB
ldbank			=	$D500	
cartoff 		=	$D540	
.endif

.if .def 8MB
ldbank			=	$D500	
cartoff 		=	$D580	
.endif

.if .def FREEZER
.if .def FRZBANK
ldbank			=	[$D540+FRZBANK]
.else
ldbank			=	$D540
.endif
carton			=	$D581
cartoff			=	$D580
.endif

.if .def OSB
osb_mathpack		=	$D800	
osb_os_base		=	$E000 	
osb_bank		=	ldbank+1
.endif

