----------------------------------------------------------------------------------
--  FreezerDef.vhd - Turbo Freezer 2011 common types and definitions
--
--  Copyright (C) 2011-2012 Matthias Reichl <hias@horus.com>
--
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 2 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--
--  You should have received a copy of the GNU General Public License
--  along with this program; if not, write to the Free Software
--  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.all;

package FreezerDef is

	subtype vec8 is std_logic_vector(7 downto 0);
	subtype vec16 is std_logic_vector(15 downto 0);
	subtype vec20 is std_logic_vector(19 downto 0);

	type mem_output is
	record
		adr: vec20;
		ram_access: boolean;
		rom_access: boolean;
		disable_atari: boolean;
		dout: vec8;
		dout_enable: boolean;
	end record;
	
	function "or"(a: mem_output; b: mem_output) return mem_output;
	
	-- ROM layout, in 8k banks
	-- first ROM:
	-- free for cartemu
	
	-- second ROM:
	-- 448k free for cartemu
	-- 64k reserved for Freezer (bankno 120-127)
	constant freezer_def_rom_bank:	std_logic_vector(19 downto 13)	:= "1111100";
	constant cartemu_menu_bank:	std_logic_vector(19 downto 13)	:= "1111110";
	constant oldos_rom_bank:	std_logic_vector(19 downto 13)	:= "1111111";
	
	-- RAM layout, in 8k banks
	-- first RAM:
	-- 384k free for cartemu (bankno 0-47)
	-- last 16k of first RAM strictly reserved for freezer
	constant freezer_reserved_ram:	std_logic_vector(19 downto 14)	:= "011111";
	-- freezer has 4k RAM banks, last one is default (for shadowing etc)
	constant freezer_def_ram_bank:	std_logic_vector(19 downto 12)	:= "01111111";

	-- second RAM:
	-- used for ramdisk
	constant ramdisk_base_bank:	std_logic_vector(19 downto 19)	:= "1";
end FreezerDef;


package body FreezerDef is

function "or"(a: mem_output; b: mem_output) return mem_output is
variable r: mem_output;
begin
	r.adr := a.adr or b.adr;
	r.ram_access := a.ram_access or b.ram_access;
	r.rom_access := a.rom_access or b.rom_access;
	r.disable_atari := a.disable_atari or b.disable_atari;
	r.dout := a.dout or b.dout;
	r.dout_enable := a.dout_enable or b.dout_enable;
	return r;
end "or";

end FreezerDef;
