----------------------------------------------------------------------------------
--  OldOs.vhd - Old OS ("oldrunner") logic
--
--  Copyright (C) 2011-2012 Matthias Reichl <hias@horus.com>
--
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 2 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--
--  You should have received a copy of the GNU General Public License
--  along with this program; if not, write to the Free Software
--  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.NUMERIC_STD.ALL;

library work;
use work.all;
use FreezerDef.all;

entity OldOs is
    Port (	
		a: in vec16;
		rw: in std_logic;
		oldos_enable_n : in std_logic;

		output: out mem_output
	);
		
end OldOs;

architecture RTL of OldOs is

begin

access_oldos: process(a, rw, oldos_enable_n)
begin
	output.adr <= (others => '0');
	output.ram_access <= false;
	output.rom_access <= false;
	output.disable_atari <= false;
	output.dout <= (others => '0');
	output.dout_enable <= false;
	
	if (oldos_enable_n = '0') then
		case a(15 downto 12) is
		-- E000-FFFF: oldrunner OS
		when "1110" | "1111" =>
			output.adr <= oldos_rom_bank & a(12 downto 0);
			output.rom_access <= (rw = '1');
			output.disable_atari <= true;
		-- C000-CFFF: disable internal OS
		when "1100" =>
			output.disable_atari <= true;
		when others => null;
		end case;
	end if;
end process access_oldos;

end RTL;

