----------------------------------------------------------------------------------
--  PIA.vhd - 6520 PIA PORTB emulation logic
--
--  Copyright (C) 2011-2012 Matthias Reichl <hias@horus.com>
--
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 2 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--
--  You should have received a copy of the GNU General Public License
--  along with this program; if not, write to the Free Software
--  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.NUMERIC_STD.ALL;

library work;
use work.all;
use FreezerDef.all;

entity PIA is
    Port (	clk_register: in std_logic;
		a: in vec16;
		d_in: in vec8;
		rw: in std_logic;
		reset_n: in std_logic;
		portb: out vec8
	);
end PIA;

architecture RTL of PIA is

signal pia_crb2: std_logic;
signal pia_ddrb: vec8;
signal pia_portb: vec8;

begin

emulate_pia: process(clk_register)
begin
	if (falling_edge(clk_register)) then
		if (reset_n = '0') then
			pia_crb2 <= '0';
			pia_ddrb <= (others => '0');
			pia_portb <= (others => '0');
		else
			if (rw = '0') then
				case a is 
				when x"D301" =>
					if (pia_crb2 = '0') then
						pia_ddrb <= d_in;
					else
						pia_portb <= d_in;
					end if;
				when x"D303" =>
					pia_crb2 <= d_in(2);
				when others => null;
				end case;
			end if;
		end if;
	end if;
end process emulate_pia;

-- simulate pull-ups on inputs (ddrb is set to 0)
portb <= pia_portb OR (NOT pia_ddrb);

end RTL;

