----------------------------------------------------------------------------------
--  Ramdisk.vhd - 512k Ramdisk / RAM upgrade logic
--
--  Copyright (C) 2011-2012 Matthias Reichl <hias@horus.com>
--
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 2 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--
--  You should have received a copy of the GNU General Public License
--  along with this program; if not, write to the Free Software
--  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.NUMERIC_STD.ALL;

library work;
use work.all;
use FreezerDef.all;

entity Ramdisk is
	Port (	a: in vec16;
		portb: in vec8;
		ramdisk_enable_n: in std_logic;
		output: out mem_output
	);
		
end Ramdisk;

architecture RTL of Ramdisk is

begin
	access_ramdisk: process(a, portb, ramdisk_enable_n)
	begin
		output.adr <= (others => '0');
		output.ram_access <= false;
		output.rom_access <= false;
		output.disable_atari <= false;
		output.dout <= (others => '0');
		output.dout_enable <= false;

		if (a(15 downto 14) = "01") and (portb(4) = '0') and (ramdisk_enable_n = '0') then
			output.ram_access <= true;
			output.disable_atari <= true;
			output.adr <= ramdisk_base_bank(19) & portb(7 downto 5) & portb(3 downto 2) & a(13 downto 0);
		end if;
end process access_ramdisk;

end RTL;