; DAC test, 2010 KMK/DLT

	opt ?+

dmactls = $022f

iccmd	= $0342
icbufa	= $0344
icbufl	= $0348
icax1	= $034a
icax2	= $034b

jciov	= $e456

palette	= $80
cr	= $81
cg	= $82
cb	= $83
temp	= $84
temp2	= $85	;2 bytes

; VBXE MEMAC B bank numbers
MEMAC_B_BANK = $04

; addresses at Atari side
SCR_AD	= $4000
BCB_AD	= $4000
XDL_AD	= $4080

; adresses at VBXE side
VBXE_SCR_AD = SCR_AD-$4000
VBXE_BCB_AD = BCB_AD-$4000+65536
VBXE_XDL_AD = XDL_AD-$4000+65536

; other constants
BCB_SIZE = 21

; VBXE core registers
;
; read
;
VBXE_CR_VERSION		= $40		;core version ($10 = FX)
VBXE_CR_REVISION	= $41		;core revision
VBXE_CR_COLDETECT	= $4a		;collision detect
VBXE_CR_BLT_BUSY	= $53		;blitter status/busy
VBXE_CR_IRQ_STAT	= $54		;IRQ status
;
; write
;
VBXE_CR_VCTL		= $40		;video control
VBXE_CR_XDL_ADR0	= $41		;XDL pointer
VBXE_CR_XDL_ADR1	= $42		;
VBXE_CR_XDL_ADR2	= $43		;
VBXE_CR_CSEL		= $44		;colour select
VBXE_CR_PSEL		= $45		;colour select
VBXE_CR_CR		= $46		;component R
VBXE_CR_CG		= $47		;component G
VBXE_CR_CB		= $48		;component B
VBXE_CR_COLMASK		= $49		;collision mask
VBXE_CR_COLCLR		= $4a		;collision clear
;
VBXE_CR_BLT_ADR0	= $50		;BCB pointer
VBXE_CR_BLT_ADR1	= $51		;
VBXE_CR_BLT_ADR2	= $52		;
VBXE_CR_BLT_START	= $53		;blitter start
VBXE_CR_IRQ_CTL		= $54		;IRQ control
VBXE_CR_PRIOR_0		= $55		;priority 0
VBXE_CR_PRIOR_1		= $56		;priority 1
VBXE_CR_PRIOR_2		= $57		;priority 2
VBXE_CR_PRIOR_3		= $58		;priority 3
;
VBXE_CR_MB_CTL		= $5d		;MEMAC B control
VBXE_CR_MA_CTL		= $5e		;MEMAC A control
VBXE_CR_MA_BSEL		= $5f		;MEMAC A bank selection

	org $2000

start	jsr vbxe_detect
	bcc ?ver

?novbxe	lda #<no_vbxe_msg
	ldy #>no_vbxe_msg
	jmp putline

?ver	lda VBXE_CR_VERSION+$d600
	cmp #$10
	bne ?novbxe
?rev	lda VBXE_CR_VERSION+$d600+1
	and #$70
	cmp #$20
	bne ?novbxe

; enable MEMAC B bank 4

	ldy #VBXE_CR_MB_CTL
	lda #MEMAC_B_BANK+$80
	jsr _vbxe_write

; copy BCB blocks

	ldy #bcb_cls.?end-bcb_cls
?b0	lda bcb_cls,y
	sta BCB_AD,y
	dey
	bpl ?b0

; and XDL

	ldy #xdl0.?end-xdl0-1
?b1	lda xdl0,y
	sta XDL_AD,y
	dey
	bpl ?b1

; disable MEMAC B bank 5

	ldy #VBXE_CR_MB_CTL
	lda #$00
	jsr _vbxe_write

; clear screen (must go before palette initialization)

	ldx #$00
	jsr _blit

; enable MEMAC B bank 0

	ldy #VBXE_CR_MB_CTL
	lda #$80
	jsr _vbxe_write

; fill pattern

	ldx #$00
?fill	txa
	sta SCR_AD,x
	inx
	bne ?fill

	ldy #$00
	ldx #$fe
?f2	txa
	sta SCR_AD+256,y
	dex
	iny
	cpy #$40
	bcc ?f2

; disable MEMAC B bank

	ldy #VBXE_CR_MB_CTL
	lda #$00
	jsr _vbxe_write

; fill the screen with data

	ldx #(1*BCB_SIZE)
	jsr _blit

; initialize palettes

	lda #$00
	sta palette

?nxtpal	lda #$00
	sta cr
	sta cg
	sta cb

	ldy #VBXE_CR_PSEL
	lda palette
	jsr _vbxe_write

	ldy #VBXE_CR_CSEL
	lda #$00
	jsr _vbxe_write

?nxtcol	ldy #VBXE_CR_CR
	lda cr
	jsr _vbxe_write

	ldy #VBXE_CR_CG
	lda cg
	jsr _vbxe_write

	ldy #VBXE_CR_CB
	lda cb
	jsr _vbxe_write

	ldx palette
	cpx #$03
	bcc ?c1

	ldx #$00
	inc cg
	inc cb

?c1	inc cr,x
	bne ?nxtcol

	inc palette
	lda palette
	cmp #$04
	bcc ?nxtpal

; initialize display

	lda dmactls
	pha

	lda #$00
	sta dmactls

	sta $d099		;VBXE reset

	ldy #VBXE_CR_XDL_ADR0
?sxdla	lda vbxe_xdl_v-VBXE_CR_XDL_ADR0,y
	jsr _vbxe_write
	iny
	cpy #VBXE_CR_XDL_ADR2+1
	bcc ?sxdla

; display enable

	lda #$07
	ldy #VBXE_CR_VCTL
	jsr _vbxe_write

	jsr getkey

; overlay display off

?exit	ldy #VBXE_CR_VCTL
	lda #$00
	jsr _vbxe_write

	pla
	sta dmactls

; restore palette 0

	lda #$01
	sta temp
	lda #$00
	tax
	tay
	jsr load_palette

; GR.0 and exit to DOS

	ldx #$00
	lda #$0c
	jsr cioexe
	lda #<ename
	sta icbufa,x
	lda #>ename
	sta icbufa+1,x
	lda #$0c
	sta icax1,x
	lda #$00
	sta icax2,x
	lda #$03
	jmp cioexe

; -------------------------------------------------------------------

getkey	ldx #$10
	lda #$0c
	jsr cioexe
	lda #<kname
	sta icbufa,x
	lda #>kname
	sta icbufa+1,x
	lda #$04
	sta icax1,x
	lda #$00
	sta icax2,x
	lda #$03
	jsr cioexe
	lda #$00
	sta icbufl,x
	sta icbufl+1,x
	lda #$07
	jsr cioexe
	pha
	lda #$0c
	jsr cioexe
	pla
	rts

putline	ldx #$00
	sta icbufa,x
	tya
	sta icbufa+1,x
	lda #$ff
	sta icbufl,x
	lda #$09
cioexe	sta iccmd,x
	jmp jciov

kname	.byte 'K:',$9b
ename	.byte 'E:',$9b

; A - starting palette index
; TEMP - fetching step (1 for 256 colors, 2 for 128 etc.)
; Y - ending palette index + 1

load_palette
	sty temp2

	pha
	ldy #VBXE_CR_PSEL	;PSEL - palette select
	lda #$00
	jsr _vbxe_write
	pla

?l0	ldy #VBXE_CR_CSEL	;CSEL - color number
	jsr _vbxe_write
	iny
	sta temp2+1

	iny
	lda x_pal_r,x
	jsr _vbxe_write	;MB1	- R
	iny
	lda x_pal_g,x
	jsr _vbxe_write	;MB2	- G
	iny
	lda x_pal_b,x
	jsr _vbxe_write	;MB3	- B

	txa
	clc
	adc temp
	tax
	inc temp2+1
	lda temp2+1
	cmp temp2
	bne ?l0
	rts

_blit	ldy #VBXE_CR_BLT_BUSY		;$53 - wait for blitter ready
	jsr ?wbe

	ldy #VBXE_CR_BLT_ADR0
	clc
?setup	txa
	adc vbxe_bcb_v-VBXE_CR_BLT_ADR0,y
	jsr _vbxe_write
	ldx #$00
	iny
	tya
	eor #VBXE_CR_BLT_ADR2+1
	bne ?setup

;	ldy #VBXE_CR_BLT_START
	lda #$01
	jsr _vbxe_write

?wbe	lda $d600,y
	bne ?wbe
	rts

vbxe_bcb_v
	.long VBXE_BCB_AD
vbxe_xdl_v
	.long VBXE_XDL_AD

no_vbxe_msg
	.byte 'No VBXE or improper core',$9b

vbxe_detect
	jsr ?try
	bcc ?fnd

	inc start.?ver+2
	inc start.?rev+2
	inc _vbxe_write+2
	inc _blit.?wbe+2

?try	ldx $4000
	ldy #VBXE_CR_MB_CTL
	lda #$80
	jsr _vbxe_write
	cpx $4000
	bne ?fnd
	jsr ?clr
	inx
	stx $4000
	lda #$80
	jsr _vbxe_write
	cpx $4000
	bne ?fnd
	sec
	.byte $24
?fnd	clc
?clr	lda #$00
_vbxe_write
	sta $d600,y
	rts

bcb_cls
; clear screen and set attributes
	.long 0		;src adr
	.word 0		;src step y
	.byte 0		;src step x
	.long VBXE_SCR_AD ;dst adr
	.word 320	;dst step y
	.byte 1		;dst step x
	.word 320-1	;width
	.byte 192-1	;height
	.byte $00	;and mask
	.byte $00	;xor mask
	.byte $00	;collision mask
	.byte 0		;zoom
	.byte 0		;pattern
	.byte 0		;blt control

	.long VBXE_SCR_AD
	.word 0
	.byte 1
	.long VBXE_SCR_AD+320
	.word 320
	.byte 1
	.word 320-1
	.byte 192-1
	.byte $ff
	.byte $00
	.byte $00
	.byte 0
	.byte 0
	.byte 0
?end

; XDL

xdl0	.byte %01110100		;ovl off + map off + repeat + set screen address
	.byte %00001000		;palette/width/priority
	.byte 23		;repeat 24 times
	.long VBXE_SCR_AD	;screen address
	.word 320		;line length
	.byte $01		;PF palette 0, OVL palette 0, normal width
	.byte $ff		;priority: overlay over PF and PM

	.byte %00100010		;gfx mode + repeat
	.byte %00000000		;
	.byte 47		;repeat in 191 consecutive lines

	.byte %00100000		;repeat
	.byte %00001000		;
	.byte 47		;repeat in 191 consecutive lines
	.byte $11		;PF palette 0, OVL palette 1, normal width
	.byte $ff		;priority: overlay over PF and PM

	.byte %00100000		;repeat
	.byte %00001000		;
	.byte 47		;repeat in 191 consecutive lines
	.byte $21		;PF palette 0, OVL palette 2, normal width
	.byte $ff		;priority: overlay over PF and PM

	.byte %00100000		;repeat
	.byte %10001000		;end record
	.byte 47		;repeat in 191 consecutive lines
	.byte $31		;PF palette 0, OVL palette 2, normal width
	.byte $ff		;priority: overlay over PF and PM
?end

x_pal_b	icl 'laoo_b.s'
x_pal_g	icl 'laoo_g.s'
x_pal_r	icl 'laoo_r.s'

	org $02e0
	.word start
