;

        opt     l-
        icl     'atarihw.ah'
        icl     'atarios.ah'
        icl     'vbxefx.asm'
        opt     l+


        .zpvar ptr1 .word
        .zpvar gpr1 .byte
        .zpvar s1flag .byte
        .zpvar s2flag .byte
        .zpvar surface .byte
        .zpvar xc .byte
        .zpvar yc .byte
        .zpvar xr .word
        .zpvar sindex .byte
        .zpvar start .byte
        .zpvar sx0 .word
        .zpvar sx1 .word
        .zpvar sx2 .byte


base            equ     $0000  ;alias of vram_base
sbuf            equ     $0200  ;alias of vram_sbuf
ebuf            equ     $0500  ;alias of vram_ebuf
cbuf            equ     $0800  ;alias of vram_cbuf
ybuf            equ     $0b00  ;alias of vram_ybuf
fxdata          equ     $0e00

fontadrl        equ     $2000
fontadrh        equ     $2100
loya            equ     $2200
hiya            equ     $2300
miya            equ     $2400
palette         equ     $2500 ;$300


; adresy w VRAM
vram_surface1   equ     $00000 ;$13b00 336x240
vram_font       equ     $14000 ;$400
vram_bcbchain1  equ     $14800 ;$35e5 ;(656+1) x BCB
vram_bcbchain2  equ     $17e00 ;$35e5 ;(656+1) x BCB
vram_surface2   equ     $20000 ;$13b00 336x240
vram_base       equ     $34000
vram_sbuf       equ     $34200 ;$290 ;scroll
vram_ebuf       equ     $34500 ;$290 ;sizes
vram_cbuf       equ     $34800 ;$290 ;colors
vram_ybuf       equ     $34b00 ;$290 ;y positions
vram_sin1       equ     $35000 ;$200 ;y sinus
vram_sin2       equ     $35200 ;$200 ;size sinus
vram_pictureA   equ     $40000 ;$13b00 336x240 background
vram_pictureB   equ     $60000 ;$13b00 336x240 foreground

vram_bcb3       equ     bcb3+vram_base
vram_xdl1       equ     xdl1+vram_base
vram_xdl2       equ     xdl2+vram_base
vram_bcb1       equ     bcb1+vram_base
vram_bcb2       equ     bcb2+vram_base
vram_bcb5       equ     bcb5+vram_base
vram_bcbnop     equ     bcbnop+vram_base
vram_bcbf       equ     bcbf+vram_base
vram_bcby       equ     bcby+vram_base

;---------------------------------------------------------------------

        org     $3000

bank    .word 0
BankSet lda     bank
        fxsa    FX_MEMA
        lda     bank+1
        fxsa    FX_MEMS
        rts

main    equ     *

vbxeDetect
        DetectCore
        rts
vbxeReset
        ResetCore
        rts
init0   jsr     vbxeDetect
        jeq     vbxeReset
        jmp     (DOSVEC)
        ini     init0

;---------------------------------------------------------------------

        org     main

        lda     TIMER
        cmp     TIMER
        req
        sei
        lda     #0
        sta     NMIEN
        sta     IRQEN
        sta     DMACTL
        sta     COLBAK
        lda     #$fe
        sta     PORTB
        cld
        tsx
        stx     sr

        ;MAMAC-A window $0000-$0fff
        ;vram_base range visible there
        lda     fxptr+1
        sta     fxptrs
        lda     #$08
        fxsa    FX_MEMA
        lda     #$80+vram_base/$1000
        fxsa    FX_MEMS
        lda     #0
        sta     fxptr
fxptrs  equ     *+1
        lda     #0
        sta     fxptr+1
        jsr     DataInit
        lda     <nmi
        sta     NMIV
        lda     >nmi
        sta     NMIV+1
        lda     #$40
        sta     NMIEN

        lda     #1
        sta     start

loop    jmp     Blitter
key_    jsr     Keyboard
        bne     loop
        lda     #0
        sta     start
        sta     FX_CORE_RESET
        ldx     sr
        txs
        jsr     BankSet
        lda     #$ff
        sta     PORTB
        cli
        rts

sr      .byte   0

Keyboard
        lda     SKSTAT
        and     #SKSTAT_KEYPRESS
        rts

DataInit
        .local

        ldx     #1
        lda     #0
        sta     loya
        sta     hiya
        sta     miya
di1     lda     loya-1,x
        clc
        adc     <336
        sta     loya,x
        lda     hiya-1,x
        adc     >336
        sta     hiya,x
        lda     miya-1,x
        adc     ^336
        sta     miya,x
        inx
        bne     di1

        lda     <vram_font
        sta     ptr1
        lda     >vram_font
        sta     ptr1+1
di6     lda     ptr1
        sta     fontadrl,x
        clc
        adc     #16
        sta     ptr1
        lda     ptr1+1
        sta     fontadrh,x
        adc     #0
        sta     ptr1+1
        inx
        bne     di6

        lda     #0
        sta     s1flag
        sta     s2flag
        sta     sindex
        sta     surface
        sta     start
        sta     sx0
        sta     sx0+1
        sta     sx1
        sta     sx1+1
        sta     sx2

        lda     fxptr+1
        sta     Blitter.xp11+2
        sta     Blitter.xp12+2

        lda     #1
        fxsa    FX_PSEL
        lda     #0
        fxsa    FX_CSEL
        tax
pcpy    lda     palette,x
        fxsa    FX_CR
        lda     palette+$100,x
        fxsa    FX_CG
        lda     palette+$200,x
        fxsa    FX_CB
        inx
        bne     pcpy

        lda     #0
        fxsa    FX_BLITTER_START

        /*
        lda     <vram_bcbf
        fxsa    FX_BL_ADR0
        lda     >vram_bcbf
        fxsa    FX_BL_ADR1
        lda     ^vram_bcbf
        fxsa    FX_BL_ADR2
        lda     #1
        fxsa    FX_BLITTER_START
di7     fxla    FX_BLITTER_BUSY
        jne     di7
        */

        lda     <vram_bcb2
        fxsa    FX_BL_ADR0
        lda     >vram_bcb2
        fxsa    FX_BL_ADR1
        lda     ^vram_bcb2
        fxsa    FX_BL_ADR2
        lda     #1
        fxsa    FX_BLITTER_START
di8     fxla    FX_BLITTER_BUSY
        jne     di8

        rts
        .endl


nmi
        .local
        pha
        tya
        pha
        inc     sx0
        sne
        inc     sx0+1
        lda     start
        cmp     #2
        jne     n1
        lda     surface
        eor     #1
        sta     surface
        jeq     n3
        lda     <vram_xdl1
        fxsa    FX_XDL_ADR0
        lda     >vram_xdl1
        fxsa    FX_XDL_ADR1
        lda     ^vram_xdl1
        fxsa    FX_XDL_ADR2
        jmp     n2
n3      lda     <vram_xdl2
        fxsa    FX_XDL_ADR0
        lda     >vram_xdl2
        fxsa    FX_XDL_ADR1
        lda     ^vram_xdl2
        fxsa    FX_XDL_ADR2
n2      lda     #VC_XDL_ENABLED+VC_NO_TRANS
        fxsa    FX_VIDEO_CONTROL
        lda     sx0
        sta     sx1
        lda     sx0+1
        sta     sx1+1
        dec     start
n1      pla
        tay
        pla
        rti
        .endl

Blitter .local

        lda     start
        cmp     #1
        seq
        jmp     key_

        lda     sx1
        sta     gpr1
        lda     sx1+1
        lsr     @
        ror     gpr1
        lsr     @
        ror     gpr1
        lsr     @
        ror     gpr1
sl0     lda     gpr1
        cmp     sx2
        jeq     insync
        inc     sx2
        and     #7
        tax
        lda     bitmask,x
        sta     bcb1a_and_mask
        bpl     sl3
        ldx     sindex
sl2     lda     text,x
        bpl     sl21
        ldx     #0
        beq     sl2
sl21    inx
        stx     sindex
        tax
        lda     fontadrl,x
        sta     bcb1a_font_adr
        lda     fontadrh,x
        sta     bcb1a_font_adr+1
sl3     lda     <vram_bcb1
        fxsa    FX_BL_ADR0
        lda     >vram_bcb1
        fxsa    FX_BL_ADR1
        lda     ^vram_bcb1
        fxsa    FX_BL_ADR2
sl4     fxla    FX_BLITTER_BUSY
        jne     sl4
        lda     #1
        fxsa    FX_BLITTER_START
        jmp     sl0

insync
        ;y move
        ;sqare size animation
        ;colours change
        lda     sx1
        sta     bcbea1
        sta     bcbya1
        lda     <vram_bcby
        fxsa    FX_BL_ADR0
        lda     >vram_bcby
        fxsa    FX_BL_ADR1
        lda     ^vram_bcby
        fxsa    FX_BL_ADR2
is1     fxla    FX_BLITTER_BUSY
        jne     is1
        lda     #1
        fxsa    FX_BLITTER_START

        ;surface draw
        lda     sx1
        and     #7
        eor     #7
        sta     xr1
        lda     surface
        bne     xsurf2

xsurf1  lda     <(vram_bcbchain1-21)
        sta     bcb4a2
        lda     >(vram_bcbchain1-21)
        sta     bcb4a2+1
        lda     <(vram_bcbchain1+2)
        sta     bcb5a1
        sta     bcb5a2
        lda     >(vram_bcbchain1+2)
        sta     bcb5a1+1
        sta     bcb5a2+1
        lda     <vram_bcbchain1
        fxsa    FX_BL_ADR0
        lda     >vram_bcbchain1
        fxsa    FX_BL_ADR1
        lda     ^vram_bcbchain1
        fxsa    FX_BL_ADR2
        sta     bcb4a2+2
        sta     bcb5a1+2
        sta     bcb5a2+2
        lda     ^(vram_pictureB ^ vram_surface1)
        sta     xl4e
        lda     s1flag
        jne     xpaint
        inc     s1flag
        bne     xpaint1

xsurf2  lda     <(vram_bcbchain2-21)
        sta     bcb4a2
        lda     >(vram_bcbchain2-21)
        sta     bcb4a2+1
        lda     <(vram_bcbchain2+2)
        sta     bcb5a1
        sta     bcb5a2
        lda     >(vram_bcbchain2+2)
        sta     bcb5a1+1
        sta     bcb5a2+1
        lda     <vram_bcbchain2
        fxsa    FX_BL_ADR0
        lda     >vram_bcbchain2
        fxsa    FX_BL_ADR1
        lda     ^vram_bcbchain2
        fxsa    FX_BL_ADR2
        sta     bcb4a2+2
        sta     bcb5a1+2
        sta     bcb5a2+2
        lda     ^(vram_pictureB ^ vram_surface2)
        sta     xl4e
        lda     s2flag
        jne     xpaint
        inc     s2flag
        bne     xpaint1

xpaint  fxla    FX_BLITTER_BUSY
        jne     xpaint
        lda     #1
        fxsa    FX_BLITTER_START

xpaint1 lda     #0
        sta     ea
        sta     sa
        sta     ya
        lda     >ebuf
        sta     ea+1
        lda     >sbuf
        sta     sa+1
        lda     >ybuf
        sta     ya+1
        lda     <vram_bcb3
        fxsa    FX_BL_ADR0
        lda     >vram_bcb3
        fxsa    FX_BL_ADR1
        lda     ^vram_bcb3
        fxsa    FX_BL_ADR2
        lda     #15
        sta     yc

xw      fxla    FX_BLITTER_BUSY
        jne     xw

yloop   lda     #40
        sta     xc
xr1     equ     *+1
        lda     #0
        sta     xr
        lda     #0
        sta     xr+1
xloop   ldy     xc
sa      equ     *+1
        lda     $ff00,y ;sbuf
        beq     xl3
ea      equ     *+1
        ldx     $ff00,y ;ebuf
ya      equ     *+1
        lda     $ff00,y ;ybuf
        clc
        adc     stab,x
        tay
        lda     loya,y
        adc     xr
        bcc     xl1
        adc     stab1,x
        sec
        bcs     xl2
xl1     adc     stab,x
xl2     txs
xp11    ldx     $ff00+FX_BLITTER_BUSY
        bne     xp11
        tsx
        stx     bcb3sx
        stx     bcb3sy
        sta     bcb3a1
        sta     bcb3a2
        lda     hiya,y
        adc     xr+1
        sta     bcb3a1+1
        sta     bcb3a2+1
        lda     miya,y
        adc     ^vram_pictureB ;pictureB high adr
        sta     bcb3a1+2
xl4e    equ     *+1
        eor     #0 ;surface1/2 high adr
        sta     bcb3a2+2
        lda     bcb4a2
        adc     #21
        sta     bcb4a2
        scc
        inc     bcb4a2+1
        lda     #1
xp12    sta     $ff00+FX_BLITTER_START
xl3     lda     xr
        clc
        adc     #8
        sta     xr
        scc
        inc     xr+1
        dec     xc
        bpl     xloop
        lda     ea
        clc
        adc     #41
        sta     ea
        sta     sa
        sta     ya
        bcc     yl1
        inc     ea+1
        inc     sa+1
        inc     ya+1
yl1     dec     yc
        jpl     yloop

        lda     bcb4a2
        clc
        adc     #21
        sta     bcb6a2
        lda     bcb4a2+1
        adc     #0
        sta     bcb6a2+1
        lda     bcb4a2+2
        adc     #0
        sta     bcb6a2+2
        lda     <vram_bcb5
        fxsa    FX_BL_ADR0
        lda     >vram_bcb5
        fxsa    FX_BL_ADR1
        lda     ^vram_bcb5
        fxsa    FX_BL_ADR2
c1      fxla    FX_BLITTER_BUSY
        bne     c1
        lda     #1
        fxsa    FX_BLITTER_START
        inc     start
        jmp     key_

bitmask .byte $80,$40,$20,$10,$08,$04,$02,$01
text    .byte "ATARI 130XE VBXE BY ELECTRON AND CANDLE  - BLITTER DEMO -  ",255
        .endl

;---------------------------------------------------------------------

        ;memac-A $2000-2fff
        ;vram $14000-$14fff
        org     bank
        .byte   $28
        .byte   $80+vram_font/$1000
        ini     BankSet
        org     $2000+vram_font%$1000

        /*
        .rept   64
        ins    'fonts.bin',2+(#*8),8
        ins    'fonts.bin',2+512+(#*8),8
        .endr
        */

        .rept   128
        ins     'gora.fnt',#*8,8
        ins     'dol.fnt',#*8,8
        .endr

;---------------------------------------------------------------------

        ;memac-A $2000-2fff
        ;vram $34000-$34fff
        org     bank
        .byte   $28
        .byte   $80+vram_base/$1000
        ini     BankSet

        zpfxdata equ $100-(bcb4end-stab)
        org zpfxdata,$2000+zpfxdata

stab    .byte   3,3,2,2,1,1,0,0
stab1   .byte   2,2,1,1,0,0,255,255

;blitting squares to hidden surface,
;create bcb chain for subsequent clear
bcb3
bcb3a1  .long vram_pictureB
        .word 336
        .byte 1
bcb3a2  .long vram_surface1
        .word 336
        .byte 1
bcb3sx  .word 0
bcb3sy  .byte 0
        .byte 0xff
        .byte 0
        .byte 0
        .byte 0
        .byte 0
        .byte 8 ;NEXT
bcb4    .long vram_bcb3
        .word 0
        .byte 1
bcb4a2  .long vram_bcbchain1
        .word 0
        .byte 1
        .word 20
        .byte 0
        .byte 0xff
        .byte 0
        .byte 0
        .byte 0
        .byte 0
        .byte 0 ;END
bcb4end equ *

;---------------------------------------------------------------------

        org fxdata,$2000+fxdata

        ;sbuf move
bcb1    .long vram_sbuf+39
        .word 41
        .byte -1
        .long vram_sbuf+40
        .word 41
        .byte -1
        .word 39
        .byte 15
        .byte 0xff
        .byte 0
        .byte 0
        .byte 0
        .byte 0
        .byte 8 ;NEXT
bcb1a
bcb1a_font_adr
        .long vram_font
        .word 0
        .byte 1
        .long vram_sbuf
        .word 0
        .byte 41
        .word 15
        .byte 0
bcb1a_and_mask
        .byte 0x80
        .byte 0
        .byte 0
        .byte 0
        .byte 0
        .byte 0 ;END


;initial surface blit
bcb2    .long vram_pictureA+8
        .word 336
        .byte 1
        .long vram_surface1+8
        .word 336
        .byte 1
        .word 319
        .byte 239
        .byte 0xff
        .byte 0
        .byte 0
        .byte 0
        .byte 0
        .byte 8 ;NEXT
        .long vram_pictureA+8
        .word 336
        .byte 1
        .long vram_surface2+8
        .word 336
        .byte 1
        .word 319
        .byte 239
        .byte 0xff
        .byte 0
        .byte 0
        .byte 0
        .byte 0
        .byte 8 ;NEXT
        .long 0
        .word 0
        .byte 0
        .long vram_sbuf
        .word 41
        .byte 1
        .word 40
        .byte 15
        .byte 0
        .byte 0
        .byte 0
        .byte 0
        .byte 0
        .byte 0 ;END

;swap picB -> picA adrs in chain
bcb5
bcb5a1  .long vram_bcbchain1+2
        .word 82*21
        .byte 21
bcb5a2  .long vram_bcbchain1+2
        .word 82*21
        .byte 21
        .word 81
        .byte 7
        .byte 0xff
        .byte ^(vram_pictureB^vram_pictureA)
        .byte 0
        .byte 0
        .byte 0
        .byte 8 ;NEXT
bcb6    .long vram_bcbnop
        .word 0
        .byte 1
bcb6a2  .long vram_bcbchain1
        .word 0
        .byte 1
        .word 20
        .byte 0
        .byte 0xff
        .byte 0
        .byte 0
        .byte 0
        .byte 0
        .byte 0 ;END

bcbnop  .long 0
        .word 0
        .byte 0
        .long 0
        .word 0
        .byte 0
        .word 0
        .byte 0
        .byte 0xff
        .byte 0
        .byte 0
        .byte 0
        .byte 0
        .byte 0 ;END

bcby
bcbya1  .long vram_sin1
        .word 0
        .byte 1
        .long vram_ybuf+40
        .word 0
        .byte -1
        .word 40
        .byte 0
        .byte 0xff ;and
        .byte 0 ;xor
        .byte 0
        .byte 0
        .byte 0
        .byte 8 ;NEXT
        .long 0
        .word 0
        .byte 0
        .long vram_ybuf+41
        .word 41
        .byte 1
        .word 40
        .byte 14
        .byte 0 ;and
        .byte 8 ;xor
        .byte 0
        .byte 0
        .byte 0
        .byte 8 ;NEXT
        .long vram_ybuf
        .word 41
        .byte 1
        .long vram_ybuf+41
        .word 41
        .byte 1
        .word 40
        .byte 14
        .byte 0xff ;and
        .byte 0 ;xor
        .byte 0
        .byte 0
        .byte 0
        .byte 2+8 ;ADD+NEXT
bcbea1  .long vram_sin2
        .word 1
        .byte 1
        .long vram_ebuf+40
        .word 41
        .byte -1
        .word 40
        .byte 15
        .byte 7 ;and
        .byte 0 ;xor
        .byte 0
        .byte 0
        .byte 0
        .byte 0 ;END


        ;test - fill - bcb
bcbf    /*
        .long 0
        .word 0
        .byte 0
        .long vram_pictureA
        .word 336
        .byte 1
        .word 335
        .byte 239
        .byte 0 ;and
        .byte 1 ;xor
        .byte 0
        .byte 0
        .byte 0
        .byte 8 ;NEXT
        */

        .long 0
        .word 0
        .byte 0
        .long vram_pictureB
        .word 336
        .byte 1
        .word 335
        .byte 239
        .byte 0 ;and
        .byte 2 ;xor
        .byte 0
        .byte 0
        .byte 0
        .byte 0 ;END

xdl1    .word XDLC_GMON+XDLC_OVADR+XDLC_RPTL+XDLC_END
        .byte 239
        .long vram_surface1+8
        .word 336
xdl2    .word XDLC_GMON+XDLC_OVADR+XDLC_RPTL+XDLC_END
        .byte 239
        .long vram_surface2+8
        .word 336

fxde    equ     *

;---------------------------------------------------------------------
        ;memac-A $2000-2fff
        ;vram $35000-$35fff
        org     bank
        .byte   $28
        .byte   $80+vram_sin1/$1000
        ini     BankSet

        org     $2000
        .byte   sin(56,52,256,0,511)
        .byte   sin(4,3,32,0,511)

;---------------------------------------------------------------------

        ;vram_pictureA
        vins $2000,$1000,(336*240),0,vram_pictureB,'atom.dap'
        vins $2000,$1000,(336*240),0,vram_pictureA,'atom.dap'+128
;---------------------------------------------------------------------

        org palette
        ins 'atom.dap',+(336*240),256*3

;---------------------------------------------------------------------

        run main

        end
