@echo off
cls

set PROJECTNAME=WB2
set prjpath=%cd%
set ma=%prjpath%\bin\mads.exe
set bc=%prjpath%\bin\cmdcruncher.exe
set include=%prjpath%\include
set lib=%prjpath%\lib
set build=%prjpath%\build
set parts=%prjpath%\parts

call:printHeader
call:printConfig
call:compileLib
call:compileOs
call:compileLoader
call:compile_pinready
call:compile_splash
call:compileStaticData01
call:compilepar01
call:compileStaticData02
call:compilepar02
call:compileStaticData03
call:compilepar03
call:compileStaticData04
call:compile_endpart
call:compile_rotozoomer1
call:compile_rotozoomer2
call:compile_plazma
call:compile_decrunching
call:compileTheend
call:compileQuickshot
del /q %build%\*.bc
del /q %build%\*.obx



:endBuild
cd %prjpath%
goto:eof

:compileLib
echo.compile LIB
echo.compile dir: %lib%
call:compile rmtplayr8 %lib%
echo.
goto:eof

:compileOs
echo.compile OS
set tp=%parts%\os
echo.compiel dir: %tp%
call:compile os %tp%
call:crunch os
echo.
goto:eof

:compile_pinready
echo.compile PINREADY
set tp=%parts%\pinready
echo.compile dir: %tp%
call:compile pinready %tp%
call:crunch pinready
echo.
goto:eof

:compile_splash
echo.compile SPLASH SCREEN
set tp=%parts%\splash
echo.compile dir: %tp%
call:compile splash %tp%
call:crunch splash
echo.
goto:eof

:compileLoader
echo.compile LOADER
set tp=%parts%\loader
echo.compile dir: %tp%
call:compileInPlace bank_switcher %tp%
call:compile config_detecthw %tp%
call:crunch config_detecthw
echo.
goto:eof

:compileStaticData01
echo.compile STATICDATA01
set tp=%parts%\staticdata01
echo.compile dir: %tp%
call:compile staticdata01 %tp%
echo.
goto:eof

:compilepar01
echo.compile PART 01
set tp=%parts%\01_part
echo.compile dir: %tp%
call:compile 01_part %tp%
call:crunch 01_part
echo.
goto:eof


:compileStaticData02
echo.compile STATICDATA02
set tp=%parts%\staticdata02
echo.compile dir: %tp%
call:compile staticdata02_1 %tp%
call:compile staticdata02_2 %tp%
echo.
goto:eof

:compilepar02
echo.compile PART 02
set tp=%parts%\02_part
echo.compile dir: %tp%
call:compile 02_part %tp%
call:crunch 02_part
echo.
goto:eof

:compileStaticData03
echo.compile STATICDATA03
set tp=%parts%\staticdata03
echo.compile dir: %tp%
call:compile staticdata03_1 %tp%
call:compile staticdata03_2 %tp%
echo.
goto:eof

:compilepar03
echo.compile PART 03
set tp=%parts%\03_part
echo.compile dir: %tp%
call:compile 03_part %tp%
call:crunch 03_part
echo.
goto:eof

:compileStaticData04
echo.compile STATICDATA04
set tp=%parts%\staticdata04
echo.compile dir: %tp%
call:compile staticdata04_1 %tp%
call:compile staticdata04_2 %tp%
echo.
goto:eof

:compile_endpart
echo.compile END PART
set tp=%parts%\end_part
echo.compile dir: %tp%
call:compile end_part %tp%
call:crunch end_part
echo.
goto:eof
 

:compile_rotozoomer1
echo.compile ROTOZOOMER 01
set tp=%parts%\rotozoomer1
echo.compile dir: %tp%
call:compile rotozoomer %tp%
call:crunch rotozoomer
echo.
goto:eof

:compile_rotozoomer2
echo.compile ROTOZOOMER 02
set tp=%parts%\rotozoomer2
echo.compile dir: %tp%
call:compile rotozoomer1 %tp%
call:crunch rotozoomer1
echo.
goto:eof


:compile_plazma
echo.compile PLAZMA
set tp=%parts%\plazma
echo.compile dir: %tp%
call:compile plazma %tp%
call:crunch plazma
echo.
goto:eof

:compile_decrunching
echo.compile DECRUNCHING
set tp=%parts%\decrunching
echo.compile dir: %tp%
call:compile decrunching %tp%
call:crunch decrunching
echo.
goto:eof

:compileTheend
echo.compile THE END
set tp=%parts%\theend
echo.compile dir: %tp%
call:compile theend %tp%
call:crunch theend
echo.
goto:eof

:compileQuickshot
echo.compile MAIN FILE WB2 PROJECT
set tp=%prjpath%\
echo.compile dir: %tp%
call:compile quickshot %tp%
move %build%\quickshot.obx %build%\wb2.xex
echo.
goto:eof

:compile
echo.compile file: %2\%1.asx
set t=%ma% %2\%1.asx -o:%build%\%1.obx -i:%include% -s -t
%t%
if %errorlevel% NEQ 0 (
	echo.blad wykonania polecenia: %t%
	echo.kod bledu: %errorlevel%
	goto:terminate
)
goto:eof

:compileInPlace
echo.compile file: %2\%1.asx
cd %2
set t=%ma% %1.asx -o:%1.obx -i:%include% -s -t
%t%
if %errorlevel% NEQ 0 (
	echo.blad wykonania polecenia: %t%
	echo.kod bledu: %errorlevel%
	goto:terminate
)
cd %prjpath%
goto:eof

:crunch
echo.crunch file: %1.obx
set t=%bc% -i %build%\%1.obx -o %build%\%1.bc -binfile -nosafeldadr
%t%
if %errorlevel% NEQ 0 (
	echo.blad wykonywania polecenia: %t%
	echo.kod bledu: %errorlevel%
	goto:terminate
)
goto:eof


:printHeader
echo.*********************************
echo.*** Lamers 2013, project %PROJECTNAME%  ***
echo.*** build script by ajcek/LMS ***
echo.*********************************
echo.
echo.
goto:eof

:printConfig
echo.project %PROJECTNAME% configuration set
echo. main project path = %prjpath%
echo. compiler          = %ma%
echo. cruncher          = %bc%
echo. lib path          = %lib%
echo. include path      = %include%
echo. build path        = %build%
echo. parts path        = %parts%
echo.
echo.
goto:eof  

:terminate
cd %prjpath%
exit /b 5