
// plasma na VBXE - CORE REV 1.20
// pixel 4x4, 256 colors, screen 160x196, colors map = 160*49 -> 7840 bytes 

	icl 'vbxefx.asm'
	icl 'atari.hea'

color_map0	= $100
color_map1	= $2000

ymax	equ 49


	org $2000
	.zpvar = $f0
	
detect	DetectCore

	beq ok

	jsr printf
	dta $9b
	dta c'Core revision <> 1.20',$9b,0

	pla
	pla
	rts

ok	rts

	.link 'printf.obx'

	ini detect	


//--------------------------------------------------------------
//--------------------------------------------------------------


	org $80

cmap	.ds 2

//--------------------------------------------------------------
//--------------------------------------------------------------


// bitmapa z obrazkiem Blinky Scary School, omijamy 24 bajty i pokazujemy 14 ostatnich bajtw
// pozostae 26 bajtw z linii to bitmapa dla plasmy

	org $8010
bmp
	.get 'mic.dat'

	.rept ymax*4
	.sav[#*40+24] 14
	:26 dta %01011010
	.endr


// program Dlisty dla Antic-a, YMAX*4 linii

	.align $200

dlist	dta d'ppp'
	:ymax*4 dta $4e,a(bmp+#*40)
	dta $41,a(dlist)


// program XDlisty dla VBXE, zostanie on skopiowany po wczeniu banku VBXE pod adres $4000 (MEMAC_B_WINDOW)
// (w pamici VBXE jest to adres $0000)

xdlist	equ *

        ;XDLC
        ;24 puste linie od gry ekranu ...
	.word   XDLC_RPTL
	.byte   3*8-1

        ;XDLC
        ;w-czam map koloru pokrywajc 200 linii
        ;jednoczenie jest to koniec XDL (XDLC_END)
        .word   XDLC_END + XDLC_RPTL + XDLC_MAPON + XDLC_MAPADR + XDLC_MAPPAR

        ;XDLC_RPTL
        ;razem 200 linii z map koloru
        .byte  ymax*4-1

        ;XDLC_MAPADR
        ;adres mapy koloru bezporednio za XDL w pamici VBXE

cmap_adres = *-xdlist+MEMAC_B_WINDOW

        .long   color_map0
        ;krok adresu mapy
        .word   40*4

        ;XDLC_MAPPAR
        .byte   0 ;hscroll mapy
        .byte   0 ;vscroll mapy
        .byte   7 ;szeroko pola
        .byte	4-1 ;wysoko pola


        ;dane mapy koloru
        ;zostan te przekopiowane do pamici VBXE


//--------------------------------------------------------------

main	fxs #$80 MEMB		; bank #0 w obszarze $4000..$7fff

	lda #0

	fxsa XDL_ADR0			; adres XDlisty = $0000
	fxsa XDL_ADR1
	fxsa XDL_ADR2

	tay
cp	lda xdlist,y			; kopiowanie XDlisty -> MEMAC_B_WINDOW
	sta MEMAC_B_WINDOW,y
	iny
	bne cp

; wczamy XDliste i tryb 256 kolorw (normalnie byoby 128 kolorw, bit0=0)
	lda #VC_XDL_ENABLED|VC_XCOLOR
	fxsa VIDEO_CONTROL


 	ldx #ymax			; skopiowanie mapy kolorw Blinky do obydwch buforw z map kolorw
copyC 	ldy #0
c0	lda blinky_cmap,y
c1	sta MEMAC_B_WINDOW+color_map0,y
c2	sta MEMAC_B_WINDOW+color_map1,y
	iny
	cpy #14*4
	bne c0

	adw c0+1 #14*4
	adw c1+1 #40*4
	adw c2+1 #40*4

	dex
	bne copyC
 
 
	mwa #dlist 560

	lda #%00100011
	sta 559

	lda:cmp:req 20

	sei
	lda #0
	sta $d40e

	sta cmap

	lda #$fe
	sta $d301

	mwa #nmi $fffa

	lda #$40
	sta $d40e

//--------------------------------------------------------------
//	P L A S M A
//--------------------------------------------------------------

repeat	lda:cmp:req cloc

	lda cmap_adres+1
	eor #[>color_map0]^[>color_map1]
	sta cmap_adres+1

	eor #[>color_map0]^[>color_map1]
	ora >MEMAC_B_WINDOW
	sta cmap+1

	lda #$00
	sta cmap
	sta py+1

ofs1	lda #0
	sta s1+1
	sta s3+1
	sta s1_+1

ofs2	lda #0
	sta s4+1

	inc pl0+1

py	ldy #0

*---------
* petla X        ;glowna petla
*---------
loop

s3	lda sine3,y
	clc
s4	adc sine4,y

pl0	adc #0

	sta st2+1
	sta st2_+1

	ldx #14

	sec

s1	lda sine1,x
st2	sbc #0
	sta p0_+1

	txa
	:2 asl @
	tay

p0_	lda pallete
	sta (cmap),y

s1_	lda sine1_,x
st2_	sbc #0
	sta p1_+1

p1_	lda pallete

	iny
	sta (cmap),y
	
	:2 iny
	lda #0
	sta (cmap),y

	inx
	cpx #40
	bne s1

	adw cmap #40*4
	
	inc py+1
	ldy py+1
	cpy #ymax
	bne loop
 
	inc ofs1+1
	dec ofs2+1

	jmp repeat


//--------------------------------------------------------------

nmi	pha
	sta $d40f

	mwa #dlist dlptr

	mva #scr40 dmactl

	inc cloc

	pla
	rti

cloc	brk


// mapa kolorw z obrazka Blinky Scary School

blinky_cmap
	.get 'col.map'

	:ymax .sav[#*40*4+24*4] 14*4


// wartosci dla palety kolorw 

	.align
pallete
	.rept 8,#
	:+16 dta #+:1*32
	:+16 dta 15-#+:1*32
	.endr


// tablica sinusow decydujaca o ksztacie plazmy

	.align
sine1	= *
sine1_	= sine1+$200
sine3	= sine1_+$200
sine4	= sine3+$200

	ins 'pls3.dat' 

	.print *
//--------------------------------------------------------------

	run main
